/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.replaceConstructorWithFactory;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.replaceConstructorWithFactory.ReplaceConstructorWithFactoryDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ReplaceConstructorWithFactoryHandler
implements RefactoringActionHandler {
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"replace.constructor.with.factory.method.title");
    private Project myProject;

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2, DataContext dataContext) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/replaceConstructorWithFactory/ReplaceConstructorWithFactoryHandler", "invoke"));
        }
        int offset = editor.getCaretModel().getOffset();
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement element = file2.findElementAt(offset);
        while (true) {
            if (element == null || element instanceof PsiFile) {
                String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.constructor"));
                CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.replaceConstrWithFactory");
                return;
            }
            if (element instanceof PsiReferenceExpression) {
                PsiElement psiElement = ((PsiReferenceExpression)element).resolve();
                if (psiElement instanceof PsiMethod && ((PsiMethod)psiElement).isConstructor()) {
                    this.invoke(project2, new PsiElement[]{psiElement}, dataContext);
                    return;
                }
            } else if (element instanceof PsiConstructorCall) {
                PsiElement classElement;
                PsiJavaCodeReferenceElement classReference;
                PsiConstructorCall constructorCall = (PsiConstructorCall)element;
                PsiMethod method = constructorCall.resolveConstructor();
                if (method != null) {
                    this.invoke(project2, new PsiElement[]{method}, dataContext);
                    return;
                }
                if (element instanceof PsiNewExpression && (classReference = ((PsiNewExpression)element).getClassReference()) != null && (classElement = classReference.resolve()) instanceof PsiClass) {
                    this.invoke(project2, new PsiElement[]{classElement}, dataContext);
                    return;
                }
            }
            if (element instanceof PsiClass && !(element instanceof PsiAnonymousClass) && ((PsiClass)element).getConstructors().length == 0) {
                this.invoke(project2, new PsiElement[]{element}, dataContext);
                return;
            }
            if (element instanceof PsiMethod && ((PsiMethod)element).isConstructor()) {
                this.invoke(project2, new PsiElement[]{element}, dataContext);
                return;
            }
            element = element.getParent();
        }
    }

    public void invoke(@NotNull Project project2, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/replaceConstructorWithFactory/ReplaceConstructorWithFactoryHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/replaceConstructorWithFactory/ReplaceConstructorWithFactoryHandler", "invoke"));
        }
        if (elements.length != 1) {
            return;
        }
        this.myProject = project2;
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (elements[0] instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)elements[0];
            this.invoke(method, editor);
        } else if (elements[0] instanceof PsiClass) {
            this.invoke((PsiClass)elements[0], editor);
        }
    }

    private void invoke(PsiClass aClass, Editor editor) {
        String qualifiedName = aClass.getQualifiedName();
        if (qualifiedName == null) {
            this.showJspOrLocalClassMessage(editor);
            return;
        }
        if (!this.checkAbstractClassOrInterfaceMessage(aClass, editor)) {
            return;
        }
        PsiMethod[] constructors = aClass.getConstructors();
        if (constructors.length > 0) {
            String message = RefactoringBundle.message((String)"class.does.not.have.implicit.default.constructor", (Object[])new Object[]{aClass.getQualifiedName()});
            CommonRefactoringUtil.showErrorHint((Project)this.myProject, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.replaceConstrWithFactory");
            return;
        }
        int answer = Messages.showYesNoDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"would.you.like.to.replace.default.constructor.of.0.with.factory.method", (Object[])new Object[]{aClass.getQualifiedName()}), (String)REFACTORING_NAME, (Icon)Messages.getQuestionIcon());
        if (answer != 0) {
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)this.myProject, (PsiElement)aClass)) {
            return;
        }
        new ReplaceConstructorWithFactoryDialog(this.myProject, null, aClass).show();
    }

    private void showJspOrLocalClassMessage(Editor editor) {
        String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"refactoring.is.not.supported.for.local.and.jsp.classes"));
        CommonRefactoringUtil.showErrorHint((Project)this.myProject, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.replaceConstrWithFactory");
    }

    private boolean checkAbstractClassOrInterfaceMessage(PsiClass aClass, Editor editor) {
        if (!aClass.hasModifierProperty("abstract")) {
            return true;
        }
        String message = RefactoringBundle.getCannotRefactorMessage((String)(aClass.isInterface() ? RefactoringBundle.message((String)"class.is.interface", (Object[])new Object[]{aClass.getQualifiedName()}) : RefactoringBundle.message((String)"class.is.abstract", (Object[])new Object[]{aClass.getQualifiedName()})));
        CommonRefactoringUtil.showErrorHint((Project)this.myProject, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.replaceConstrWithFactory");
        return false;
    }

    private void invoke(PsiMethod method, Editor editor) {
        if (!method.isConstructor()) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"method.is.not.a.constructor"));
            CommonRefactoringUtil.showErrorHint((Project)this.myProject, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.replaceConstrWithFactory");
            return;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null || aClass.getQualifiedName() == null) {
            this.showJspOrLocalClassMessage(editor);
            return;
        }
        if (!this.checkAbstractClassOrInterfaceMessage(aClass, editor)) {
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)this.myProject, (PsiElement)method)) {
            return;
        }
        new ReplaceConstructorWithFactoryDialog(this.myProject, method, method.getContainingClass()).show();
    }
}

