/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.duplicates;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.util.duplicates.Match;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MatchUtil {
    @Nullable
    public static String getChangedSignature(Match match, PsiMethod method, boolean shouldBeStatic, String visibility) {
        PsiType returnType = match.getChangedReturnType(method);
        if (!match.myChangedParams.isEmpty() || returnType != null) {
            PsiTypeParameterList typeParameterList;
            StringBuilder buffer = new StringBuilder();
            buffer.append(visibility);
            if (buffer.length() > 0) {
                buffer.append(" ");
            }
            if (shouldBeStatic) {
                buffer.append("static ");
            }
            if ((typeParameterList = method.getTypeParameterList()) != null) {
                buffer.append(typeParameterList.getText());
                buffer.append(" ");
            }
            buffer.append(PsiFormatUtil.formatType((PsiType)(returnType != null ? returnType : method.getReturnType()), (int)0, (PsiSubstitutor)PsiSubstitutor.EMPTY));
            buffer.append(" ");
            buffer.append(method.getName());
            buffer.append("(");
            int count = 0;
            String INDENT = "    ";
            List<ParameterInfoImpl> params = MatchUtil.patchParams(match.myChangedParams, method);
            for (ParameterInfoImpl param : params) {
                String typeText = param.getTypeText();
                if (count > 0) {
                    buffer.append(",");
                }
                buffer.append("\n");
                buffer.append("    ");
                buffer.append(typeText);
                buffer.append(" ");
                buffer.append(param.getName());
                ++count;
            }
            if (count > 0) {
                buffer.append("\n");
            }
            buffer.append(")");
            PsiClassType[] exceptions = method.getThrowsList().getReferencedTypes();
            if (exceptions.length > 0) {
                buffer.append("\n");
                buffer.append("throws\n");
                for (PsiClassType exception : exceptions) {
                    buffer.append("    ");
                    buffer.append(PsiFormatUtil.formatType((PsiType)exception, (int)0, (PsiSubstitutor)PsiSubstitutor.EMPTY));
                    buffer.append("\n");
                }
            }
            return buffer.toString();
        }
        return null;
    }

    public static void changeSignature(@NotNull Match match, @NotNull PsiMethod psiMethod) {
        if (match == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "match", "com/intellij/refactoring/util/duplicates/MatchUtil", "changeSignature"));
        }
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/refactoring/util/duplicates/MatchUtil", "changeSignature"));
        }
        PsiType expressionType = match.getChangedReturnType(psiMethod);
        if (expressionType == null && match.myChangedParams.isEmpty()) {
            return;
        }
        List<ParameterInfoImpl> newParameters = MatchUtil.patchParams(match.myChangedParams, psiMethod);
        ChangeSignatureProcessor csp = new ChangeSignatureProcessor(psiMethod.getProject(), psiMethod, false, null, psiMethod.getName(), expressionType != null ? expressionType : psiMethod.getReturnType(), newParameters.toArray(new ParameterInfoImpl[newParameters.size()]));
        csp.run();
    }

    public static List<ParameterInfoImpl> patchParams(Map<PsiVariable, PsiType> changedParams, PsiMethod psiMethod) {
        ArrayList<ParameterInfoImpl> newParameters = new ArrayList<ParameterInfoImpl>();
        PsiParameter[] oldParameters = psiMethod.getParameterList().getParameters();
        for (int i = 0; i < oldParameters.length; ++i) {
            PsiParameter oldParameter = oldParameters[i];
            PsiType type = oldParameter.getType();
            for (PsiVariable variable : changedParams.keySet()) {
                if (!PsiEquivalenceUtil.areElementsEquivalent((PsiElement)variable, (PsiElement)oldParameter)) continue;
                type = changedParams.get(variable);
                break;
            }
            newParameters.add(new ParameterInfoImpl(i, oldParameter.getName(), type));
        }
        return newParameters;
    }
}

