/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.tokenizer;

import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.impl.CustomSyntaxTableFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiPlainText;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.inspections.TextSplitter;
import com.intellij.spellchecker.quickfixes.AcceptWordAsCorrect;
import com.intellij.spellchecker.quickfixes.ChangeTo;
import com.intellij.spellchecker.quickfixes.RenameTo;
import com.intellij.spellchecker.quickfixes.SpellCheckerQuickFix;
import com.intellij.spellchecker.tokenizer.CommentTokenizer;
import com.intellij.spellchecker.tokenizer.CustomFileTypeTokenizer;
import com.intellij.spellchecker.tokenizer.PsiIdentifierOwnerTokenizer;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import com.intellij.spellchecker.tokenizer.TokenizerBase;
import org.jetbrains.annotations.NotNull;

public class SpellcheckingStrategy {
    protected final Tokenizer<PsiComment> myCommentTokenizer = new CommentTokenizer();
    protected final Tokenizer<XmlAttributeValue> myXmlAttributeTokenizer = new XmlAttributeValueTokenizer();
    public static final ExtensionPointName<SpellcheckingStrategy> EP_NAME = ExtensionPointName.create((String)"com.intellij.spellchecker.support");
    public static final Tokenizer EMPTY_TOKENIZER = new Tokenizer(){

        public void tokenize(@NotNull PsiElement element, TokenConsumer consumer) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spellchecker/tokenizer/SpellcheckingStrategy$1", "tokenize"));
            }
        }
    };
    public static final Tokenizer<PsiElement> TEXT_TOKENIZER = new TokenizerBase<PsiElement>(PlainTextSplitter.getInstance());
    private static final SpellCheckerQuickFix[] BATCH_FIXES = new SpellCheckerQuickFix[]{new AcceptWordAsCorrect()};

    @NotNull
    public Tokenizer getTokenizer(PsiElement element) {
        PsiElement injection;
        if (element instanceof PsiLanguageInjectionHost && InjectedLanguageUtil.hasInjections((PsiLanguageInjectionHost)element)) {
            Tokenizer tokenizer = EMPTY_TOKENIZER;
            if (tokenizer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/tokenizer/SpellcheckingStrategy", "getTokenizer"));
            }
            return tokenizer;
        }
        if (element instanceof PsiNameIdentifierOwner) {
            PsiIdentifierOwnerTokenizer psiIdentifierOwnerTokenizer = new PsiIdentifierOwnerTokenizer();
            if (psiIdentifierOwnerTokenizer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/tokenizer/SpellcheckingStrategy", "getTokenizer"));
            }
            return psiIdentifierOwnerTokenizer;
        }
        if (element instanceof PsiComment) {
            if (SuppressionUtil.isSuppressionComment(element)) {
                Tokenizer tokenizer = EMPTY_TOKENIZER;
                if (tokenizer == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/tokenizer/SpellcheckingStrategy", "getTokenizer"));
                }
                return tokenizer;
            }
            Tokenizer<PsiComment> tokenizer = this.myCommentTokenizer;
            if (tokenizer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/tokenizer/SpellcheckingStrategy", "getTokenizer"));
            }
            return tokenizer;
        }
        if (element instanceof XmlAttributeValue) {
            Tokenizer<XmlAttributeValue> tokenizer = this.myXmlAttributeTokenizer;
            if (tokenizer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/tokenizer/SpellcheckingStrategy", "getTokenizer"));
            }
            return tokenizer;
        }
        if (element instanceof PsiPlainText) {
            FileType fileType;
            PsiFile file2 = element.getContainingFile();
            FileType fileType2 = fileType = file2 == null ? null : file2.getFileType();
            if (fileType instanceof CustomSyntaxTableFileType) {
                CustomFileTypeTokenizer customFileTypeTokenizer = new CustomFileTypeTokenizer(((CustomSyntaxTableFileType)fileType).getSyntaxTable());
                if (customFileTypeTokenizer == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/tokenizer/SpellcheckingStrategy", "getTokenizer"));
                }
                return customFileTypeTokenizer;
            }
            Tokenizer<PsiElement> tokenizer = TEXT_TOKENIZER;
            if (tokenizer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/tokenizer/SpellcheckingStrategy", "getTokenizer"));
            }
            return tokenizer;
        }
        if (element instanceof XmlToken && ((XmlToken)element).getTokenType() == XmlTokenType.XML_DATA_CHARACTERS && (injection = InjectedLanguageManager.getInstance((Project)element.getProject()).findInjectedElementAt(element.getContainingFile(), element.getTextOffset())) == null) {
            Tokenizer<PsiElement> tokenizer = TEXT_TOKENIZER;
            if (tokenizer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/tokenizer/SpellcheckingStrategy", "getTokenizer"));
            }
            return tokenizer;
        }
        Tokenizer tokenizer = EMPTY_TOKENIZER;
        if (tokenizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/tokenizer/SpellcheckingStrategy", "getTokenizer"));
        }
        return tokenizer;
    }

    public SpellCheckerQuickFix[] getRegularFixes(PsiElement element, int offset, @NotNull TextRange textRange, boolean useRename, String wordWithTypo) {
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/spellchecker/tokenizer/SpellcheckingStrategy", "getRegularFixes"));
        }
        return SpellcheckingStrategy.getDefaultRegularFixes(useRename, wordWithTypo);
    }

    public static SpellCheckerQuickFix[] getDefaultRegularFixes(boolean useRename, String wordWithTypo) {
        return new SpellCheckerQuickFix[]{useRename ? new RenameTo(wordWithTypo) : new ChangeTo(wordWithTypo), new AcceptWordAsCorrect(wordWithTypo)};
    }

    public static SpellCheckerQuickFix[] getDefaultBatchFixes() {
        return BATCH_FIXES;
    }

    public boolean isMyContext(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spellchecker/tokenizer/SpellcheckingStrategy", "isMyContext"));
        }
        return true;
    }

    protected static class XmlAttributeValueTokenizer
    extends Tokenizer<XmlAttributeValue> {
        protected XmlAttributeValueTokenizer() {
        }

        @Override
        public void tokenize(@NotNull XmlAttributeValue element, TokenConsumer consumer) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spellchecker/tokenizer/SpellcheckingStrategy$XmlAttributeValueTokenizer", "tokenize"));
            }
            if (element instanceof PsiLanguageInjectionHost && InjectedLanguageUtil.hasInjections((PsiLanguageInjectionHost)element)) {
                return;
            }
            String valueTextTrimmed = element.getValue().trim();
            if (valueTextTrimmed.startsWith("#") && valueTextTrimmed.length() <= 7 && XmlAttributeValueTokenizer.isHexString(valueTextTrimmed.substring(1))) {
                return;
            }
            consumer.consumeToken((PsiElement)element, TextSplitter.getInstance());
        }

        private static boolean isHexString(String s) {
            for (int i = 0; i < s.length(); ++i) {
                if (StringUtil.isHexDigit((char)s.charAt(i))) continue;
                return false;
            }
            return true;
        }
    }
}

