/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.psi.search.SearchScope;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.StructuralSearchUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class MatchOptions
implements JDOMExternalizable {
    @NonNls
    private static final String TEXT_ATTRIBUTE_NAME = "text";
    private boolean looseMatching;
    private boolean recursiveSearch;
    private boolean caseSensitiveMatch;
    private boolean resultIsContextMatch = false;
    private FileType myFileType = null;
    private Language myDialect = null;
    private SearchScope scope;
    private String searchCriteria = "";
    @Nullable
    private Map<String, MatchVariableConstraint> variableConstraints;
    private String myPatternContext;
    @NonNls
    private static final String LOOSE_MATCHING_ATTRIBUTE_NAME = "loose";
    @NonNls
    private static final String RECURSIVE_ATTRIBUTE_NAME = "recursive";
    @NonNls
    private static final String CASESENSITIVE_ATTRIBUTE_NAME = "caseInsensitive";
    @NonNls
    private static final String CONSTRAINT_TAG_NAME = "constraint";
    @NonNls
    private static final String FILE_TYPE_ATTR_NAME = "type";
    @NonNls
    private static final String DIALECT_ATTR_NAME = "dialect";
    @NonNls
    public static final String INSTANCE_MODIFIER_NAME = "Instance";
    @NonNls
    public static final String MODIFIER_ANNOTATION_NAME = "Modifier";

    public void addVariableConstraint(MatchVariableConstraint constraint) {
        if (this.variableConstraints == null) {
            this.variableConstraints = new LinkedHashMap<String, MatchVariableConstraint>();
        }
        this.variableConstraints.put(constraint.getName(), constraint);
    }

    public boolean hasVariableConstraints() {
        return this.variableConstraints != null;
    }

    public void clearVariableConstraints() {
        this.variableConstraints = null;
    }

    public void retainVariableConstraints(Collection<String> names) {
        if (this.variableConstraints == null || this.variableConstraints.isEmpty()) {
            return;
        }
        THashSet nameSet = new THashSet(names);
        Iterator<String> iterator = this.variableConstraints.keySet().iterator();
        while (iterator.hasNext()) {
            String key = iterator.next();
            if (nameSet.contains((Object)key)) continue;
            iterator.remove();
        }
    }

    public MatchVariableConstraint getVariableConstraint(String name) {
        if (this.variableConstraints != null) {
            return this.variableConstraints.get(name);
        }
        return null;
    }

    public Set<String> getVariableConstraintNames() {
        if (this.variableConstraints == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.variableConstraints.keySet());
    }

    public void setCaseSensitiveMatch(boolean caseSensitiveMatch) {
        this.caseSensitiveMatch = caseSensitiveMatch;
    }

    public boolean isCaseSensitiveMatch() {
        return this.caseSensitiveMatch;
    }

    public String toString() {
        return "match options:\npattern:\n" + this.searchCriteria + "\nscope:\n" + (this.scope != null ? this.scope.toString() : "undefined scope") + "\nrecursive: " + this.recursiveSearch + "\ncase sensitive: " + this.caseSensitiveMatch + "\nloose: " + this.looseMatching;
    }

    public boolean isRecursiveSearch() {
        return this.recursiveSearch;
    }

    public void setRecursiveSearch(boolean recursiveSearch) {
        this.recursiveSearch = recursiveSearch;
    }

    public boolean isLooseMatching() {
        return this.looseMatching;
    }

    public void setLooseMatching(boolean looseMatching) {
        this.looseMatching = looseMatching;
    }

    public void setSearchPattern(String text) {
        this.searchCriteria = text;
    }

    public String getSearchPattern() {
        return this.searchCriteria;
    }

    public boolean isResultIsContextMatch() {
        return this.resultIsContextMatch;
    }

    public void setResultIsContextMatch(boolean resultIsContextMatch) {
        this.resultIsContextMatch = resultIsContextMatch;
    }

    public SearchScope getScope() {
        return this.scope;
    }

    public void setScope(SearchScope scope) {
        this.scope = scope;
    }

    public void writeExternal(Element element) {
        element.setAttribute(TEXT_ATTRIBUTE_NAME, this.searchCriteria);
        if (!this.looseMatching) {
            element.setAttribute(LOOSE_MATCHING_ATTRIBUTE_NAME, String.valueOf(this.looseMatching));
        }
        element.setAttribute(RECURSIVE_ATTRIBUTE_NAME, String.valueOf(this.recursiveSearch));
        element.setAttribute(CASESENSITIVE_ATTRIBUTE_NAME, String.valueOf(this.caseSensitiveMatch));
        if (this.myFileType != null) {
            element.setAttribute(FILE_TYPE_ATTR_NAME, this.myFileType.getName());
        }
        if (this.myDialect != null) {
            element.setAttribute(DIALECT_ATTR_NAME, this.myDialect.getID());
        }
        if (this.variableConstraints != null) {
            for (MatchVariableConstraint matchVariableConstraint : this.variableConstraints.values()) {
                if (matchVariableConstraint.isArtificial()) continue;
                Element infoElement = new Element(CONSTRAINT_TAG_NAME);
                element.addContent(infoElement);
                matchVariableConstraint.writeExternal(infoElement);
            }
        }
    }

    public void readExternal(Element element) {
        List elements;
        this.searchCriteria = element.getAttribute(TEXT_ATTRIBUTE_NAME).getValue();
        Attribute attr = element.getAttribute(LOOSE_MATCHING_ATTRIBUTE_NAME);
        if (attr != null) {
            try {
                this.looseMatching = attr.getBooleanValue();
            }
            catch (DataConversionException dataConversionException) {}
        } else {
            this.looseMatching = true;
        }
        if ((attr = element.getAttribute(RECURSIVE_ATTRIBUTE_NAME)) != null) {
            try {
                this.recursiveSearch = attr.getBooleanValue();
            }
            catch (DataConversionException dataConversionException) {
                // empty catch block
            }
        }
        if ((attr = element.getAttribute(CASESENSITIVE_ATTRIBUTE_NAME)) != null) {
            try {
                this.caseSensitiveMatch = attr.getBooleanValue();
            }
            catch (DataConversionException dataConversionException) {
                // empty catch block
            }
        }
        if ((attr = element.getAttribute(FILE_TYPE_ATTR_NAME)) != null) {
            String value = attr.getValue();
            this.myFileType = MatchOptions.getFileTypeByName(value);
        }
        if ((attr = element.getAttribute(DIALECT_ATTR_NAME)) != null) {
            this.myDialect = Language.findLanguageByID((String)attr.getValue());
        }
        if ((elements = element.getChildren(CONSTRAINT_TAG_NAME)) != null && !elements.isEmpty()) {
            for (Element element1 : elements) {
                MatchVariableConstraint constraint = new MatchVariableConstraint();
                constraint.readExternal(element1);
                this.addVariableConstraint(constraint);
            }
        }
    }

    private static FileType getFileTypeByName(String value) {
        if (value != null) {
            for (FileType type : StructuralSearchUtil.getSuitableFileTypes()) {
                if (!value.equals(type.getName())) continue;
                return type;
            }
        }
        return StructuralSearchUtil.getDefaultFileType();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MatchOptions)) {
            return false;
        }
        MatchOptions matchOptions = (MatchOptions)o;
        if (this.caseSensitiveMatch != matchOptions.caseSensitiveMatch) {
            return false;
        }
        if (this.looseMatching != matchOptions.looseMatching) {
            return false;
        }
        if (this.recursiveSearch != matchOptions.recursiveSearch) {
            return false;
        }
        if (this.searchCriteria != null ? !this.searchCriteria.equals(matchOptions.searchCriteria) : matchOptions.searchCriteria != null) {
            return false;
        }
        if (this.variableConstraints != null ? !this.variableConstraints.equals(matchOptions.variableConstraints) : matchOptions.variableConstraints != null) {
            return false;
        }
        if (this.myFileType != matchOptions.myFileType) {
            return false;
        }
        if (this.myDialect != null ? !this.myDialect.equals(matchOptions.myDialect) : matchOptions.myDialect != null) {
            return false;
        }
        return !(this.myPatternContext != null ? !this.myPatternContext.equals(matchOptions.myPatternContext) : matchOptions.myPatternContext != null);
    }

    public int hashCode() {
        int result = this.looseMatching ? 1 : 0;
        result = 29 * result + (this.recursiveSearch ? 1 : 0);
        result = 29 * result + (this.caseSensitiveMatch ? 1 : 0);
        result = 29 * result + (this.searchCriteria != null ? this.searchCriteria.hashCode() : 0);
        result = 29 * result + (this.variableConstraints != null ? this.variableConstraints.hashCode() : 0);
        if (this.myFileType != null) {
            result = 29 * result + this.myFileType.hashCode();
        }
        if (this.myDialect != null) {
            result = 29 * result + this.myDialect.hashCode();
        }
        return result;
    }

    public void setFileType(FileType fileType) {
        this.myFileType = fileType;
    }

    public FileType getFileType() {
        if (this.myFileType == null) {
            this.myFileType = StructuralSearchUtil.getDefaultFileType();
        }
        return this.myFileType;
    }

    public Language getDialect() {
        return this.myDialect;
    }

    public void setDialect(Language dialect) {
        this.myDialect = dialect;
    }

    public String getPatternContext() {
        return this.myPatternContext;
    }

    public void setPatternContext(String patternContext) {
        this.myPatternContext = patternContext;
    }
}

