/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.filters;

import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;

public final class LexicalNodesFilter
implements NodeFilter {
    private final ThreadLocal<Boolean> careKeyWords = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private final ThreadLocal<Boolean> result = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };

    private LexicalNodesFilter() {
    }

    public static NodeFilter getInstance() {
        return NodeFilterHolder.instance;
    }

    public boolean getResult() {
        return this.result.get();
    }

    public void setResult(boolean result) {
        this.result.set(result);
    }

    public boolean isCareKeyWords() {
        return this.careKeyWords.get();
    }

    public void setCareKeyWords(boolean careKeyWords) {
        this.careKeyWords.set(careKeyWords);
    }

    @Override
    public boolean accepts(PsiElement element) {
        StructuralSearchProfile profile;
        this.result.set(Boolean.FALSE);
        if (element != null && (profile = StructuralSearchUtil.getProfileByPsiElement(element)) != null) {
            element.accept(profile.getLexicalNodesFilter(this));
        }
        return this.result.get();
    }

    private static class NodeFilterHolder {
        private static final NodeFilter instance = new LexicalNodesFilter();

        private NodeFilterHolder() {
        }
    }
}

