/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.JavaRefactoringActionHandlerFactory;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntroduceVariableFix
extends InspectionGadgetsFix {
    private final boolean myMayChangeSemantics;

    public IntroduceVariableFix(boolean mayChangeSemantics) {
        this.myMayChangeSemantics = mayChangeSemantics;
    }

    @NotNull
    public String getName() {
        if (this.myMayChangeSemantics) {
            String string = InspectionGadgetsBundle.message("introduce.variable.may.change.semantics.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/IntroduceVariableFix", "getName"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("introduce.variable.quickfix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/IntroduceVariableFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = InspectionGadgetsBundle.message("introduce.variable.quickfix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/IntroduceVariableFix", "getFamilyName"));
        }
        return string;
    }

    @Nullable
    public PsiExpression getExpressionToExtract(PsiElement element) {
        return (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class, (boolean)false);
    }

    @Override
    protected void doFix(final Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
        final PsiExpression expression = this.getExpressionToExtract(descriptor.getPsiElement());
        if (expression == null) {
            return;
        }
        final RefactoringActionHandler handler2 = JavaRefactoringActionHandlerFactory.getInstance().createIntroduceVariableHandler();
        AsyncResult dataContextContainer = DataManager.getInstance().getDataContextFromFocus();
        dataContextContainer.doWhenDone((Consumer)new Consumer<DataContext>(){

            public void consume(DataContext dataContext) {
                handler2.invoke(project2, new PsiElement[]{expression}, dataContext);
            }
        });
    }
}

