/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.JavaRefactoringActionHandlerFactory;
import com.intellij.refactoring.RefactoringActionHandler;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public class MoveAnonymousToInnerClassFix
extends InspectionGadgetsFix {
    public static final String NAME = InspectionGadgetsBundle.message("move.anonymous.to.inner.quickfix", new Object[0]);
    private final String name;

    public MoveAnonymousToInnerClassFix(String name) {
        this.name = name;
    }

    public MoveAnonymousToInnerClassFix() {
        this.name = NAME;
    }

    @NotNull
    public String getFamilyName() {
        String string = NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/MoveAnonymousToInnerClassFix", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/MoveAnonymousToInnerClassFix", "getName"));
        }
        return string;
    }

    @Override
    public void doFix(final @NotNull Project project2, ProblemDescriptor descriptor) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/siyeh/ig/fixes/MoveAnonymousToInnerClassFix", "doFix"));
        }
        PsiElement nameElement = descriptor.getPsiElement();
        final PsiAnonymousClass aClass = (PsiAnonymousClass)nameElement.getParent();
        JavaRefactoringActionHandlerFactory factory = JavaRefactoringActionHandlerFactory.getInstance();
        final RefactoringActionHandler anonymousToInner = factory.createAnonymousToInnerHandler();
        DataManager dataManager = DataManager.getInstance();
        final DataContext dataContext = dataManager.getDataContext();
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                anonymousToInner.invoke(project2, new PsiElement[]{aClass}, dataContext);
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            runnable2.run();
        } else {
            ApplicationManager.getApplication().invokeLater(runnable2, project2.getDisposed());
        }
    }
}

