/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.internationalization;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.DelegatingFix;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.internationalization.NonNlsUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringConcatenationInspectionBase
extends BaseInspection {
    public boolean ignoreAsserts = false;
    public boolean ignoreSystemOuts = false;
    public boolean ignoreSystemErrs = false;
    public boolean ignoreThrowableArguments = false;
    public boolean ignoreConstantInitializers = false;
    public boolean ignoreInTestCode = false;
    public boolean ignoreInToString = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("string.concatenation.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/internationalization/StringConcatenationInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("string.concatenation.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/internationalization/StringConcatenationInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        PsiMethod method;
        PsiMethodCallExpression operands;
        PsiReferenceExpression referenceExpression;
        PsiElement target;
        PsiMethodCallExpression methodCallExpression;
        PsiReferenceExpression methodExpression;
        PsiExpression qualifierExpression;
        PsiElement grandParent;
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)infos[0];
        ArrayList<DelegatingFix> result = new ArrayList<DelegatingFix>();
        PsiElement parent = ParenthesesUtils.getParentSkipParentheses((PsiElement)polyadicExpression);
        if (parent instanceof PsiVariable) {
            PsiVariable variable = (PsiVariable)parent;
            DelegatingFix fix = StringConcatenationInspectionBase.createAddAnnotationFix((PsiModifierListOwner)variable);
            result.add(fix);
        } else if (parent instanceof PsiAssignmentExpression) {
            PsiReferenceExpression referenceExpression2;
            PsiElement target2;
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
            PsiExpression lhs = assignmentExpression.getLExpression();
            if (lhs instanceof PsiReferenceExpression && (target2 = (referenceExpression2 = (PsiReferenceExpression)lhs).resolve()) instanceof PsiModifierListOwner) {
                PsiModifierListOwner modifierListOwner = (PsiModifierListOwner)target2;
                DelegatingFix fix = StringConcatenationInspectionBase.createAddAnnotationFix(modifierListOwner);
                result.add(fix);
            }
        } else if (parent instanceof PsiExpressionList && (grandParent = parent.getParent()) instanceof PsiMethodCallExpression && (qualifierExpression = (methodExpression = (methodCallExpression = (PsiMethodCallExpression)grandParent).getMethodExpression()).getQualifierExpression()) instanceof PsiReferenceExpression && (target = (referenceExpression = (PsiReferenceExpression)qualifierExpression).resolve()) instanceof PsiModifierListOwner) {
            PsiModifierListOwner modifierListOwner = (PsiModifierListOwner)target;
            result.add(StringConcatenationInspectionBase.createAddAnnotationFix(modifierListOwner));
        }
        for (PsiMethodCallExpression operand : operands = polyadicExpression.getOperands()) {
            PsiModifierListOwner element1 = StringConcatenationInspectionBase.getAnnotatableElement((PsiExpression)operand);
            if (element1 == null) continue;
            DelegatingFix fix = StringConcatenationInspectionBase.createAddAnnotationFix(element1);
            result.add(fix);
        }
        PsiElement expressionParent = PsiTreeUtil.getParentOfType((PsiElement)polyadicExpression, (Class[])new Class[]{PsiReturnStatement.class, PsiExpressionList.class});
        if (!(expressionParent instanceof PsiExpressionList) && expressionParent != null && (method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expressionParent, PsiMethod.class)) != null) {
            DelegatingFix fix = StringConcatenationInspectionBase.createAddAnnotationFix((PsiModifierListOwner)method);
            result.add(fix);
        }
        InspectionGadgetsFix[] inspectionGadgetsFixArray = result.toArray(new InspectionGadgetsFix[result.size()]);
        if (inspectionGadgetsFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/internationalization/StringConcatenationInspectionBase", "buildFixes"));
        }
        return inspectionGadgetsFixArray;
    }

    private static DelegatingFix createAddAnnotationFix(PsiModifierListOwner variable) {
        return new DelegatingFix((LocalQuickFix)new AddAnnotationPsiFix("org.jetbrains.annotations.NonNls", variable, PsiNameValuePair.EMPTY_ARRAY, new String[0]));
    }

    @Nullable
    public static PsiModifierListOwner getAnnotatableElement(PsiExpression expression) {
        if (!(expression instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
        PsiElement element = referenceExpression.resolve();
        if (!(element instanceof PsiModifierListOwner)) {
            return null;
        }
        return (PsiModifierListOwner)element;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("string.concatenation.ignore.assert.option", new Object[0]), "ignoreAsserts");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("string.concatenation.ignore.system.out.option", new Object[0]), "ignoreSystemOuts");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("string.concatenation.ignore.system.err.option", new Object[0]), "ignoreSystemErrs");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("string.concatenation.ignore.exceptions.option", new Object[0]), "ignoreThrowableArguments");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("string.concatenation.ignore.constant.initializers.option", new Object[0]), "ignoreConstantInitializers");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("ignore.in.tostring", new Object[0]), "ignoreInToString");
        return optionsPanel;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringConcatenationVisitor();
    }

    private class StringConcatenationVisitor
    extends BaseInspectionVisitor {
        private StringConcatenationVisitor() {
        }

        public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression) {
            PsiMethod method;
            PsiMethodCallExpression methodCallExpression;
            PsiType newExpressionType;
            PsiNewExpression newExpression;
            PsiMethodCallExpression methodCallExpression2;
            PsiAssertStatement assertStatement;
            PsiExpression[] operands;
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/internationalization/StringConcatenationInspectionBase$StringConcatenationVisitor", "visitPolyadicExpression"));
            }
            super.visitPolyadicExpression(expression);
            IElementType tokenType = expression.getOperationTokenType();
            if (!JavaTokenType.PLUS.equals(tokenType)) {
                return;
            }
            PsiType type = expression.getType();
            if (!TypeUtils.isJavaLangString(type)) {
                return;
            }
            for (PsiExpression operand : operands = expression.getOperands()) {
                if (!NonNlsUtils.isNonNlsAnnotated(operand)) continue;
                return;
            }
            if (AnnotationUtil.isInsideAnnotation((PsiElement)expression)) {
                return;
            }
            if (StringConcatenationInspectionBase.this.ignoreAsserts && (assertStatement = (PsiAssertStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiAssertStatement.class, (boolean)true, (Class[])new Class[]{PsiCodeBlock.class, PsiClass.class})) != null) {
                return;
            }
            if ((StringConcatenationInspectionBase.this.ignoreSystemErrs || StringConcatenationInspectionBase.this.ignoreSystemOuts) && (methodCallExpression2 = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethodCallExpression.class, (boolean)true, (Class[])new Class[]{PsiCodeBlock.class, PsiClass.class})) != null) {
                PsiReferenceExpression methodExpression = methodCallExpression2.getMethodExpression();
                String canonicalText = methodExpression.getCanonicalText();
                if (StringConcatenationInspectionBase.this.ignoreSystemOuts && "System.out.println".equals(canonicalText) || "System.out.print".equals(canonicalText)) {
                    return;
                }
                if (StringConcatenationInspectionBase.this.ignoreSystemErrs && "System.err.println".equals(canonicalText) || "System.err.print".equals(canonicalText)) {
                    return;
                }
            }
            if (StringConcatenationInspectionBase.this.ignoreThrowableArguments && ((newExpression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiNewExpression.class, (boolean)true, (Class[])new Class[]{PsiCodeBlock.class, PsiClass.class})) != null ? InheritanceUtil.isInheritor((PsiType)(newExpressionType = newExpression.getType()), (String)"java.lang.Throwable") : RefactoringChangeUtil.isSuperOrThisMethodCall((PsiElement)(methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethodCallExpression.class, (boolean)true, (Class[])new Class[]{PsiCodeBlock.class, PsiClass.class}))))) {
                return;
            }
            if (StringConcatenationInspectionBase.this.ignoreConstantInitializers) {
                PsiElement parent = expression.getParent();
                while (parent instanceof PsiBinaryExpression) {
                    parent = parent.getParent();
                }
                if (parent instanceof PsiField) {
                    PsiField field = (PsiField)parent;
                    if (field.hasModifierProperty("static") && field.hasModifierProperty("final")) {
                        return;
                    }
                    PsiClass containingClass = field.getContainingClass();
                    if (containingClass != null && containingClass.isInterface()) {
                        return;
                    }
                }
            }
            if (StringConcatenationInspectionBase.this.ignoreInToString && MethodUtils.isToString(method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class}))) {
                return;
            }
            if (NonNlsUtils.isNonNlsAnnotatedUse((PsiExpression)expression)) {
                return;
            }
            for (int i = 1; i < operands.length; ++i) {
                PsiJavaToken token;
                PsiExpression operand = operands[i];
                if (!ExpressionUtils.isStringConcatenationOperand(operand) || (token = expression.getTokenBeforeOperand(operand)) == null) continue;
                this.registerError((PsiElement)token, expression);
            }
        }
    }
}

