/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class AssertEqualsBetweenInconvertibleTypesInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("assertequals.between.inconvertible.types.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/AssertEqualsBetweenInconvertibleTypesInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiType comparedType = (PsiType)infos[0];
        PsiType comparisonType = (PsiType)infos[1];
        String comparedTypeText = comparedType.getPresentableText();
        String comparisonTypeText = comparisonType.getPresentableText();
        String string = InspectionGadgetsBundle.message("assertequals.between.inconvertible.types.problem.descriptor", StringUtil.escapeXml((String)comparedTypeText), StringUtil.escapeXml((String)comparisonTypeText));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/AssertEqualsBetweenInconvertibleTypesInspection", "buildErrorString"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AssertEqualsBetweenInconvertibleTypesVisitor();
    }

    private static class AssertEqualsBetweenInconvertibleTypesVisitor
    extends BaseInspectionVisitor {
        private AssertEqualsBetweenInconvertibleTypesVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            int argumentIndex;
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/junit/AssertEqualsBetweenInconvertibleTypesInspection$AssertEqualsBetweenInconvertibleTypesVisitor", "visitMethodCallExpression"));
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"assertEquals".equals(methodName)) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (!InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"junit.framework.Assert") && !InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"org.junit.Assert")) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            PsiParameter[] parameters = parameterList.getParameters();
            if (parameters.length < 2) {
                return;
            }
            PsiType firstParameterType = parameters[0].getType();
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (firstParameterType.equalsToText("java.lang.String")) {
                if (arguments.length < 3) {
                    return;
                }
                argumentIndex = 1;
            } else {
                if (arguments.length < 2) {
                    return;
                }
                argumentIndex = 0;
            }
            PsiExpression expression1 = arguments[argumentIndex];
            PsiExpression expression2 = arguments[argumentIndex + 1];
            PsiType type1 = expression1.getType();
            if (type1 == null) {
                return;
            }
            PsiType type2 = expression2.getType();
            if (type2 == null) {
                return;
            }
            PsiType parameterType1 = parameters[argumentIndex].getType();
            PsiType parameterType2 = parameters[argumentIndex + 1].getType();
            PsiClassType objectType = TypeUtils.getObjectType((PsiElement)expression);
            if (!objectType.equals((Object)parameterType1) || !objectType.equals((Object)parameterType2)) {
                return;
            }
            if (TypeUtils.areConvertible(type1, type2)) {
                return;
            }
            this.registerMethodCallError(expression, type1, type2);
        }
    }
}

