/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiVariable;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;

class VariableAssignedFromVisitor
extends JavaRecursiveElementWalkingVisitor {
    private boolean assignedFrom;
    @NotNull
    private final PsiVariable variable;

    public VariableAssignedFromVisitor(@NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/VariableAssignedFromVisitor", "<init>"));
        }
        this.assignedFrom = false;
        this.variable = variable;
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/psiutils/VariableAssignedFromVisitor", "visitElement"));
        }
        if (!this.assignedFrom) {
            super.visitElement(element);
        }
    }

    public void visitAssignmentExpression(@NotNull PsiAssignmentExpression assignment) {
        if (assignment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "com/siyeh/ig/psiutils/VariableAssignedFromVisitor", "visitAssignmentExpression"));
        }
        if (this.assignedFrom) {
            return;
        }
        super.visitAssignmentExpression(assignment);
        PsiExpression arg = assignment.getRExpression();
        if (VariableAccessUtils.mayEvaluateToVariable(arg, this.variable)) {
            this.assignedFrom = true;
        }
    }

    public void visitDeclarationStatement(@NotNull PsiDeclarationStatement statement2) {
        PsiElement[] declaredElements;
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/psiutils/VariableAssignedFromVisitor", "visitDeclarationStatement"));
        }
        if (this.assignedFrom) {
            return;
        }
        super.visitDeclarationStatement(statement2);
        for (PsiElement declaredElement : declaredElements = statement2.getDeclaredElements()) {
            PsiVariable declaredVariable;
            PsiExpression initializer;
            if (!(declaredElement instanceof PsiVariable) || (initializer = (declaredVariable = (PsiVariable)declaredElement).getInitializer()) == null || !VariableAccessUtils.mayEvaluateToVariable(initializer, this.variable)) continue;
            this.assignedFrom = true;
            return;
        }
    }

    public void visitVariable(@NotNull PsiVariable var) {
        if (var == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "var", "com/siyeh/ig/psiutils/VariableAssignedFromVisitor", "visitVariable"));
        }
        if (this.assignedFrom) {
            return;
        }
        super.visitVariable(var);
        PsiExpression arg = var.getInitializer();
        if (VariableAccessUtils.mayEvaluateToVariable(arg, this.variable)) {
            this.assignedFrom = true;
        }
    }

    public boolean isAssignedFrom() {
        return this.assignedFrom;
    }
}

