/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.braces;

import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiStatement;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.braces.BaseBracesIntention;
import org.jetbrains.annotations.NotNull;

public class AddBracesIntention
extends BaseBracesIntention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        PsiElementPredicate psiElementPredicate = new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(PsiElement element) {
                PsiStatement statement2 = BaseBracesIntention.getSurroundingStatement(element);
                return statement2 != null && !(statement2 instanceof PsiBlockStatement);
            }
        };
        if (psiElementPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/braces/AddBracesIntention", "getElementPredicate"));
        }
        return psiElementPredicate;
    }

    @Override
    @NotNull
    protected String getMessageKey() {
        if ("add.braces.intention.name" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/braces/AddBracesIntention", "getMessageKey"));
        }
        return "add.braces.intention.name";
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/braces/AddBracesIntention", "processIntention"));
        }
        PsiStatement statement2 = AddBracesIntention.getSurroundingStatement(element);
        if (statement2 == null) {
            return;
        }
        String newStatement = "{\n" + statement2.getText() + "\n}";
        PsiReplacementUtil.replaceStatement(statement2, newStatement);
    }
}

