/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.commutative;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.psiutils.ErrorUtil;

class FlipCommutativeMethodCallPredicate
implements PsiElementPredicate {
    FlipCommutativeMethodCallPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        PsiMethod[] methods;
        if (!(element instanceof PsiMethodCallExpression)) {
            return false;
        }
        if (ErrorUtil.containsError(element)) {
            return false;
        }
        PsiMethodCallExpression expression = (PsiMethodCallExpression)element;
        PsiExpressionList argumentList = expression.getArgumentList();
        PsiExpression[] args = argumentList.getExpressions();
        if (args.length != 1) {
            return false;
        }
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        if (qualifier == null) {
            return false;
        }
        String methodName = methodExpression.getReferenceName();
        PsiType callerType = qualifier.getType();
        PsiType argumentType = args[0].getType();
        if (argumentType == null || !(argumentType instanceof PsiClassType)) {
            return false;
        }
        if (callerType == null || !(callerType instanceof PsiClassType)) {
            return false;
        }
        PsiClassType.ClassResolveResult resolveResult = ((PsiClassType)argumentType).resolveGenerics();
        PsiClass argumentClass = resolveResult.getElement();
        if (argumentClass == null) {
            return false;
        }
        for (PsiMethod testMethod : methods = argumentClass.findMethodsByName(methodName, true)) {
            PsiType type;
            PsiSubstitutor substitutor;
            PsiParameterList parameterList;
            PsiParameter[] parameters;
            String testMethodName = testMethod.getName();
            if (!testMethodName.equals(methodName) || (parameters = (parameterList = testMethod.getParameterList()).getParameters()).length != 1) continue;
            PsiParameter parameter = parameters[0];
            PsiClass containingClass = testMethod.getContainingClass();
            if (containingClass == null || (substitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)containingClass, (PsiClass)argumentClass, (PsiSubstitutor)resolveResult.getSubstitutor())) == null || (type = substitutor.substitute(parameter.getType())) == null || !type.isAssignableFrom(callerType)) continue;
            return true;
        }
        return false;
    }
}

