/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.equality;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.equality.ObjectEqualityPredicate;
import org.jetbrains.annotations.NotNull;

public class ReplaceEqualityWithSafeEqualsIntention
extends MutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)element;
        if (JavaTokenType.NE.equals(binaryExpression.getOperationTokenType())) {
            return IntentionPowerPackBundle.message("replace.equality.with.safe.not.equals.intention.name", new Object[0]);
        }
        return IntentionPowerPackBundle.message("replace.equality.with.safe.equals.intention.name", new Object[0]);
    }

    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        ObjectEqualityPredicate objectEqualityPredicate = new ObjectEqualityPredicate();
        if (objectEqualityPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/equality/ReplaceEqualityWithSafeEqualsIntention", "getElementPredicate"));
        }
        return objectEqualityPredicate;
    }

    @Override
    public void processIntention(PsiElement element) {
        PsiBinaryExpression exp = (PsiBinaryExpression)element;
        PsiExpression lhs = exp.getLOperand();
        PsiExpression rhs = exp.getROperand();
        if (rhs == null) {
            return;
        }
        PsiExpression strippedLhs = ParenthesesUtils.stripParentheses(lhs);
        if (strippedLhs == null) {
            return;
        }
        PsiExpression strippedRhs = ParenthesesUtils.stripParentheses(rhs);
        if (strippedRhs == null) {
            return;
        }
        String lhsText = strippedLhs.getText();
        String rhsText = strippedRhs.getText();
        PsiJavaToken operationSign = exp.getOperationSign();
        IElementType tokenType = operationSign.getTokenType();
        String signText = operationSign.getText();
        StringBuilder newExpression = new StringBuilder();
        if (PsiUtil.isLanguageLevel7OrHigher((PsiElement)element) && ClassUtils.findClass("java.util.Objects", element) != null) {
            if (tokenType.equals(JavaTokenType.NE)) {
                newExpression.append('!');
            }
            newExpression.append("java.util.Objects.equals(").append(lhsText).append(',').append(rhsText).append(')');
        } else {
            newExpression.append(lhsText).append("==null?").append(rhsText).append(signText).append(" null:");
            if (tokenType.equals(JavaTokenType.NE)) {
                newExpression.append('!');
            }
            if (ParenthesesUtils.getPrecedence(strippedLhs) > 1) {
                newExpression.append('(').append(lhsText).append(')');
            } else {
                newExpression.append(lhsText);
            }
            newExpression.append(".equals(").append(rhsText).append(')');
        }
        PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)exp, newExpression.toString());
    }
}

