/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.editor.impl;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import javax.swing.JComponent;
import org.intellij.images.editor.ImageEditor;
import org.intellij.images.editor.ImageFileEditor;
import org.intellij.images.editor.ImageZoomModel;
import org.intellij.images.editor.impl.ImageEditorImpl;
import org.intellij.images.editor.impl.ImageFileEditorState;
import org.intellij.images.options.EditorOptions;
import org.intellij.images.options.GridOptions;
import org.intellij.images.options.Options;
import org.intellij.images.options.OptionsManager;
import org.intellij.images.options.TransparencyChessboardOptions;
import org.jetbrains.annotations.NotNull;

final class ImageFileEditorImpl
extends UserDataHolderBase
implements ImageFileEditor,
PropertyChangeListener {
    private static final String NAME = "ImageFileEditor";
    private final ImageEditor imageEditor;
    private final EventDispatcher<PropertyChangeListener> myDispatcher;

    ImageFileEditorImpl(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/images/editor/impl/ImageFileEditorImpl", "<init>"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/intellij/images/editor/impl/ImageFileEditorImpl", "<init>"));
        }
        this.myDispatcher = EventDispatcher.create(PropertyChangeListener.class);
        this.imageEditor = new ImageEditorImpl(project2, file2);
        Disposer.register((Disposable)this, (Disposable)this.imageEditor);
        Options options = OptionsManager.getInstance().getOptions();
        EditorOptions editorOptions = options.getEditorOptions();
        GridOptions gridOptions = editorOptions.getGridOptions();
        TransparencyChessboardOptions transparencyChessboardOptions = editorOptions.getTransparencyChessboardOptions();
        this.imageEditor.setGridVisible(gridOptions.isShowDefault());
        this.imageEditor.setTransparencyChessboardVisible(transparencyChessboardOptions.isShowDefault());
        ((ImageEditorImpl)this.imageEditor).getComponent().getImageComponent().addPropertyChangeListener(this);
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.imageEditor.getComponent();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/images/editor/impl/ImageFileEditorImpl", "getComponent"));
        }
        return jComponent;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.imageEditor.getContentComponent();
    }

    @NotNull
    public String getName() {
        if (NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/images/editor/impl/ImageFileEditorImpl", "getName"));
        }
        return NAME;
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "org/intellij/images/editor/impl/ImageFileEditorImpl", "getState"));
        }
        ImageZoomModel zoomModel = this.imageEditor.getZoomModel();
        ImageFileEditorState imageFileEditorState = new ImageFileEditorState(this.imageEditor.isTransparencyChessboardVisible(), this.imageEditor.isGridVisible(), zoomModel.getZoomFactor());
        if (imageFileEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/images/editor/impl/ImageFileEditorImpl", "getState"));
        }
        return imageFileEditorState;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/intellij/images/editor/impl/ImageFileEditorImpl", "setState"));
        }
        if (state instanceof ImageFileEditorState) {
            ImageFileEditorState editorState = (ImageFileEditorState)state;
            ImageZoomModel zoomModel = this.imageEditor.getZoomModel();
            this.imageEditor.setTransparencyChessboardVisible(editorState.isBackgroundVisible());
            this.imageEditor.setGridVisible(editorState.isGridVisible());
            zoomModel.setZoomFactor(editorState.getZoomFactor());
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/intellij/images/editor/impl/ImageFileEditorImpl", "addPropertyChangeListener"));
        }
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/intellij/images/editor/impl/ImageFileEditorImpl", "removePropertyChangeListener"));
        }
        this.myDispatcher.removeListener((EventListener)listener2);
    }

    @Override
    public void propertyChange(@NotNull PropertyChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/intellij/images/editor/impl/ImageFileEditorImpl", "propertyChange"));
        }
        PropertyChangeEvent editorEvent = new PropertyChangeEvent(this, event.getPropertyName(), event.getOldValue(), event.getNewValue());
        ((PropertyChangeListener)this.myDispatcher.getMulticaster()).propertyChange(editorEvent);
    }

    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
    }

    @Override
    @NotNull
    public ImageEditor getImageEditor() {
        ImageEditor imageEditor = this.imageEditor;
        if (imageEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/images/editor/impl/ImageFileEditorImpl", "getImageEditor"));
        }
        return imageEditor;
    }
}

