/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.util.ThreeState;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XInlineDebuggerDataCallback;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XValueNode;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.MemberFilter;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.ValueModifierUtil;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.VariableView;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.frame.CallFrameView;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.Value;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J0\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J0\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J#\u0010\u0018\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00010\u00010\u0005\u00a2\u0006\u0002\b\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001e\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R'\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00010\u00010\u0005\u00a2\u0006\u0002\b\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/debugger/BasicDebuggerViewSupport;", "Lorg/jetbrains/debugger/MemberFilter;", "Lorg/jetbrains/debugger/DebuggerViewSupport;", "()V", "defaultMemberFilterPromise", "Lorg/jetbrains/concurrency/Promise;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getDefaultMemberFilterPromise", "()Lorg/jetbrains/concurrency/Promise;", "computeArrayPresentation", "", "value", "Lorg/jetbrains/debugger/values/Value;", "variable", "Lorg/jetbrains/debugger/Variable;", "context", "Lorg/jetbrains/debugger/VariableContext;", "node", "Lcom/intellij/xdebugger/frame/XValueNode;", "icon", "Ljavax/swing/Icon;", "computeObjectPresentation", "Lorg/jetbrains/debugger/values/ObjectValue;", "getMemberFilter", "propertyNamesToString", "", "list", "", "quotedAware", "", "script-debugger-ui"})
public class BasicDebuggerViewSupport
implements MemberFilter,
DebuggerViewSupport {
    @NotNull
    private final Promise<MemberFilter> defaultMemberFilterPromise = Promise.resolve((Object)this);

    @NotNull
    protected final Promise<MemberFilter> getDefaultMemberFilterPromise() {
        return this.defaultMemberFilterPromise;
    }

    @Override
    @NotNull
    public String propertyNamesToString(@NotNull List<String> list, boolean quotedAware) {
        Intrinsics.checkParameterIsNotNull(list, (String)"list");
        return ValueModifierUtil.INSTANCE.propertyNamesToString(list, quotedAware);
    }

    @Override
    public void computeObjectPresentation(@NotNull ObjectValue value, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XValueNode node, @NotNull Icon icon) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)icon, (String)"icon");
        VariableView.Companion.setObjectPresentation(value, icon, node);
    }

    @Override
    public void computeArrayPresentation(@NotNull Value value, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XValueNode node, @NotNull Icon icon) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)icon, (String)"icon");
        VariableView.Companion.setArrayPresentation(value, context, icon, node);
    }

    @Override
    @NotNull
    public Promise<MemberFilter> getMemberFilter(@NotNull VariableContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return this.defaultMemberFilterPromise;
    }

    @Override
    @NotNull
    public Collection<Variable> getAdditionalVariables() {
        return MemberFilter.DefaultImpls.getAdditionalVariables(this);
    }

    @Override
    public boolean hasNameMappings() {
        return MemberFilter.DefaultImpls.hasNameMappings(this);
    }

    @Override
    public boolean isMemberVisible(@NotNull Variable variable) {
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        return MemberFilter.DefaultImpls.isMemberVisible(this, variable);
    }

    @Override
    @NotNull
    public String rawNameToSource(@NotNull Variable variable) {
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        return MemberFilter.DefaultImpls.rawNameToSource(this, variable);
    }

    @Override
    @Nullable
    public String sourceNameToRaw(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return MemberFilter.DefaultImpls.sourceNameToRaw(this, name);
    }

    @Override
    @Nullable
    public Vm getVm() {
        return DebuggerViewSupport.DefaultImpls.getVm(this);
    }

    @Override
    @Nullable
    public SourceInfo getSourceInfo(@Nullable Script script, @NotNull CallFrame frame) {
        Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
        return DebuggerViewSupport.DefaultImpls.getSourceInfo(this, script, frame);
    }

    @Override
    @Nullable
    public SourceInfo getSourceInfo(@Nullable String functionName, @NotNull String scriptUrl, int line, int column) {
        Intrinsics.checkParameterIsNotNull((Object)scriptUrl, (String)"scriptUrl");
        return DebuggerViewSupport.DefaultImpls.getSourceInfo((DebuggerViewSupport)this, functionName, scriptUrl, line, column);
    }

    @Override
    @Nullable
    public SourceInfo getSourceInfo(@Nullable String functionName, @NotNull Script script, int line, int column) {
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        return DebuggerViewSupport.DefaultImpls.getSourceInfo((DebuggerViewSupport)this, functionName, script, line, column);
    }

    @Override
    @NotNull
    public XDebuggerEvaluator createFrameEvaluator(@NotNull CallFrameView frame) {
        Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
        return DebuggerViewSupport.DefaultImpls.createFrameEvaluator(this, frame);
    }

    @Override
    public boolean canNavigateToSource(@NotNull Variable variable, @NotNull VariableContext context) {
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return DebuggerViewSupport.DefaultImpls.canNavigateToSource(this, variable, context);
    }

    @Override
    public void computeSourcePosition(@NotNull String name, @Nullable Value value, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XNavigatable navigatable) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)navigatable, (String)"navigatable");
        DebuggerViewSupport.DefaultImpls.computeSourcePosition(this, name, value, variable, context, navigatable);
    }

    @Override
    @NotNull
    public ThreeState computeInlineDebuggerData(@NotNull String name, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XInlineDebuggerDataCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        return DebuggerViewSupport.DefaultImpls.computeInlineDebuggerData(this, name, variable, context, callback);
    }

    @Override
    @Nullable
    public Promise<?> computeAdditionalObjectProperties(@NotNull ObjectValue value, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XCompositeNode node) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        return DebuggerViewSupport.DefaultImpls.computeAdditionalObjectProperties(this, value, variable, context, node);
    }

    @Override
    @Nullable
    public Value transformErrorOnGetUsedReferenceValue(@Nullable Value value, @Nullable String error) {
        return DebuggerViewSupport.DefaultImpls.transformErrorOnGetUsedReferenceValue(this, value, error);
    }

    @Override
    public boolean isInLibraryContent(@NotNull SourceInfo sourceInfo, @Nullable Script script) {
        Intrinsics.checkParameterIsNotNull((Object)sourceInfo, (String)"sourceInfo");
        return DebuggerViewSupport.DefaultImpls.isInLibraryContent(this, sourceInfo, script);
    }
}

