/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide;

import com.intellij.idea.StartupUtil;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullLazyValue;
import io.netty.channel.oio.OioEventLoopGroup;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.BuiltInServerManager;
import org.jetbrains.ide.CustomPortServerManager;
import org.jetbrains.io.BuiltInServer;
import org.jetbrains.io.SubServer;

public class BuiltInServerManagerImpl
extends BuiltInServerManager {
    private static final Logger LOG = Logger.getInstance(BuiltInServerManager.class);
    public static final NotNullLazyValue<NotificationGroup> NOTIFICATION_GROUP = new NotNullLazyValue<NotificationGroup>(){

        @NotNull
        protected NotificationGroup compute() {
            NotificationGroup notificationGroup = new NotificationGroup("Built-in Server", NotificationDisplayType.STICKY_BALLOON, true);
            if (notificationGroup == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/ide/BuiltInServerManagerImpl$1", "compute"));
            }
            return notificationGroup;
        }
    };
    @NonNls
    public static final String PROPERTY_RPC_PORT = "rpc.port";
    private static final int PORTS_COUNT = 20;
    private final AtomicBoolean started = new AtomicBoolean(false);
    @Nullable
    private BuiltInServer server;

    public int getPort() {
        return this.server == null ? BuiltInServerManagerImpl.getDefaultPort() : this.server.getPort();
    }

    public BuiltInServerManager waitForStart() {
        Future<?> serverStartFuture = this.startServerInPooledThread();
        if (serverStartFuture != null) {
            LOG.assertTrue(ApplicationManager.getApplication().isUnitTestMode() || !ApplicationManager.getApplication().isDispatchThread());
            try {
                serverStartFuture.get();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
        return this;
    }

    private static int getDefaultPort() {
        if (System.getProperty(PROPERTY_RPC_PORT) == null) {
            return ApplicationManager.getApplication().isUnitTestMode() ? 64463 : 63342;
        }
        return Integer.parseInt(System.getProperty(PROPERTY_RPC_PORT));
    }

    public void initComponent() {
        this.startServerInPooledThread();
    }

    private Future<?> startServerInPooledThread() {
        if (!this.started.compareAndSet(false, true)) {
            return null;
        }
        return ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                try {
                    BuiltInServer mainServer = StartupUtil.getServer();
                    if (mainServer == null || mainServer.getEventLoopGroup() instanceof OioEventLoopGroup) {
                        BuiltInServerManagerImpl.this.server = BuiltInServer.start(1, BuiltInServerManagerImpl.getDefaultPort(), 20, false, null);
                    } else {
                        BuiltInServerManagerImpl.this.server = BuiltInServer.start(mainServer.getEventLoopGroup(), false, BuiltInServerManagerImpl.getDefaultPort(), 20, true, null);
                    }
                    BuiltInServerManagerImpl.bindCustomPorts(BuiltInServerManagerImpl.this.server);
                }
                catch (Throwable e) {
                    LOG.info(e);
                    ((NotificationGroup)NOTIFICATION_GROUP.getValue()).createNotification("Cannot start internal HTTP server. Git integration, JavaScript debugger and LiveEdit may operate with errors. Please check your firewall settings and restart " + ApplicationNamesInfo.getInstance().getFullProductName(), NotificationType.ERROR).notify(null);
                    return;
                }
                LOG.info("built-in server started, port " + BuiltInServerManagerImpl.this.server.getPort());
                Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)BuiltInServerManagerImpl.this.server);
            }
        });
    }

    @Nullable
    public Disposable getServerDisposable() {
        return this.server;
    }

    private static void bindCustomPorts(@NotNull BuiltInServer server) {
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "org/jetbrains/ide/BuiltInServerManagerImpl", "bindCustomPorts"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        for (CustomPortServerManager customPortServerManager : (CustomPortServerManager[])CustomPortServerManager.EP_NAME.getExtensions()) {
            try {
                new SubServer(customPortServerManager, server).bind(customPortServerManager.getPort());
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }
}

