/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.model;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenId;

public class MavenWorkspaceMap
implements Serializable {
    private final Map<MavenId, Data> myMapping = new HashMap<MavenId, Data>();

    public void register(@NotNull MavenId id, @NotNull File file) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "org/jetbrains/idea/maven/model/MavenWorkspaceMap", "register"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/maven/model/MavenWorkspaceMap", "register"));
        }
        this.register(id, file, null);
    }

    public void register(@NotNull MavenId id, @NotNull File file, @Nullable File outputFile) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "org/jetbrains/idea/maven/model/MavenWorkspaceMap", "register"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/maven/model/MavenWorkspaceMap", "register"));
        }
        for (MavenId each : MavenWorkspaceMap.getAllIDs(id)) {
            this.myMapping.put(each, new Data(id, file, outputFile));
        }
    }

    public void unregister(@NotNull MavenId id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "org/jetbrains/idea/maven/model/MavenWorkspaceMap", "unregister"));
        }
        for (MavenId each : MavenWorkspaceMap.getAllIDs(id)) {
            this.myMapping.remove(each);
        }
    }

    @Nullable
    public Data findFileAndOriginalId(@NotNull MavenId dependencyId) {
        if (dependencyId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencyId", "org/jetbrains/idea/maven/model/MavenWorkspaceMap", "findFileAndOriginalId"));
        }
        return this.myMapping.get(dependencyId);
    }

    @NotNull
    public Set<MavenId> getAvailableIds() {
        Set<MavenId> set = this.myMapping.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/model/MavenWorkspaceMap", "getAvailableIds"));
        }
        return set;
    }

    private static MavenId[] getAllIDs(MavenId id) {
        String version = id.getVersion();
        if (version != null && version.contains("SNAPSHOT")) {
            return new MavenId[]{id, new MavenId(id.getGroupId(), id.getArtifactId(), "LATEST")};
        }
        return new MavenId[]{id, new MavenId(id.getGroupId(), id.getArtifactId(), "LATEST"), new MavenId(id.getGroupId(), id.getArtifactId(), "RELEASE")};
    }

    public MavenWorkspaceMap copy() {
        MavenWorkspaceMap result = new MavenWorkspaceMap();
        result.myMapping.putAll(this.myMapping);
        return result;
    }

    public static class Data
    implements Serializable {
        public final MavenId originalId;
        private final File file;
        private final File outputFile;

        private Data(MavenId originalId, File file, File outputFile) {
            this.originalId = originalId;
            this.file = file;
            this.outputFile = outputFile;
        }

        public File getFile(String type) {
            return this.outputFile == null || "pom".equalsIgnoreCase(type) ? this.file : this.outputFile;
        }
    }
}

