/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.build.ant;

import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.GenerationOptions;
import com.intellij.compiler.ant.GenerationUtils;
import com.intellij.compiler.ant.Generator;
import com.intellij.compiler.ant.ModuleChunk;
import com.intellij.compiler.ant.Tag;
import com.intellij.compiler.ant.taskdefs.Copy;
import com.intellij.compiler.ant.taskdefs.Delete;
import com.intellij.compiler.ant.taskdefs.FileSet;
import com.intellij.compiler.ant.taskdefs.Jar;
import com.intellij.compiler.ant.taskdefs.Manifest;
import com.intellij.compiler.ant.taskdefs.Mkdir;
import com.intellij.compiler.ant.taskdefs.Property;
import com.intellij.compiler.ant.taskdefs.Target;
import com.intellij.compiler.ant.taskdefs.Zip;
import com.intellij.compiler.ant.taskdefs.ZipFileSet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.build.PluginBuildConfiguration;
import org.jetbrains.idea.devkit.build.PluginBuildUtil;
import org.jetbrains.idea.devkit.build.PrepareToDeployAction;
import org.jetbrains.idea.devkit.build.ant.PluginBuildProperties;

public class BuildJarTarget
extends Target {
    public BuildJarTarget(ModuleChunk chunk, GenerationOptions genOptions, PluginBuildConfiguration moduleBuildProperties) {
        super(PluginBuildProperties.getBuildJarTargetName(chunk.getName()), BuildProperties.getCompileTargetName((String)chunk.getName()), DevKitBundle.message("ant.build.jar.description", chunk.getName()), null);
        File moduleBaseDir = chunk.getBaseDir();
        Module[] modules = chunk.getModules();
        Module module = modules[0];
        String moduleName = module.getName();
        HashSet<Library> libs = new HashSet<Library>();
        for (Module module1 : modules) {
            PluginBuildUtil.getLibraries(module1, libs);
        }
        String jarPathPropertyRef = BuildProperties.propertyRef((String)PluginBuildProperties.getJarPathProperty(moduleName));
        if (libs.isEmpty()) {
            this.add((Generator)BuildJarTarget.createPluginsJar(jarPathPropertyRef, modules, moduleBaseDir, genOptions, moduleBuildProperties));
        } else {
            String tempSuffix = "temp";
            File jarDir = new File(moduleBaseDir.getParentFile(), "temp");
            String tempDir = GenerationUtils.toRelativePath((String)jarDir.getPath(), (ModuleChunk)chunk, (GenerationOptions)genOptions);
            String tempDirProperty = BuildProperties.getTempDirForModuleProperty((String)moduleName);
            this.add((Generator)new Property(tempDirProperty, tempDir));
            this.add((Generator)new Mkdir(BuildProperties.propertyRef((String)tempDirProperty)));
            this.add((Generator)new Mkdir(BuildProperties.propertyRef((String)tempDirProperty) + "/lib"));
            String libRelativePath = BuildProperties.propertyRef((String)tempDirProperty) + "/lib/";
            this.add((Generator)BuildJarTarget.createPluginsJar(libRelativePath + chunk.getName() + ".jar", modules, moduleBaseDir, genOptions, moduleBuildProperties));
            for (Library lib : libs) {
                VirtualFile[] files;
                for (VirtualFile file : files = lib.getFiles(OrderRootType.CLASSES)) {
                    String relativePath = GenerationUtils.toRelativePath((VirtualFile)file, (ModuleChunk)chunk, (GenerationOptions)genOptions);
                    if (file.getFileSystem() instanceof JarFileSystem) {
                        this.add((Generator)new Copy(relativePath, libRelativePath + file.getName()));
                        continue;
                    }
                    Jar jar = new Jar(libRelativePath + file.getNameWithoutExtension() + ".jar", "preserve");
                    jar.add((Generator)new ZipFileSet(relativePath, "", true));
                    this.add((Generator)jar);
                }
            }
            Zip zipTag = new Zip(jarPathPropertyRef);
            zipTag.add((Generator)new FileSet(tempDir));
            this.add((Generator)zipTag);
            this.add((Generator)new Delete(BuildProperties.propertyRef((String)tempDirProperty)));
        }
    }

    private static Tag createPluginsJar(@NonNls String jarPathProperty, Module[] modules, File moduleBaseDir, GenerationOptions genOptions, PluginBuildConfiguration moduleBuildProperties) {
        java.util.jar.Manifest manifest;
        Jar jarTag = new Jar(jarPathProperty, "preserve");
        for (Module m : modules) {
            String path = VfsUtil.urlToPath((String)CompilerModuleExtension.getInstance((Module)m).getCompilerOutputUrl());
            String relativePath = GenerationUtils.toRelativePath((String)path, (File)moduleBaseDir, (Module)m, (GenerationOptions)genOptions);
            jarTag.add((Generator)new ZipFileSet(relativePath, "", true));
        }
        Module module = modules[0];
        String pluginXmlPath = moduleBuildProperties.getPluginXmlPath();
        String relativePluginXMLPath = GenerationUtils.toRelativePath((String)pluginXmlPath, (File)moduleBaseDir, (Module)module, (GenerationOptions)genOptions);
        jarTag.add((Generator)new ZipFileSet(relativePluginXMLPath, "META-INF/plugin.xml", false));
        Manifest manifestTag = new Manifest();
        jarTag.add((Generator)manifestTag);
        try {
            manifest = PrepareToDeployAction.createOrFindManifest(moduleBuildProperties);
        }
        catch (IOException e) {
            return jarTag;
        }
        manifestTag.applyAttributes(manifest);
        return jarTag;
    }
}

