/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.build.ant;

import com.intellij.compiler.ant.BuildTargetsFactory;
import com.intellij.compiler.ant.ChunkBuildExtension;
import com.intellij.compiler.ant.CompositeGenerator;
import com.intellij.compiler.ant.GenerationOptions;
import com.intellij.compiler.ant.GenerationUtils;
import com.intellij.compiler.ant.Generator;
import com.intellij.compiler.ant.ModuleChunk;
import com.intellij.compiler.ant.taskdefs.Property;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.util.ArrayUtil;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.build.PluginBuildConfiguration;
import org.jetbrains.idea.devkit.build.PluginBuildUtil;
import org.jetbrains.idea.devkit.build.ant.BuildJarTarget;
import org.jetbrains.idea.devkit.build.ant.PluginBuildProperties;
import org.jetbrains.idea.devkit.module.PluginModuleType;

public class ChunkBuildPluginExtension
extends ChunkBuildExtension {
    @NotNull
    public String[] getTargets(ModuleChunk chunk) {
        String[] stringArray;
        if (ChunkBuildPluginExtension.isPlugins(chunk.getModules())) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = PluginBuildProperties.getBuildJarTargetName(chunk.getName());
        } else {
            stringArray = ArrayUtil.EMPTY_STRING_ARRAY;
        }
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/build/ant/ChunkBuildPluginExtension", "getTargets"));
        }
        return stringArray;
    }

    public void process(Project project, ModuleChunk chunk, GenerationOptions genOptions, CompositeGenerator generator) {
        Module[] modules = chunk.getModules();
        if (ChunkBuildPluginExtension.isPlugins(modules)) {
            BuildTargetsFactory factory = BuildTargetsFactory.getInstance();
            Module module = modules[0];
            PluginBuildConfiguration buildProperties = PluginBuildConfiguration.getInstance(module);
            HashSet<Library> libs = new HashSet<Library>();
            PluginBuildUtil.getLibraries(module, libs);
            String jarPath = chunk.getBaseDir().getPath() + "/" + chunk.getName();
            jarPath = libs.isEmpty() ? jarPath + ".jar" : jarPath + ".zip";
            generator.add((Generator)new Property(PluginBuildProperties.getJarPathProperty(chunk.getName()), GenerationUtils.toRelativePath((String)jarPath, (ModuleChunk)chunk, (GenerationOptions)genOptions)), 1);
            generator.add(factory.createComment(DevKitBundle.message("ant.build.jar.comment", chunk.getName())), 1);
            generator.add((Generator)new BuildJarTarget(chunk, genOptions, buildProperties));
        }
    }

    private static boolean isPlugins(Module[] modules) {
        return modules.length == 1 && PluginModuleType.isOfType(modules[0]);
    }
}

