/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.jackrabbit.webdav.version.report;

import hidden.org.apache.jackrabbit.webdav.DavException;
import hidden.org.apache.jackrabbit.webdav.version.DeltaVConstants;
import hidden.org.apache.jackrabbit.webdav.version.DeltaVResource;
import hidden.org.apache.jackrabbit.webdav.version.report.ExpandPropertyReport;
import hidden.org.apache.jackrabbit.webdav.version.report.LocateByHistoryReport;
import hidden.org.apache.jackrabbit.webdav.version.report.Report;
import hidden.org.apache.jackrabbit.webdav.version.report.ReportInfo;
import hidden.org.apache.jackrabbit.webdav.version.report.VersionTreeReport;
import hidden.org.apache.jackrabbit.webdav.xml.DomUtil;
import hidden.org.apache.jackrabbit.webdav.xml.Namespace;
import hidden.org.apache.jackrabbit.webdav.xml.XmlSerializable;
import hidden.org.slf4j.Logger;
import hidden.org.slf4j.LoggerFactory;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ReportType
implements DeltaVConstants,
XmlSerializable {
    private static Logger log = LoggerFactory.getLogger(ReportType.class);
    private static final HashMap types = new HashMap();
    public static final ReportType VERSION_TREE = ReportType.register("version-tree", NAMESPACE, VersionTreeReport.class);
    public static final ReportType EXPAND_PROPERTY = ReportType.register("expand-property", NAMESPACE, ExpandPropertyReport.class);
    public static final ReportType LOCATE_BY_HISTORY = ReportType.register("locate-by-history", NAMESPACE, LocateByHistoryReport.class);
    private final String key;
    private final String localName;
    private final Namespace namespace;
    private final Class reportClass;

    private ReportType(String localName, Namespace namespace, String key, Class reportClass) {
        this.localName = localName;
        this.namespace = namespace;
        this.key = key;
        this.reportClass = reportClass;
    }

    public Report createReport(DeltaVResource resource, ReportInfo info) throws DavException {
        try {
            Report report = (Report)this.reportClass.newInstance();
            report.init(resource, info);
            return report;
        }
        catch (IllegalAccessException e) {
            throw new DavException(500, "Failed to create new report (" + this.reportClass.getName() + ") from class: " + e.getMessage());
        }
        catch (InstantiationException e) {
            throw new DavException(500, "Failed to create new report (" + this.reportClass.getName() + ") from class: " + e.getMessage());
        }
    }

    public Element toXml(Document document) {
        return DomUtil.createElement(document, this.localName, this.namespace);
    }

    public boolean isRequestedReportType(ReportInfo reqInfo) {
        if (reqInfo != null) {
            return this.getReportName().equals(reqInfo.getReportName());
        }
        return false;
    }

    public String getReportName() {
        return this.key;
    }

    public String getLocalName() {
        return this.localName;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public static ReportType register(String localName, Namespace namespace, Class reportClass) {
        if (localName == null || namespace == null || reportClass == null) {
            throw new IllegalArgumentException("A ReportType cannot be registered with a null name, namespace or report class");
        }
        String key = DomUtil.getQualifiedName(localName, namespace);
        if (types.containsKey(key)) {
            return (ReportType)types.get(key);
        }
        try {
            Object report = reportClass.newInstance();
            if (!(report instanceof Report)) {
                throw new IllegalArgumentException("Unable to register Report class: " + reportClass + " does not implement the Report interface.");
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Error while validating Report class: " + e.getMessage());
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Error while validating Report class.: " + e.getMessage());
        }
        ReportType type = new ReportType(localName, namespace, key, reportClass);
        types.put(key, type);
        return type;
    }

    public static ReportType getType(ReportInfo reportInfo) {
        if (reportInfo == null) {
            throw new IllegalArgumentException("ReportInfo must not be null.");
        }
        String key = reportInfo.getReportName();
        if (types.containsKey(key)) {
            return (ReportType)types.get(key);
        }
        throw new IllegalArgumentException("The request report '" + key + "' has not been registered yet.");
    }
}

