/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js.ast;

import com.google.dart.compiler.backend.js.ast.JsContext;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsVisitor;
import com.google.dart.compiler.backend.js.ast.JsVisitorWithContext;
import com.google.dart.compiler.backend.js.ast.SourceInfoAwareJsNode;
import com.google.dart.compiler.util.AstUtil;
import org.jetbrains.annotations.NotNull;

public class JsWhile
extends SourceInfoAwareJsNode
implements JsStatement {
    protected JsStatement body;
    protected JsExpression condition;

    public JsWhile() {
    }

    public JsWhile(JsExpression condition2, JsStatement body2) {
        this.condition = condition2;
        this.body = body2;
    }

    public JsStatement getBody() {
        return this.body;
    }

    public JsExpression getCondition() {
        return this.condition;
    }

    public void setBody(JsStatement body2) {
        this.body = body2;
    }

    public void setCondition(JsExpression condition2) {
        this.condition = condition2;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitWhile(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor2) {
        visitor2.accept(this.condition);
        visitor2.accept(this.body);
    }

    @Override
    public void traverse(JsVisitorWithContext v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            this.condition = v.accept(this.condition);
            this.body = v.acceptStatement(this.body);
        }
        v.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsWhile deepCopy() {
        JsExpression conditionCopy = AstUtil.deepCopy(this.condition);
        JsStatement bodyCopy = AstUtil.deepCopy(this.body);
        JsWhile jsWhile = new JsWhile(conditionCopy, bodyCopy).withMetadataFrom(this);
        if (jsWhile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/dart/compiler/backend/js/ast/JsWhile", "deepCopy"));
        }
        return jsWhile;
    }
}

