/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;

public class CompilationException
extends RuntimeException {
    private final PsiElement element;

    public CompilationException(@NotNull String message2, @Nullable Throwable cause, @NotNull PsiElement element2) {
        if (message2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/codegen/CompilationException", "<init>"));
        }
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/codegen/CompilationException", "<init>"));
        }
        super(CompilationException.getMessage(message2, cause, element2), cause);
        this.element = element2;
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement2 = this.element;
        if (psiElement2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/CompilationException", "getElement"));
        }
        return psiElement2;
    }

    private static String where(@NotNull Throwable cause) {
        if (cause == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cause", "org/jetbrains/kotlin/codegen/CompilationException", "where"));
        }
        StackTraceElement[] stackTrace = cause.getStackTrace();
        if (stackTrace != null && stackTrace.length > 0) {
            return stackTrace[0].getFileName() + ":" + stackTrace[0].getLineNumber();
        }
        return "unknown";
    }

    public static String getMessage(final @NotNull String message2, final @Nullable Throwable cause, final @NotNull PsiElement element2) {
        if (message2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/codegen/CompilationException", "getMessage"));
        }
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/codegen/CompilationException", "getMessage"));
        }
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                StringBuilder result2 = new StringBuilder("Back-end (JVM) Internal error: ").append(message2).append("\n");
                if (cause != null) {
                    String causeMessage = cause.getMessage();
                    result2.append("Cause: ").append(causeMessage == null ? cause.toString() : causeMessage).append("\n");
                }
                result2.append("File being compiled and position: ").append(DiagnosticUtils.atLocation(element2)).append("\n");
                result2.append("PsiElement: ").append(element2.getText()).append("\n");
                if (cause != null) {
                    result2.append("The root cause was thrown at: ").append(CompilationException.where(cause));
                }
                return result2.toString();
            }
        });
    }
}

