/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.actions.generate;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.actions.generate.UtilsKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.overrideImplement.OverrideMemberChooserObject;
import org.jetbrains.kotlin.idea.core.overrideImplement.OverrideMemberChooserObjectKt;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererOptions;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a'\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b\u00a2\u0006\u0002\u0010\t\u001a\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e\u001a\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013\u001a3\u0010\u0014\u001a\u0004\u0018\u00010\b*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00032\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\u001aH\u0086\u0010\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"MEMBER_RENDERER", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "confirmMemberRewrite", "", "targetClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "descriptors", "", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "(Lorg/jetbrains/kotlin/psi/KtClass;[Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)Z", "generateFunctionSkeleton", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "descriptor", "project", "Lcom/intellij/openapi/project/Project;", "getPropertiesToUseInGeneratedMember", "", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "findDeclaredFunction", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "name", "", "checkSuperClasses", "filter", "Lkotlin/Function1;", "idea"})
public final class UtilsKt {
    private static final DescriptorRenderer MEMBER_RENDERER = IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_IN_TYPES.withOptions((Function1<? super DescriptorRendererOptions, Unit>)((Function1)MEMBER_RENDERER.1.INSTANCE));

    @Nullable
    public static final FunctionDescriptor findDeclaredFunction(ClassDescriptor $receiver, @NotNull String name2, boolean checkSuperClasses, @NotNull Function1<? super FunctionDescriptor, Boolean> filter2) {
        while (true) {
            Object v2;
            FunctionDescriptor $receiver$iv;
            block3: {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
                Intrinsics.checkParameterIsNotNull(filter2, (String)"filter");
                MemberScope memberScope2 = $receiver.getUnsubstitutedMemberScope();
                Name name3 = Name.identifier(name2);
                Intrinsics.checkExpressionValueIsNotNull((Object)name3, (String)"Name.identifier(name)");
                Iterable iterable = memberScope2.getContributedFunctions(name3, NoLookupLocation.FROM_IDE);
                Iterator iterator2 = $receiver$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv = iterator2.next();
                    FunctionDescriptor it = (FunctionDescriptor)element$iv;
                    if (!(Intrinsics.areEqual((Object)it.getContainingDeclaration(), (Object)$receiver) && Intrinsics.areEqual((Object)((Object)it.getKind()), (Object)((Object)CallableMemberDescriptor.Kind.DECLARATION)) && (Boolean)filter2.invoke((Object)it) != false)) continue;
                    v2 = element$iv;
                    break block3;
                }
                v2 = null;
            }
            FunctionDescriptor functionDescriptor = v2;
            if (functionDescriptor != null) {
                $receiver$iv = functionDescriptor;
                FunctionDescriptor it = $receiver$iv;
                return it;
            }
            if (!checkSuperClasses) break;
            $receiver = DescriptorUtilsKt.getSuperClassOrAny($receiver);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<KtNamedDeclaration> getPropertiesToUseInGeneratedMember(@NotNull KtClassOrObject classOrObject) {
        void var1_1;
        void destination$iv$iv;
        void $receiver$iv$iv;
        Object it;
        Object element$iv2;
        Intrinsics.checkParameterIsNotNull((Object)classOrObject, (String)"classOrObject");
        ArrayList $receiver$iv = new ArrayList();
        ArrayList $receiver = $receiver$iv;
        Iterable $receiver$iv2 = classOrObject.getPrimaryConstructorParameters();
        for (Object element$iv2 : $receiver$iv2) {
            it = (KtParameter)element$iv2;
            if (!((KtParameter)it).hasValOrVar()) continue;
            ((Collection)$receiver).add(element$iv2);
        }
        $receiver$iv2 = classOrObject.getDeclarations();
        Iterator iterator2 = $receiver$iv2;
        element$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof KtProperty)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv2 = (List)destination$iv$iv;
        for (Object element$iv2 : $receiver$iv2) {
            boolean bl;
            block8: {
                it = (KtProperty)element$iv2;
                DeclarationDescriptor descriptor2 = ResolutionUtils.resolveToDescriptor((KtDeclaration)it);
                DeclarationDescriptor declarationDescriptor = descriptor2;
                if (declarationDescriptor instanceof ValueParameterDescriptor) {
                    bl = true;
                } else if (declarationDescriptor instanceof PropertyDescriptor) {
                    void $receiver$iv3;
                    Iterable $i$f$filterIsInstance = ((PropertyDescriptor)descriptor2).getAccessors();
                    for (Object element$iv3 : $receiver$iv3) {
                        PropertyAccessorDescriptor it2 = (PropertyAccessorDescriptor)element$iv3;
                        if (it2.isDefault()) continue;
                        bl = false;
                        break block8;
                    }
                    bl = true;
                } else {
                    bl = false;
                }
            }
            if (!bl) continue;
            ((Collection)$receiver).add(element$iv2);
        }
        return (List)var1_1;
    }

    public static final boolean confirmMemberRewrite(@NotNull KtClass targetClass, FunctionDescriptor ... descriptors) {
        Intrinsics.checkParameterIsNotNull((Object)targetClass, (String)"targetClass");
        Intrinsics.checkParameterIsNotNull((Object)descriptors, (String)"descriptors");
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        String functionsText2 = ArraysKt.joinToString$default((Object[])descriptors, (CharSequence)" and ", null, null, (int)0, null, (Function1)confirmMemberRewrite.functionsText.1.INSTANCE, (int)30, null);
        String message2 = "Functions " + functionsText2 + " are already defined" + "\n" + "for class " + targetClass.getName() + ". Do you want to delete them and proceed?";
        return Messages.showYesNoDialog((Project)targetClass.getProject(), (String)message2, (String)CodeInsightBundle.message((String)"generate.equals.and.hashcode.already.defined.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0;
    }

    @NotNull
    public static final KtNamedFunction generateFunctionSkeleton(@NotNull FunctionDescriptor descriptor2, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        KtCallableDeclaration ktCallableDeclaration = OverrideMemberChooserObjectKt.generateMember(OverrideMemberChooserObject.Companion.create$default(OverrideMemberChooserObject.Companion, project, descriptor2, descriptor2, OverrideMemberChooserObject.BodyType.EMPTY, false, 16, null), project);
        if (ktCallableDeclaration == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedFunction");
        }
        return (KtNamedFunction)ktCallableDeclaration;
    }

    @NotNull
    public static final /* synthetic */ DescriptorRenderer access$getMEMBER_RENDERER$p() {
        return MEMBER_RENDERER;
    }
}

