/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.framework;

import com.google.common.collect.Lists;
import com.intellij.framework.library.LibraryVersionProperties;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryPresentationManager;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.KotlinWithLibraryConfigurator;
import org.jetbrains.kotlin.idea.configuration.RuntimeLibraryFiles;
import org.jetbrains.kotlin.idea.framework.ui.CreateLibraryDialog;
import org.jetbrains.kotlin.idea.framework.ui.FileUIUtils;
import org.jetbrains.kotlin.idea.util.projectStructure.ProjectStructureUtilKt;

public abstract class CustomLibraryDescriptorWithDeferredConfig
extends CustomLibraryDescription {
    private static final String DEFAULT_LIB_DIR_NAME = "lib";
    private final String configuratorName;
    private final String libraryName;
    private final String dialogTitle;
    private final String modulesSeparatorCaption;
    private final LibraryKind libraryKind;
    private final Set<? extends LibraryKind> suitableLibraryKinds;
    private final VirtualFile projectBaseDir;
    private DeferredCopyFileRequests deferredCopyFileRequests;

    public CustomLibraryDescriptorWithDeferredConfig(@Nullable Project project, @NotNull String configuratorName, @NotNull String libraryName, @NotNull String dialogTitle, @NotNull String modulesSeparatorCaption, @NotNull LibraryKind libraryKind, @NotNull Set<? extends LibraryKind> suitableLibraryKinds) {
        if (configuratorName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuratorName", "org/jetbrains/kotlin/idea/framework/CustomLibraryDescriptorWithDeferredConfig", "<init>"));
        }
        if (libraryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryName", "org/jetbrains/kotlin/idea/framework/CustomLibraryDescriptorWithDeferredConfig", "<init>"));
        }
        if (dialogTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialogTitle", "org/jetbrains/kotlin/idea/framework/CustomLibraryDescriptorWithDeferredConfig", "<init>"));
        }
        if (modulesSeparatorCaption == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulesSeparatorCaption", "org/jetbrains/kotlin/idea/framework/CustomLibraryDescriptorWithDeferredConfig", "<init>"));
        }
        if (libraryKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryKind", "org/jetbrains/kotlin/idea/framework/CustomLibraryDescriptorWithDeferredConfig", "<init>"));
        }
        if (suitableLibraryKinds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suitableLibraryKinds", "org/jetbrains/kotlin/idea/framework/CustomLibraryDescriptorWithDeferredConfig", "<init>"));
        }
        this.projectBaseDir = project != null ? project.getBaseDir() : null;
        this.configuratorName = configuratorName;
        this.libraryName = libraryName;
        this.dialogTitle = dialogTitle;
        this.modulesSeparatorCaption = modulesSeparatorCaption;
        this.libraryKind = libraryKind;
        this.suitableLibraryKinds = suitableLibraryKinds;
    }

    @Nullable
    public DeferredCopyFileRequests getCopyFileRequests() {
        return this.deferredCopyFileRequests;
    }

    @NotNull
    public Set<? extends LibraryKind> getSuitableLibraryKinds() {
        Set<? extends LibraryKind> set = this.suitableLibraryKinds;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/framework/CustomLibraryDescriptorWithDeferredConfig", "getSuitableLibraryKinds"));
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishLibConfiguration(@NotNull Module module, @NotNull ModifiableRootModel rootModel) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/idea/framework/CustomLibraryDescriptorWithDeferredConfig", "finishLibConfiguration"));
        }
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "org/jetbrains/kotlin/idea/framework/CustomLibraryDescriptorWithDeferredConfig", "finishLibConfiguration"));
        }
        DeferredCopyFileRequests deferredCopyFileRequests = this.getCopyFileRequests();
        if (deferredCopyFileRequests == null) {
            return;
        }
        Library library = ProjectStructureUtilKt.findLibrary(rootModel.orderEntries(), (Function1<? super Library, Boolean>)new Function1<Library, Boolean>(){

            public Boolean invoke(@NotNull Library library) {
                if (library == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/kotlin/idea/framework/CustomLibraryDescriptorWithDeferredConfig$1", "invoke"));
                }
                LibraryPresentationManager libraryPresentationManager = LibraryPresentationManager.getInstance();
                List<VirtualFile> classFiles = Arrays.asList(library.getFiles(OrderRootType.CLASSES));
                return libraryPresentationManager.isLibraryOfKind(classFiles, CustomLibraryDescriptorWithDeferredConfig.this.libraryKind);
            }
        });
        if (library == null) {
            return;
        }
        Library.ModifiableModel model = library.getModifiableModel();
        try {
            deferredCopyFileRequests.performRequests(module.getProject(), ProjectStructureUtilKt.getModuleDir(module), model);
        }
        finally {
            model.commit();
        }
    }

    @Nullable
    public NewLibraryConfiguration createNewLibrary(@NotNull JComponent parentComponent, @Nullable VirtualFile contextDirectory) {
        File runtimeSrcJar;
        File reflectJar;
        File runtimeJar;
        if (parentComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentComponent", "org/jetbrains/kotlin/idea/framework/CustomLibraryDescriptorWithDeferredConfig", "createNewLibrary"));
        }
        KotlinWithLibraryConfigurator configurator = (KotlinWithLibraryConfigurator)ConfigureKotlinInProjectUtilsKt.getConfiguratorByName(this.configuratorName);
        assert (configurator != null) : "Configurator with name " + this.configuratorName + " should exists";
        this.deferredCopyFileRequests = new DeferredCopyFileRequests(configurator);
        String defaultPathToJarFile = this.projectBaseDir == null ? DEFAULT_LIB_DIR_NAME : FileUIUtils.createRelativePath(null, this.projectBaseDir, DEFAULT_LIB_DIR_NAME);
        RuntimeLibraryFiles files = configurator.getExistingJarFiles();
        File stdJarInDefaultPath = files.getRuntimeDestination(defaultPathToJarFile);
        if (this.projectBaseDir != null && stdJarInDefaultPath.exists()) {
            runtimeJar = stdJarInDefaultPath;
            reflectJar = files.getReflectDestination(defaultPathToJarFile);
            if (reflectJar != null && !reflectJar.exists()) {
                reflectJar = files.getReflectJar();
                assert (reflectJar != null) : "getReflectDestination != null, but getReflectJar == null";
                this.deferredCopyFileRequests.addCopyWithReplaceRequest(reflectJar, runtimeJar.getParent());
            }
            if (!(runtimeSrcJar = files.getRuntimeSourcesDestination(defaultPathToJarFile)).exists()) {
                runtimeSrcJar = files.getRuntimeSourcesJar();
                this.deferredCopyFileRequests.addCopyWithReplaceRequest(runtimeSrcJar, runtimeJar.getParent());
            }
        } else {
            CreateLibraryDialog dialog2 = new CreateLibraryDialog(defaultPathToJarFile, this.dialogTitle, this.modulesSeparatorCaption);
            dialog2.show();
            if (!dialog2.isOK()) {
                return null;
            }
            String copyIntoPath = dialog2.getCopyIntoPath();
            if (copyIntoPath != null) {
                for (File file : files.getAllJars()) {
                    this.deferredCopyFileRequests.addCopyWithReplaceRequest(file, copyIntoPath);
                }
            }
            runtimeJar = files.getRuntimeJar();
            reflectJar = files.getReflectJar();
            runtimeSrcJar = files.getRuntimeSourcesJar();
        }
        return this.createConfiguration(Arrays.asList(runtimeJar, reflectJar), runtimeSrcJar);
    }

    @NotNull
    protected NewLibraryConfiguration createConfiguration(final @NotNull List<File> libraryFiles, final @NotNull File librarySrcFile) {
        if (libraryFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryFiles", "org/jetbrains/kotlin/idea/framework/CustomLibraryDescriptorWithDeferredConfig", "createConfiguration"));
        }
        if (librarySrcFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "librarySrcFile", "org/jetbrains/kotlin/idea/framework/CustomLibraryDescriptorWithDeferredConfig", "createConfiguration"));
        }
        NewLibraryConfiguration newLibraryConfiguration = new NewLibraryConfiguration(this.libraryName, null, (LibraryProperties)new LibraryVersionProperties()){

            public void addRoots(@NotNull LibraryEditor editor) {
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/framework/CustomLibraryDescriptorWithDeferredConfig$2", "addRoots"));
                }
                for (File libraryFile : libraryFiles) {
                    if (libraryFile == null) continue;
                    editor.addRoot(VfsUtil.getUrlForLibraryRoot((File)libraryFile), OrderRootType.CLASSES);
                }
                editor.addRoot(VfsUtil.getUrlForLibraryRoot((File)librarySrcFile), OrderRootType.SOURCES);
            }
        };
        if (newLibraryConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/framework/CustomLibraryDescriptorWithDeferredConfig", "createConfiguration"));
        }
        return newLibraryConfiguration;
    }

    public static class DeferredCopyFileRequests {
        private final List<CopyFileRequest> copyFilesRequests = Lists.newArrayList();
        private final KotlinWithLibraryConfigurator configurator;

        public DeferredCopyFileRequests(KotlinWithLibraryConfigurator configurator) {
            this.configurator = configurator;
        }

        public void performRequests(@NotNull Project project, @NotNull String relativePath, Library.ModifiableModel model) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/framework/CustomLibraryDescriptorWithDeferredConfig$DeferredCopyFileRequests", "performRequests"));
            }
            if (relativePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "org/jetbrains/kotlin/idea/framework/CustomLibraryDescriptorWithDeferredConfig$DeferredCopyFileRequests", "performRequests"));
            }
            for (CopyFileRequest request : this.copyFilesRequests) {
                String destinationPath = FileUtil.isAbsolute((String)request.toDir) ? request.toDir : new File(relativePath, request.toDir).getPath();
                File resultFile = this.configurator.copyFileToDir(project, request.file, destinationPath);
                if (!request.replaceInLib) continue;
                ProjectStructureUtilKt.replaceFileRoot(model, request.file, resultFile);
            }
        }

        public void addCopyWithReplaceRequest(@NotNull File file, @NotNull String copyIntoPath) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/framework/CustomLibraryDescriptorWithDeferredConfig$DeferredCopyFileRequests", "addCopyWithReplaceRequest"));
            }
            if (copyIntoPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copyIntoPath", "org/jetbrains/kotlin/idea/framework/CustomLibraryDescriptorWithDeferredConfig$DeferredCopyFileRequests", "addCopyWithReplaceRequest"));
            }
            this.copyFilesRequests.add(new CopyFileRequest(copyIntoPath, file, true));
        }

        public static class CopyFileRequest {
            private final String toDir;
            private final File file;
            private final boolean replaceInLib;

            public CopyFileRequest(String dir, File file, boolean replaceInLib) {
                this.toDir = dir;
                this.file = file;
                this.replaceInLib = replaceInLib;
            }
        }
    }
}

