/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.references;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.MultiRangeReference;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.references.KtSimpleReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;

public class KtInvokeFunctionReference
extends KtSimpleReference<KtCallExpression>
implements MultiRangeReference {
    public KtInvokeFunctionReference(@NotNull KtCallExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/references/KtInvokeFunctionReference", "<init>"));
        }
        super(expression2);
    }

    public TextRange getRangeInElement() {
        return ((KtCallExpression)this.getElement()).getTextRange().shiftRight(-((KtCallExpression)this.getElement()).getTextOffset());
    }

    @Override
    @NotNull
    protected Collection<DeclarationDescriptor> getTargetDescriptors(@NotNull BindingContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/idea/references/KtInvokeFunctionReference", "getTargetDescriptors"));
        }
        Call call = CallUtilKt.getCall((KtElement)this.getElement(), context);
        ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilKt.getResolvedCall(call, context);
        if (resolvedCall instanceof VariableAsFunctionResolvedCall) {
            Set<DeclarationDescriptor> set = Collections.singleton(((VariableAsFunctionResolvedCall)((Object)resolvedCall)).getFunctionCall().getCandidateDescriptor());
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/references/KtInvokeFunctionReference", "getTargetDescriptors"));
            }
            return set;
        }
        if (call != null && resolvedCall != null && call.getCallType() == Call.CallType.INVOKE) {
            Set<DeclarationDescriptor> set = Collections.singleton(resolvedCall.getCandidateDescriptor());
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/references/KtInvokeFunctionReference", "getTargetDescriptors"));
            }
            return set;
        }
        List<DeclarationDescriptor> list2 = Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/references/KtInvokeFunctionReference", "getTargetDescriptors"));
        }
        return list2;
    }

    public List<TextRange> getRanges() {
        ArrayList<TextRange> list2 = new ArrayList<TextRange>();
        KtValueArgumentList valueArgumentList = ((KtCallExpression)this.getExpression()).getValueArgumentList();
        if (valueArgumentList != null) {
            if (valueArgumentList.getArguments().size() > 0) {
                ASTNode rPar;
                ASTNode valueArgumentListNode = valueArgumentList.getNode();
                ASTNode lPar = valueArgumentListNode.findChildByType((IElementType)KtTokens.LPAR);
                if (lPar != null) {
                    list2.add(this.getRange(lPar));
                }
                if ((rPar = valueArgumentListNode.findChildByType((IElementType)KtTokens.RPAR)) != null) {
                    list2.add(this.getRange(rPar));
                }
            } else {
                list2.add(this.getRange(valueArgumentList.getNode()));
            }
        }
        List<KtLambdaArgument> functionLiteralArguments = ((KtCallExpression)this.getExpression()).getLambdaArguments();
        for (KtLambdaArgument functionLiteralArgument : functionLiteralArguments) {
            KtLambdaExpression functionLiteralExpression = functionLiteralArgument.getLambdaExpression();
            list2.add(this.getRange(functionLiteralExpression.getLeftCurlyBrace()));
            ASTNode rightCurlyBrace = functionLiteralExpression.getRightCurlyBrace();
            if (rightCurlyBrace == null) continue;
            list2.add(this.getRange(rightCurlyBrace));
        }
        return list2;
    }

    private TextRange getRange(ASTNode node) {
        TextRange textRange = node.getTextRange();
        return textRange.shiftRight(-((KtCallExpression)this.getExpression()).getTextOffset());
    }

    @Override
    public boolean canRename() {
        return true;
    }

    @Override
    @Nullable
    public PsiElement handleElementRename(@Nullable String newElementName) {
        return ReferenceUtilKt.renameImplicitConventionalCall(this, newElementName);
    }
}

