/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.search.ideaExtensions;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.KtLightClass;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.search.ideaExtensions.KotlinAnnotatedElementsSearcher;
import org.jetbrains.kotlin.idea.search.ideaExtensions.KotlinAnnotatedElementsSearcher$Companion$getKotlinAnnotationCandidates$1$$special$;
import org.jetbrains.kotlin.idea.stubindex.KotlinAnnotationsIndex;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinAnnotatedElementsSearcher;", "Lcom/intellij/util/QueryExecutor;", "Lcom/intellij/psi/PsiModifierListOwner;", "Lcom/intellij/psi/search/searches/AnnotatedElementsSearch$Parameters;", "()V", "execute", "", "p", "consumer", "Lcom/intellij/util/Processor;", "Companion", "idea"})
public final class KotlinAnnotatedElementsSearcher
implements QueryExecutor<PsiModifierListOwner, AnnotatedElementsSearch.Parameters> {
    private static final Logger LOG;
    public static final Companion Companion;

    public boolean execute(@NotNull AnnotatedElementsSearch.Parameters p, @NotNull Processor<PsiModifierListOwner> consumer2) {
        Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
        Intrinsics.checkParameterIsNotNull(consumer2, (String)"consumer");
        PsiClass psiClass = p.getAnnotationClass();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"p.annotationClass");
        SearchScope searchScope2 = p.getScope();
        Intrinsics.checkExpressionValueIsNotNull((Object)searchScope2, (String)"p.scope");
        return org.jetbrains.kotlin.idea.search.ideaExtensions.KotlinAnnotatedElementsSearcher$Companion.processAnnotatedMembers$default(Companion, psiClass, searchScope2, null, (Function1)new Function1<KtDeclaration, Boolean>(consumer2){
            final /* synthetic */ Processor $consumer;

            public final boolean invoke(@NotNull KtDeclaration declaration) {
                boolean bl;
                Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                KtDeclaration ktDeclaration = declaration;
                if (ktDeclaration instanceof KtClass) {
                    KtLightClass lightClass2 = LightClassUtilsKt.toLightClass((KtClassOrObject)declaration);
                    bl = this.$consumer.process((Object)lightClass2);
                } else if (ktDeclaration instanceof KtNamedFunction || ktDeclaration instanceof KtSecondaryConstructor) {
                    KtDeclaration ktDeclaration2 = declaration;
                    if (ktDeclaration2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunction");
                    }
                    PsiMethod wrappedMethod = LightClassUtil.INSTANCE.getLightClassMethod((KtFunction)ktDeclaration2);
                    bl = this.$consumer.process((Object)wrappedMethod);
                } else {
                    bl = true;
                }
                return bl;
            }
            {
                this.$consumer = processor2;
                super(1);
            }
        }, 4, null);
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance((String)"#com.intellij.psi.impl.search.AnnotatedMembersSearcher");
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0002J@\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0014\b\u0002\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00100\u00142\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00100\u0014R\u001c\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinAnnotatedElementsSearcher$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "kotlin.jvm.PlatformType", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "getKotlinAnnotationCandidates", "", "Lcom/intellij/psi/PsiElement;", "annClass", "Lcom/intellij/psi/PsiClass;", "useScope", "Lcom/intellij/psi/search/SearchScope;", "notKtAnnotationEntry", "", "found", "processAnnotatedMembers", "preFilter", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "consumer", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "idea"})
    public static final class Companion {
        private final Logger getLOG() {
            return LOG;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean processAnnotatedMembers(@NotNull PsiClass annClass, @NotNull SearchScope useScope, @NotNull Function1<? super KtAnnotationEntry, Boolean> preFilter, @NotNull Function1<? super KtDeclaration, Boolean> consumer2) {
            Unit unit;
            Unit unit2;
            Intrinsics.checkParameterIsNotNull((Object)annClass, (String)"annClass");
            Intrinsics.checkParameterIsNotNull((Object)useScope, (String)"useScope");
            Intrinsics.checkParameterIsNotNull(preFilter, (String)"preFilter");
            Intrinsics.checkParameterIsNotNull(consumer2, (String)"consumer");
            boolean bl = annClass.isAnnotationType();
            if (_Assertions.ENABLED) {
                void value$iv;
                if (value$iv == false) {
                    String message$iv = "Annotation type should be passed to annotated members search";
                    throw (Throwable)((Object)new AssertionError((Object)message$iv));
                }
                unit2 = Unit.INSTANCE;
            } else {
                unit2 = Unit.INSTANCE;
            }
            String annotationFQN = annClass.getQualifiedName();
            boolean message$iv = annotationFQN != null;
            if (_Assertions.ENABLED) {
                void value$iv;
                if (value$iv == false) {
                    String message$iv$iv = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)message$iv$iv));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
            Collection<PsiElement> candidates = this.getKotlinAnnotationCandidates(annClass, useScope);
            for (PsiElement elt : candidates) {
                boolean result2;
                if (this.notKtAnnotationEntry(elt) || (result2 = ((Boolean)ApplicationUtilsKt.runReadAction((Function0)new Function0<Boolean>(elt, preFilter, annotationFQN, consumer2){
                    final /* synthetic */ PsiElement $elt;
                    final /* synthetic */ Function1 $preFilter;
                    final /* synthetic */ String $annotationFQN;
                    final /* synthetic */ Function1 $consumer;

                    public final boolean invoke() {
                        if (!(this.$elt instanceof KtAnnotationEntry)) {
                            return true;
                        }
                        if (!((Boolean)this.$preFilter.invoke((Object)this.$elt)).booleanValue()) {
                            return true;
                        }
                        PsiElement $receiver$iv = this.$elt;
                        KtDeclaration ktDeclaration = (KtDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtDeclaration.class, (boolean)true);
                        if (ktDeclaration == null) {
                            return true;
                        }
                        KtDeclaration declaration = ktDeclaration;
                        BindingContext context = ResolutionUtils.analyze((KtElement)this.$elt, BodyResolveMode.PARTIAL);
                        AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)context.get(BindingContext.ANNOTATION, this.$elt);
                        if (annotationDescriptor == null) {
                            return true;
                        }
                        AnnotationDescriptor annotationDescriptor2 = annotationDescriptor;
                        ClassifierDescriptor classifierDescriptor = annotationDescriptor2.getType().getConstructor().getDeclarationDescriptor();
                        if (classifierDescriptor == null) {
                            return true;
                        }
                        ClassifierDescriptor descriptor2 = classifierDescriptor;
                        if (!Intrinsics.areEqual((Object)DescriptorUtils.getFqName(descriptor2).asString(), (Object)this.$annotationFQN)) {
                            return true;
                        }
                        return (Boolean)this.$consumer.invoke((Object)declaration) != false;
                    }
                    {
                        this.$elt = psiElement2;
                        this.$preFilter = function1;
                        this.$annotationFQN = string;
                        this.$consumer = function12;
                        super(0);
                    }
                })).booleanValue())) continue;
                return false;
            }
            return true;
        }

        public static /* bridge */ /* synthetic */ boolean processAnnotatedMembers$default(Companion companion, PsiClass psiClass, SearchScope searchScope2, Function1 function1, Function1 function12, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: processAnnotatedMembers");
            }
            if ((n & 4) != 0) {
                function1 = processAnnotatedMembers.1.INSTANCE;
            }
            return companion.processAnnotatedMembers(psiClass, searchScope2, (Function1<? super KtAnnotationEntry, Boolean>)function1, (Function1<? super KtDeclaration, Boolean>)function12);
        }

        private final Collection<PsiElement> getKotlinAnnotationCandidates(PsiClass annClass, SearchScope useScope) {
            return (Collection)ApplicationUtilsKt.runReadAction((Function0)new Function0<Collection<? extends PsiElement>>(useScope, annClass){
                final /* synthetic */ SearchScope $useScope;
                final /* synthetic */ PsiClass $annClass;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final Collection<PsiElement> invoke() {
                    void var3_4;
                    void $receiver$iv$iv;
                    if (this.$useScope instanceof GlobalSearchScope) {
                        String string = this.$annClass.getName();
                        if (string == null) {
                            return CollectionsKt.emptyList();
                        }
                        String name2 = string;
                        Collection<KtAnnotationEntry> collection = KotlinAnnotationsIndex.getInstance().get(name2, this.$annClass.getProject(), (GlobalSearchScope)this.$useScope);
                        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"KotlinAnnotationsIndex.g\u2026nClass.project, useScope)");
                        return collection;
                    }
                    SearchScope searchScope2 = this.$useScope;
                    if (searchScope2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.search.LocalSearchScope");
                    }
                    Object[] $receiver$iv = ((LocalSearchScope)searchScope2).getScope();
                    Object[] objectArray = $receiver$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
                        void action$iv$iv$iv;
                        void $receiver$iv$iv$iv;
                        void $receiver$iv$iv2;
                        PsiElement it;
                        void element$iv$iv = $receiver$iv$iv[i];
                        PsiElement psiElement2 = it = (PsiElement)element$iv$iv;
                        Function1 function1 = null;
                        boolean bl = true;
                        Object var10_12 = null;
                        if (var10_12 != null) {
                            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: collectDescendantsOfType");
                        }
                        if (bl & true) {
                            function1 = Companion$getKotlinAnnotationCandidates$1$$special$$inlined$collectDescendantsOfType$1.INSTANCE;
                        }
                        PsiElement psiElement3 = psiElement2;
                        ArrayList<E> result$iv$iv = new ArrayList<E>();
                        void var11_13 = $receiver$iv$iv2;
                        Function1 function12 = (Function1)new Function1<KtAnnotationEntry, Unit>(function1, result$iv$iv){
                            final /* synthetic */ Function1 $predicate;
                            final /* synthetic */ ArrayList $result;

                            /*
                             * Ignored method signature, as it can't be verified against descriptor
                             */
                            public final void invoke(PsiElement it) {
                                if (((Boolean)this.$predicate.invoke((Object)it)).booleanValue()) {
                                    this.$result.add(it);
                                }
                            }
                            {
                                this.$predicate = function1;
                                this.$result = arrayList;
                                super(1);
                            }
                        };
                        $receiver$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor((Function1)action$iv$iv$iv){
                            final /* synthetic */ Function1 $action;

                            public void visitElement(PsiElement element2) {
                                PsiElement it = element2;
                                if (true) {
                                    super.visitElement(element2);
                                }
                                if (element2 instanceof KtAnnotationEntry) {
                                    this.$action.invoke((Object)element2);
                                }
                            }
                            {
                                this.$action = function1;
                            }
                        });
                        Iterable list$iv$iv = result$iv$iv;
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    return (List)var3_4;
                }
                {
                    this.$useScope = searchScope2;
                    this.$annClass = psiClass;
                    super(0);
                }
            });
        }

        private final boolean notKtAnnotationEntry(PsiElement found2) {
            if (found2 instanceof KtAnnotationEntry) {
                return false;
            }
            VirtualFile faultyContainer = PsiUtilCore.getVirtualFile((PsiElement)found2);
            this.getLOG().error("Non annotation in annotations list: " + faultyContainer + "; element:" + found2);
            if (faultyContainer != null && faultyContainer.isValid()) {
                FileBasedIndex.getInstance().requestReindex(faultyContainer);
            }
            return true;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

