/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.js.PredefinedAnnotation;
import org.jetbrains.kotlin.js.resolve.AbstractNativeAnnotationsChecker;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/js/resolve/AbstractNativeIndexerChecker;", "Lorg/jetbrains/kotlin/js/resolve/AbstractNativeAnnotationsChecker;", "requiredAnnotation", "Lorg/jetbrains/kotlin/js/PredefinedAnnotation;", "indexerKind", "", "requiredParametersCount", "", "(Lorg/jetbrains/kotlin/js/PredefinedAnnotation;Ljava/lang/String;I)V", "additionalCheck", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "js.frontend"})
public abstract class AbstractNativeIndexerChecker
extends AbstractNativeAnnotationsChecker {
    private final String indexerKind;
    private final int requiredParametersCount;

    @Override
    public void additionalCheck(@NotNull KtNamedFunction declaration, @NotNull FunctionDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder) {
        ClassDescriptor firstParamClassDescriptor;
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)diagnosticHolder, (String)"diagnosticHolder");
        List<ValueParameterDescriptor> parameters2 = descriptor2.getValueParameters();
        KotlinBuiltIns builtIns = DescriptorUtilsKt.getBuiltIns(descriptor2);
        if (parameters2.size() > 0 && Intrinsics.areEqual((Object)(firstParamClassDescriptor = DescriptorUtils.getClassDescriptorForType(parameters2.get(0).getType())), (Object)builtIns.getString()) ^ true && !DescriptorUtils.isSubclass(firstParamClassDescriptor, builtIns.getNumber())) {
            diagnosticHolder.report(ErrorsJs.NATIVE_INDEXER_KEY_SHOULD_BE_STRING_OR_NUMBER.on((KtElement)((PsiElement)CollectionsKt.firstOrNull(declaration.getValueParameters())), this.indexerKind));
        }
        if (parameters2.size() != this.requiredParametersCount) {
            diagnosticHolder.report(ErrorsJs.NATIVE_INDEXER_WRONG_PARAMETER_COUNT.on((KtElement)((PsiElement)declaration), this.requiredParametersCount, this.indexerKind));
        }
        for (KtParameter parameter : declaration.getValueParameters()) {
            if (!parameter.hasDefaultValue()) continue;
            diagnosticHolder.report(ErrorsJs.NATIVE_INDEXER_CAN_NOT_HAVE_DEFAULT_ARGUMENTS.on((KtElement)((PsiElement)parameter), this.indexerKind));
        }
    }

    public AbstractNativeIndexerChecker(@NotNull PredefinedAnnotation requiredAnnotation, @NotNull String indexerKind, int requiredParametersCount) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)requiredAnnotation), (String)"requiredAnnotation");
        Intrinsics.checkParameterIsNotNull((Object)indexerKind, (String)"indexerKind");
        super(requiredAnnotation);
        this.indexerKind = indexerKind;
        this.requiredParametersCount = requiredParametersCount;
    }
}

