/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.structure.impl;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotation;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotationArgument;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.JavaClassifierType;
import org.jetbrains.kotlin.load.java.structure.JavaConstructor;
import org.jetbrains.kotlin.load.java.structure.JavaField;
import org.jetbrains.kotlin.load.java.structure.JavaMethod;
import org.jetbrains.kotlin.load.java.structure.JavaPackage;
import org.jetbrains.kotlin.load.java.structure.JavaType;
import org.jetbrains.kotlin.load.java.structure.JavaTypeParameter;
import org.jetbrains.kotlin.load.java.structure.JavaValueParameter;
import org.jetbrains.kotlin.load.java.structure.impl.JavaAnnotationArgumentImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaAnnotationImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaClassImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaClassifierTypeImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaConstructorImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaFieldImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaMethodImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaPackageImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaTypeImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaTypeParameterImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaValueParameterImpl;
import org.jetbrains.kotlin.name.Name;

public class JavaElementCollectionFromPsiArrayUtil {
    private JavaElementCollectionFromPsiArrayUtil() {
    }

    @NotNull
    private static <Psi, Java> List<Java> convert(@NotNull Psi[] elements, @NotNull Factory<Psi, Java> factory2) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "convert"));
        }
        if (factory2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "convert"));
        }
        if (elements.length == 0) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "convert"));
            }
            return list2;
        }
        ArrayList<Java> result2 = new ArrayList<Java>(elements.length);
        for (Psi element2 : elements) {
            result2.add(factory2.create(element2));
        }
        ArrayList<Java> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "convert"));
        }
        return arrayList;
    }

    @NotNull
    private static <Psi, Java> List<Java> convert(@NotNull Iterable<Psi> elements, final @NotNull Factory<Psi, Java> factory2) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "convert"));
        }
        if (factory2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "convert"));
        }
        if (!elements.iterator().hasNext()) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "convert"));
            }
            return list2;
        }
        List list3 = CollectionsKt.map(elements, (Function1)new Function1<Psi, Java>(){

            public Java invoke(Psi psi) {
                return factory2.create(psi);
            }
        });
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "convert"));
        }
        return list3;
    }

    @NotNull
    public static Collection<JavaClass> classes(@NotNull PsiClass[] classes2) {
        if (classes2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "classes"));
        }
        List<JavaClass> list2 = JavaElementCollectionFromPsiArrayUtil.convert(classes2, Factories.CLASSES);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "classes"));
        }
        return list2;
    }

    @NotNull
    public static Collection<JavaClass> classes(@NotNull Iterable<PsiClass> classes2) {
        if (classes2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "classes"));
        }
        List<JavaClass> list2 = JavaElementCollectionFromPsiArrayUtil.convert(classes2, Factories.CLASSES);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "classes"));
        }
        return list2;
    }

    @NotNull
    public static Collection<JavaPackage> packages(@NotNull PsiPackage[] packages, final @NotNull GlobalSearchScope scope2) {
        if (packages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packages", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "packages"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "packages"));
        }
        List<JavaPackage> list2 = JavaElementCollectionFromPsiArrayUtil.convert(packages, new Factory<PsiPackage, JavaPackage>(){

            @Override
            @NotNull
            public JavaPackage create(@NotNull PsiPackage aPackage) {
                if (aPackage == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aPackage", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$2", "create"));
                }
                JavaPackageImpl javaPackageImpl = new JavaPackageImpl(aPackage, scope2);
                if (javaPackageImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$2", "create"));
                }
                return javaPackageImpl;
            }
        });
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "packages"));
        }
        return list2;
    }

    @NotNull
    public static Collection<JavaMethod> methods(@NotNull PsiMethod[] methods2) {
        if (methods2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methods", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "methods"));
        }
        List<JavaMethod> list2 = JavaElementCollectionFromPsiArrayUtil.convert(methods2, Factories.METHODS);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "methods"));
        }
        return list2;
    }

    @NotNull
    public static Collection<JavaMethod> methods(@NotNull Iterable<PsiMethod> methods2) {
        if (methods2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methods", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "methods"));
        }
        List<JavaMethod> list2 = JavaElementCollectionFromPsiArrayUtil.convert(methods2, Factories.METHODS);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "methods"));
        }
        return list2;
    }

    @NotNull
    public static Collection<JavaConstructor> constructors(@NotNull Iterable<PsiMethod> methods2) {
        if (methods2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methods", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "constructors"));
        }
        List<JavaConstructor> list2 = JavaElementCollectionFromPsiArrayUtil.convert(methods2, Factories.CONSTRUCTORS);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "constructors"));
        }
        return list2;
    }

    @NotNull
    public static Collection<JavaField> fields(@NotNull Iterable<PsiField> fields) {
        if (fields == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fields", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "fields"));
        }
        List<JavaField> list2 = JavaElementCollectionFromPsiArrayUtil.convert(fields, Factories.FIELDS);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "fields"));
        }
        return list2;
    }

    @NotNull
    public static List<JavaValueParameter> valueParameters(@NotNull PsiParameter[] parameters2) {
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "valueParameters"));
        }
        List<JavaValueParameter> list2 = JavaElementCollectionFromPsiArrayUtil.convert(parameters2, Factories.VALUE_PARAMETERS);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "valueParameters"));
        }
        return list2;
    }

    @NotNull
    public static List<JavaTypeParameter> typeParameters(@NotNull PsiTypeParameter[] typeParameters) {
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "typeParameters"));
        }
        List<JavaTypeParameter> list2 = JavaElementCollectionFromPsiArrayUtil.convert(typeParameters, Factories.TYPE_PARAMETERS);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "typeParameters"));
        }
        return list2;
    }

    @NotNull
    public static List<JavaType> types(@NotNull PsiType[] types2) {
        if (types2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "types"));
        }
        List<JavaType> list2 = JavaElementCollectionFromPsiArrayUtil.convert(types2, Factories.TYPES);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "types"));
        }
        return list2;
    }

    @NotNull
    public static Collection<JavaClassifierType> classifierTypes(@NotNull PsiClassType[] classTypes) {
        if (classTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classTypes", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "classifierTypes"));
        }
        List<JavaClassifierType> list2 = JavaElementCollectionFromPsiArrayUtil.convert(classTypes, Factories.CLASSIFIER_TYPES);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "classifierTypes"));
        }
        return list2;
    }

    @NotNull
    public static Collection<JavaAnnotation> annotations(@NotNull PsiAnnotation[] annotations2) {
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "annotations"));
        }
        List<JavaAnnotation> list2 = JavaElementCollectionFromPsiArrayUtil.convert(annotations2, Factories.ANNOTATIONS);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "annotations"));
        }
        return list2;
    }

    @NotNull
    public static Collection<JavaAnnotationArgument> namedAnnotationArguments(@NotNull PsiNameValuePair[] nameValuePairs) {
        if (nameValuePairs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameValuePairs", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "namedAnnotationArguments"));
        }
        List<JavaAnnotationArgument> list2 = JavaElementCollectionFromPsiArrayUtil.convert(nameValuePairs, Factories.NAMED_ANNOTATION_ARGUMENTS);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "namedAnnotationArguments"));
        }
        return list2;
    }

    private static class Factories {
        private static final Factory<PsiClass, JavaClass> CLASSES = new Factory<PsiClass, JavaClass>(){

            @Override
            @NotNull
            public JavaClass create(@NotNull PsiClass psiClass) {
                if (psiClass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$1", "create"));
                }
                JavaClassImpl javaClassImpl = new JavaClassImpl(psiClass);
                if (javaClassImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$1", "create"));
                }
                return javaClassImpl;
            }
        };
        private static final Factory<PsiMethod, JavaMethod> METHODS = new Factory<PsiMethod, JavaMethod>(){

            @Override
            @NotNull
            public JavaMethod create(@NotNull PsiMethod psiMethod) {
                if (psiMethod == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$2", "create"));
                }
                JavaMethodImpl javaMethodImpl = new JavaMethodImpl(psiMethod);
                if (javaMethodImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$2", "create"));
                }
                return javaMethodImpl;
            }
        };
        private static final Factory<PsiMethod, JavaConstructor> CONSTRUCTORS = new Factory<PsiMethod, JavaConstructor>(){

            @Override
            @NotNull
            public JavaConstructor create(@NotNull PsiMethod psiMethod) {
                if (psiMethod == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$3", "create"));
                }
                JavaConstructorImpl javaConstructorImpl = new JavaConstructorImpl(psiMethod);
                if (javaConstructorImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$3", "create"));
                }
                return javaConstructorImpl;
            }
        };
        private static final Factory<PsiField, JavaField> FIELDS = new Factory<PsiField, JavaField>(){

            @Override
            @NotNull
            public JavaField create(@NotNull PsiField psiField) {
                if (psiField == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiField", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$4", "create"));
                }
                JavaFieldImpl javaFieldImpl = new JavaFieldImpl(psiField);
                if (javaFieldImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$4", "create"));
                }
                return javaFieldImpl;
            }
        };
        private static final Factory<PsiParameter, JavaValueParameter> VALUE_PARAMETERS = new Factory<PsiParameter, JavaValueParameter>(){

            @Override
            @NotNull
            public JavaValueParameter create(@NotNull PsiParameter psiParameter) {
                if (psiParameter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiParameter", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$5", "create"));
                }
                JavaValueParameterImpl javaValueParameterImpl = new JavaValueParameterImpl(psiParameter);
                if (javaValueParameterImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$5", "create"));
                }
                return javaValueParameterImpl;
            }
        };
        private static final Factory<PsiTypeParameter, JavaTypeParameter> TYPE_PARAMETERS = new Factory<PsiTypeParameter, JavaTypeParameter>(){

            @Override
            @NotNull
            public JavaTypeParameter create(@NotNull PsiTypeParameter psiTypeParameter) {
                if (psiTypeParameter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiTypeParameter", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$6", "create"));
                }
                JavaTypeParameterImpl javaTypeParameterImpl = new JavaTypeParameterImpl(psiTypeParameter);
                if (javaTypeParameterImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$6", "create"));
                }
                return javaTypeParameterImpl;
            }
        };
        private static final Factory<PsiType, JavaType> TYPES = new Factory<PsiType, JavaType>(){

            @Override
            @NotNull
            public JavaType create(@NotNull PsiType psiType) {
                if (psiType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiType", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$7", "create"));
                }
                JavaTypeImpl<?> javaTypeImpl = JavaTypeImpl.create(psiType);
                if (javaTypeImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$7", "create"));
                }
                return javaTypeImpl;
            }
        };
        private static final Factory<PsiClassType, JavaClassifierType> CLASSIFIER_TYPES = new Factory<PsiClassType, JavaClassifierType>(){

            @Override
            @NotNull
            public JavaClassifierType create(@NotNull PsiClassType psiClassType) {
                if (psiClassType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClassType", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$8", "create"));
                }
                JavaClassifierTypeImpl javaClassifierTypeImpl = new JavaClassifierTypeImpl(psiClassType);
                if (javaClassifierTypeImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$8", "create"));
                }
                return javaClassifierTypeImpl;
            }
        };
        private static final Factory<PsiAnnotation, JavaAnnotation> ANNOTATIONS = new Factory<PsiAnnotation, JavaAnnotation>(){

            @Override
            @NotNull
            public JavaAnnotation create(@NotNull PsiAnnotation psiAnnotation) {
                if (psiAnnotation == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiAnnotation", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$9", "create"));
                }
                JavaAnnotationImpl javaAnnotationImpl = new JavaAnnotationImpl(psiAnnotation);
                if (javaAnnotationImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$9", "create"));
                }
                return javaAnnotationImpl;
            }
        };
        private static final Factory<PsiNameValuePair, JavaAnnotationArgument> NAMED_ANNOTATION_ARGUMENTS = new Factory<PsiNameValuePair, JavaAnnotationArgument>(){

            @Override
            @NotNull
            public JavaAnnotationArgument create(@NotNull PsiNameValuePair psiNameValuePair) {
                if (psiNameValuePair == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiNameValuePair", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$10", "create"));
                }
                String name2 = psiNameValuePair.getName();
                PsiAnnotationMemberValue value2 = psiNameValuePair.getValue();
                assert (value2 != null) : "Annotation argument value cannot be null: " + name2;
                JavaAnnotationArgument javaAnnotationArgument = JavaAnnotationArgumentImpl.Factory.create(value2, name2 == null ? null : Name.identifier(name2));
                if (javaAnnotationArgument == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$10", "create"));
                }
                return javaAnnotationArgument;
            }
        };

        private Factories() {
        }
    }

    private static interface Factory<Psi, Java> {
        @NotNull
        public Java create(@NotNull Psi var1);
    }
}

