/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotatedImpl;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.AbstractClassTypeConstructor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;

public abstract class TypeConstructorImpl
extends AnnotatedImpl
implements TypeConstructor {
    private final List<TypeParameterDescriptor> parameters;
    private final Collection<KotlinType> supertypes;
    private final String debugName;
    private final boolean isFinal;
    private final ClassifierDescriptor classifierDescriptor;

    @NotNull
    public static TypeConstructorImpl createForClass(@NotNull ClassDescriptor classDescriptor, @NotNull Annotations annotations2, boolean isFinal, @NotNull String debugName2, @NotNull List<? extends TypeParameterDescriptor> parameters2, @NotNull Collection<KotlinType> supertypes2) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/types/TypeConstructorImpl", "createForClass"));
        }
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/kotlin/types/TypeConstructorImpl", "createForClass"));
        }
        if (debugName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/kotlin/types/TypeConstructorImpl", "createForClass"));
        }
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/kotlin/types/TypeConstructorImpl", "createForClass"));
        }
        if (supertypes2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertypes", "org/jetbrains/kotlin/types/TypeConstructorImpl", "createForClass"));
        }
        TypeConstructorImpl typeConstructorImpl = new TypeConstructorImpl((ClassifierDescriptor)classDescriptor, annotations2, isFinal, debugName2, (List)parameters2, (Collection)supertypes2){

            @Override
            public int hashCode() {
                return AbstractClassTypeConstructor.hashCode(this);
            }

            @Override
            public boolean equals(Object obj) {
                return AbstractClassTypeConstructor.equals(this, obj);
            }
        };
        if (typeConstructorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/TypeConstructorImpl", "createForClass"));
        }
        return typeConstructorImpl;
    }

    @NotNull
    public static TypeConstructorImpl createForTypeParameter(@NotNull TypeParameterDescriptor typeParameterDescriptor, @NotNull Annotations annotations2, boolean isFinal, @NotNull String debugName2, @NotNull List<? extends TypeParameterDescriptor> parameters2, @NotNull Collection<KotlinType> supertypes2) {
        if (typeParameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameterDescriptor", "org/jetbrains/kotlin/types/TypeConstructorImpl", "createForTypeParameter"));
        }
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/kotlin/types/TypeConstructorImpl", "createForTypeParameter"));
        }
        if (debugName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/kotlin/types/TypeConstructorImpl", "createForTypeParameter"));
        }
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/kotlin/types/TypeConstructorImpl", "createForTypeParameter"));
        }
        if (supertypes2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertypes", "org/jetbrains/kotlin/types/TypeConstructorImpl", "createForTypeParameter"));
        }
        TypeConstructorImpl typeConstructorImpl = new TypeConstructorImpl((ClassifierDescriptor)typeParameterDescriptor, annotations2, isFinal, debugName2, (List)parameters2, (Collection)supertypes2){

            @Override
            public int hashCode() {
                return System.identityHashCode(this);
            }

            @Override
            public boolean equals(Object obj) {
                return this == obj;
            }
        };
        if (typeConstructorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/TypeConstructorImpl", "createForTypeParameter"));
        }
        return typeConstructorImpl;
    }

    private TypeConstructorImpl(@NotNull ClassifierDescriptor classifierDescriptor, @NotNull Annotations annotations2, boolean isFinal, @NotNull String debugName2, @NotNull List<? extends TypeParameterDescriptor> parameters2, @NotNull Collection<KotlinType> supertypes2) {
        if (classifierDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classifierDescriptor", "org/jetbrains/kotlin/types/TypeConstructorImpl", "<init>"));
        }
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/kotlin/types/TypeConstructorImpl", "<init>"));
        }
        if (debugName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/kotlin/types/TypeConstructorImpl", "<init>"));
        }
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/kotlin/types/TypeConstructorImpl", "<init>"));
        }
        if (supertypes2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertypes", "org/jetbrains/kotlin/types/TypeConstructorImpl", "<init>"));
        }
        super(annotations2);
        this.classifierDescriptor = classifierDescriptor;
        this.isFinal = isFinal;
        this.debugName = debugName2;
        this.parameters = Collections.unmodifiableList(new ArrayList<TypeParameterDescriptor>(parameters2));
        this.supertypes = Collections.unmodifiableCollection(supertypes2);
    }

    @Override
    @NotNull
    public List<TypeParameterDescriptor> getParameters() {
        List<TypeParameterDescriptor> list2 = this.parameters;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/TypeConstructorImpl", "getParameters"));
        }
        return list2;
    }

    @Override
    @NotNull
    public Collection<KotlinType> getSupertypes() {
        Collection<KotlinType> collection = this.supertypes;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/TypeConstructorImpl", "getSupertypes"));
        }
        return collection;
    }

    public String toString() {
        return this.debugName;
    }

    @Override
    public boolean isFinal() {
        return this.isFinal;
    }

    @Override
    public boolean isDenotable() {
        return true;
    }

    @Override
    @Nullable
    public ClassifierDescriptor getDeclarationDescriptor() {
        return this.classifierDescriptor;
    }

    @Override
    @NotNull
    public KotlinBuiltIns getBuiltIns() {
        KotlinBuiltIns kotlinBuiltIns = DescriptorUtilsKt.getBuiltIns(this.classifierDescriptor);
        if (kotlinBuiltIns == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/TypeConstructorImpl", "getBuiltIns"));
        }
        return kotlinBuiltIns;
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);
}

