/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.substitutions;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.checker.TypeCheckingProcedure;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a$\u0010\u0000\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u001a\u0018\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u001a$\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f\u001a\u0018\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f\u00a8\u0006\u000f"}, d2={"getCallableSubstitution", "", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "Lorg/jetbrains/kotlin/types/TypeProjection;", "baseCallable", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "derivedCallable", "getCallableSubstitutor", "Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "getTypeSubstitution", "Ljava/util/LinkedHashMap;", "baseType", "Lorg/jetbrains/kotlin/types/KotlinType;", "derivedType", "getTypeSubstitutor", "ide-common"})
public final class SubstitutionUtilsKt {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final LinkedHashMap<TypeConstructor, TypeProjection> getTypeSubstitution(@NotNull KotlinType baseType, @NotNull KotlinType derivedType) {
        Intrinsics.checkParameterIsNotNull((Object)baseType, (String)"baseType");
        Intrinsics.checkParameterIsNotNull((Object)derivedType, (String)"derivedType");
        KotlinType kotlinType = TypeCheckingProcedure.findCorrespondingSupertype(derivedType, baseType);
        if (kotlinType == null) {
            return null;
        }
        KotlinType substitutedType = kotlinType;
        LinkedHashMap<TypeConstructor, TypeProjection> substitution2 = new LinkedHashMap<TypeConstructor, TypeProjection>(substitutedType.getArguments().size());
        Iterable iterable = baseType.getConstructor().getParameters();
        Iterable iterable2 = substitutedType.getArguments();
        Intrinsics.checkExpressionValueIsNotNull((Object)iterable2, (String)"substitutedType.arguments");
        for (Pair pair2 : CollectionsKt.zip((Iterable)iterable, (Iterable)iterable2)) {
            void value$iv;
            void key$iv;
            void $receiver$iv;
            TypeParameterDescriptor param = (TypeParameterDescriptor)pair2.component1();
            TypeProjection arg = (TypeProjection)pair2.component2();
            Map map2 = substitution2;
            Intrinsics.checkExpressionValueIsNotNull((Object)param.getTypeConstructor(), (String)"param.typeConstructor");
            Intrinsics.checkExpressionValueIsNotNull((Object)arg, (String)"arg");
            $receiver$iv.put(key$iv, value$iv);
        }
        return substitution2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Map<TypeConstructor, TypeProjection> getCallableSubstitution(@NotNull CallableDescriptor baseCallable, @NotNull CallableDescriptor derivedCallable) {
        Intrinsics.checkParameterIsNotNull((Object)baseCallable, (String)"baseCallable");
        Intrinsics.checkParameterIsNotNull((Object)derivedCallable, (String)"derivedCallable");
        DeclarationDescriptor declarationDescriptor = baseCallable.getContainingDeclaration();
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            declarationDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor baseClass = classDescriptor;
        DeclarationDescriptor declarationDescriptor2 = derivedCallable.getContainingDeclaration();
        if (!(declarationDescriptor2 instanceof ClassDescriptor)) {
            declarationDescriptor2 = null;
        }
        ClassDescriptor classDescriptor2 = (ClassDescriptor)declarationDescriptor2;
        if (classDescriptor2 == null) {
            return null;
        }
        ClassDescriptor derivedClass = classDescriptor2;
        KotlinType kotlinType = baseClass.getDefaultType();
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"baseClass.defaultType");
        KotlinType kotlinType2 = derivedClass.getDefaultType();
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"derivedClass.defaultType");
        LinkedHashMap<TypeConstructor, TypeProjection> linkedHashMap = SubstitutionUtilsKt.getTypeSubstitution(kotlinType, kotlinType2);
        if (linkedHashMap == null) {
            return null;
        }
        LinkedHashMap<TypeConstructor, TypeProjection> substitution2 = linkedHashMap;
        Iterable iterable = baseCallable.getTypeParameters();
        Iterable iterable2 = derivedCallable.getTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)iterable2, (String)"derivedCallable.typeParameters");
        for (Pair pair2 : CollectionsKt.zip((Iterable)iterable, (Iterable)iterable2)) {
            void value$iv;
            void key$iv;
            void $receiver$iv;
            TypeParameterDescriptor baseParam = (TypeParameterDescriptor)pair2.component1();
            TypeParameterDescriptor derivedParam = (TypeParameterDescriptor)pair2.component2();
            Map map2 = substitution2;
            Intrinsics.checkExpressionValueIsNotNull((Object)baseParam.getTypeConstructor(), (String)"baseParam.typeConstructor");
            TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(derivedParam.getDefaultType());
            $receiver$iv.put(key$iv, value$iv);
        }
        return substitution2;
    }

    @Nullable
    public static final TypeSubstitutor getCallableSubstitutor(@NotNull CallableDescriptor baseCallable, @NotNull CallableDescriptor derivedCallable) {
        TypeSubstitutor typeSubstitutor2;
        Intrinsics.checkParameterIsNotNull((Object)baseCallable, (String)"baseCallable");
        Intrinsics.checkParameterIsNotNull((Object)derivedCallable, (String)"derivedCallable");
        Map<TypeConstructor, TypeProjection> map2 = SubstitutionUtilsKt.getCallableSubstitution(baseCallable, derivedCallable);
        if (map2 != null) {
            Map<TypeConstructor, TypeProjection> $receiver$iv = map2;
            Map<TypeConstructor, TypeProjection> it = $receiver$iv;
            typeSubstitutor2 = TypeSubstitutor.create(it);
        } else {
            typeSubstitutor2 = null;
        }
        return typeSubstitutor2;
    }

    @Nullable
    public static final TypeSubstitutor getTypeSubstitutor(@NotNull KotlinType baseType, @NotNull KotlinType derivedType) {
        TypeSubstitutor typeSubstitutor2;
        Intrinsics.checkParameterIsNotNull((Object)baseType, (String)"baseType");
        Intrinsics.checkParameterIsNotNull((Object)derivedType, (String)"derivedType");
        LinkedHashMap<TypeConstructor, TypeProjection> linkedHashMap = SubstitutionUtilsKt.getTypeSubstitution(baseType, derivedType);
        if (linkedHashMap != null) {
            LinkedHashMap<TypeConstructor, TypeProjection> $receiver$iv = linkedHashMap;
            LinkedHashMap<TypeConstructor, TypeProjection> it = $receiver$iv;
            typeSubstitutor2 = TypeSubstitutor.create((Map<TypeConstructor, TypeProjection>)it);
        } else {
            typeSubstitutor2 = null;
        }
        return typeSubstitutor2;
    }
}

