/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.Location;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.junit.AbstractTestMethodConfigurationProducer;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitConfigurationType;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.JavaRunConfigurationProducerBase;
import com.intellij.execution.junit.PatternConfigurationProducer;
import com.intellij.execution.junit.TestObject;
import com.intellij.execution.junit2.PsiMemberParameterizedLocation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;

public abstract class JUnitConfigurationProducer
extends JavaRunConfigurationProducerBase<JUnitConfiguration>
implements Cloneable {
    public JUnitConfigurationProducer() {
        super((ConfigurationType)JUnitConfigurationType.getInstance());
    }

    protected JUnitConfigurationProducer(ConfigurationType configurationType) {
        super(configurationType);
    }

    public boolean isPreferredConfiguration(ConfigurationFromContext self, ConfigurationFromContext other) {
        return !other.isProducedBy(AbstractTestMethodConfigurationProducer.class);
    }

    public boolean isConfigurationFromContext(JUnitConfiguration unitConfiguration, ConfigurationContext context) {
        String vmParameters;
        String paramSetName;
        if (((PatternConfigurationProducer)RunConfigurationProducer.getInstance(PatternConfigurationProducer.class)).isMultipleElementsSelected(context)) {
            return false;
        }
        RunConfiguration predefinedConfiguration = context.getOriginalConfiguration((ConfigurationType)JUnitConfigurationType.getInstance());
        Location contextLocation = context.getLocation();
        String string = paramSetName = contextLocation instanceof PsiMemberParameterizedLocation ? ((PsiMemberParameterizedLocation)contextLocation).getParamSetName() : null;
        assert (contextLocation != null);
        Location location = JavaExecutionUtil.stepIntoSingleClass((Location)contextLocation);
        if (location == null) {
            return false;
        }
        PsiElement element = location.getPsiElement();
        PsiClass testClass = JUnitUtil.getTestClass((PsiElement)element);
        PsiMethod testMethod = JUnitUtil.getTestMethod((PsiElement)element, (boolean)false);
        Object testPackage = element instanceof PsiPackage ? (PsiPackage)element : (element instanceof PsiDirectory ? JavaDirectoryService.getInstance().getPackage((PsiDirectory)element) : null);
        PsiDirectory testDir = element instanceof PsiDirectory ? (PsiDirectory)element : null;
        RunnerAndConfigurationSettings template = RunManager.getInstance((Project)location.getProject()).getConfigurationTemplate(this.getConfigurationFactory());
        Module predefinedModule = ((JavaRunConfigurationModule)((JUnitConfiguration)template.getConfiguration()).getConfigurationModule()).getModule();
        String string2 = vmParameters = predefinedConfiguration instanceof JUnitConfiguration ? ((JUnitConfiguration)predefinedConfiguration).getVMParameters() : null;
        if (vmParameters != null && !Comparing.strEqual((String)vmParameters, (String)unitConfiguration.getVMParameters())) {
            return false;
        }
        if (paramSetName != null && !Comparing.strEqual((String)paramSetName, (String)unitConfiguration.getProgramParameters())) {
            return false;
        }
        TestObject testobject = unitConfiguration.getTestObject();
        if (testobject != null && testobject.isConfiguredByElement(unitConfiguration, testClass, testMethod, (PsiPackage)testPackage, testDir)) {
            Module configurationModule = ((JavaRunConfigurationModule)unitConfiguration.getConfigurationModule()).getModule();
            if (Comparing.equal((Object)location.getModule(), (Object)configurationModule)) {
                return true;
            }
            if (Comparing.equal((Object)predefinedModule, (Object)configurationModule)) {
                return true;
            }
        }
        return false;
    }

    protected Condition<PsiClass> getConditionToSearchForInheritors() {
        return new Condition<PsiClass>(){

            public boolean value(PsiClass psiClass) {
                if (psiClass.hasModifierProperty("abstract")) {
                    return true;
                }
                if (JUnitUtil.isTestCaseInheritor((PsiClass)psiClass)) {
                    PsiMethod[] constructors;
                    for (PsiMethod method : constructors = psiClass.getConstructors()) {
                        if (method.getParameterList().getParametersCount() != 0) continue;
                        return false;
                    }
                    return constructors.length != 0;
                }
                return false;
            }
        };
    }
}

