/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.maven.model.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildTargetLoader;
import org.jetbrains.jps.builders.ModuleBasedBuildTargetType;
import org.jetbrains.jps.maven.model.JpsMavenExtensionService;
import org.jetbrains.jps.maven.model.impl.MavenResourcesTarget;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.module.JpsModule;

public class MavenResourcesTargetType
extends ModuleBasedBuildTargetType<MavenResourcesTarget> {
    public static final MavenResourcesTargetType PRODUCTION = new MavenResourcesTargetType("maven-resources-production", false);
    public static final MavenResourcesTargetType TEST = new MavenResourcesTargetType("maven-resources-test", true);
    private final boolean myIsTests;

    private MavenResourcesTargetType(String typeId, boolean isTests) {
        super(typeId);
        this.myIsTests = isTests;
    }

    public boolean isTests() {
        return this.myIsTests;
    }

    @NotNull
    public List<MavenResourcesTarget> computeAllTargets(@NotNull JpsModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/jps/maven/model/impl/MavenResourcesTargetType", "computeAllTargets"));
        }
        ArrayList<MavenResourcesTarget> targets = new ArrayList<MavenResourcesTarget>();
        JpsMavenExtensionService service = JpsMavenExtensionService.getInstance();
        for (JpsModule module : model.getProject().getModules()) {
            if (service.getExtension(module) == null) continue;
            targets.add(new MavenResourcesTarget(this, module));
        }
        ArrayList<MavenResourcesTarget> arrayList = targets;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/maven/model/impl/MavenResourcesTargetType", "computeAllTargets"));
        }
        return arrayList;
    }

    @NotNull
    public BuildTargetLoader<MavenResourcesTarget> createLoader(@NotNull JpsModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/jps/maven/model/impl/MavenResourcesTargetType", "createLoader"));
        }
        final HashMap<String, JpsModule> modules = new HashMap<String, JpsModule>();
        for (JpsModule module : model.getProject().getModules()) {
            modules.put(module.getName(), module);
        }
        BuildTargetLoader<MavenResourcesTarget> buildTargetLoader = new BuildTargetLoader<MavenResourcesTarget>(){

            @Nullable
            public MavenResourcesTarget createTarget(@NotNull String targetId) {
                if (targetId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetId", "org/jetbrains/jps/maven/model/impl/MavenResourcesTargetType$1", "createTarget"));
                }
                JpsModule module = (JpsModule)modules.get(targetId);
                return module != null ? new MavenResourcesTarget(MavenResourcesTargetType.this, module) : null;
            }
        };
        if (buildTargetLoader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/maven/model/impl/MavenResourcesTargetType", "createLoader"));
        }
        return buildTargetLoader;
    }
}

