/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xsltDebugger;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.DefaultProgramRunner;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import org.intellij.lang.xpath.xslt.impl.XsltChecker;
import org.intellij.lang.xpath.xslt.run.XsltCommandLineState;
import org.intellij.lang.xpath.xslt.run.XsltRunConfiguration;
import org.intellij.plugins.xsltDebugger.XsltDebuggerExtension;
import org.intellij.plugins.xsltDebugger.impl.XsltDebugProcess;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class XsltDebuggerRunner
extends DefaultProgramRunner {
    static final ThreadLocal<Boolean> ACTIVE = new ThreadLocal();
    @NonNls
    private static final String ID = "XsltDebuggerRunner";

    @NotNull
    public String getRunnerId() {
        if (ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/xsltDebugger/XsltDebuggerRunner", "getRunnerId"));
        }
        return ID;
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "org/intellij/plugins/xsltDebugger/XsltDebuggerRunner", "canRun"));
        }
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "org/intellij/plugins/xsltDebugger/XsltDebuggerRunner", "canRun"));
        }
        return executorId.equals("Debug") && profile instanceof XsltRunConfiguration;
    }

    protected RunContentDescriptor doExecute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/intellij/plugins/xsltDebugger/XsltDebuggerRunner", "doExecute"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "org/intellij/plugins/xsltDebugger/XsltDebuggerRunner", "doExecute"));
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        return this.createContentDescriptor(state, env);
    }

    protected RunContentDescriptor createContentDescriptor(final RunProfileState runProfileState, final ExecutionEnvironment environment) throws ExecutionException {
        XDebugSession debugSession = XDebuggerManager.getInstance((Project)environment.getProject()).startSession(environment, new XDebugProcessStarter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session) throws ExecutionException {
                if (session == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "org/intellij/plugins/xsltDebugger/XsltDebuggerRunner$1", "start"));
                }
                ACTIVE.set(Boolean.TRUE);
                XsltCommandLineState c = (XsltCommandLineState)runProfileState;
                ExecutionResult result = runProfileState.execute(environment.getExecutor(), (ProgramRunner)XsltDebuggerRunner.this);
                XsltDebugProcess xsltDebugProcess = new XsltDebugProcess(session, result, (XsltChecker.LanguageLevel)c.getExtensionData().getUserData(XsltDebuggerExtension.VERSION));
                XsltDebugProcess xsltDebugProcess2 = xsltDebugProcess;
                if (xsltDebugProcess2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/xsltDebugger/XsltDebuggerRunner$1", "start"));
                }
                return xsltDebugProcess2;
                finally {
                    ACTIVE.remove();
                }
            }
        });
        return debugSession.getRunContentDescriptor();
    }
}

