/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.roots.DependencyScope;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenModuleImporter;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.utils.ManifestBuilder;

public abstract class ManifestImporter {
    public static final ExtensionPointName<ManifestImporter> EXTENSION_POINT_NAME = ExtensionPointName.create((String)"org.jetbrains.idea.maven.manifestImporter");

    @NotNull
    public static ManifestImporter getManifestImporter(@NotNull String packaging) {
        if (packaging == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packaging", "org/jetbrains/idea/maven/importing/ManifestImporter", "getManifestImporter"));
        }
        for (ManifestImporter importer : (ManifestImporter[])EXTENSION_POINT_NAME.getExtensions()) {
            if (!importer.isApplicable(packaging)) continue;
            ManifestImporter manifestImporter = importer;
            if (manifestImporter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/importing/ManifestImporter", "getManifestImporter"));
            }
            return manifestImporter;
        }
        DefaultManifestImporter defaultManifestImporter = new DefaultManifestImporter();
        if (defaultManifestImporter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/importing/ManifestImporter", "getManifestImporter"));
        }
        return defaultManifestImporter;
    }

    @NotNull
    public String getClasspath(@NotNull MavenProject mavenProject, @Nullable Element manifestConfiguration) {
        if (mavenProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenProject", "org/jetbrains/idea/maven/importing/ManifestImporter", "getClasspath"));
        }
        StringBuilder classpath = new StringBuilder();
        String classpathPrefix = ManifestBuilder.getClasspathPrefix(manifestConfiguration);
        for (MavenArtifact mavenArtifact : mavenProject.getDependencies()) {
            DependencyScope scope = MavenModuleImporter.selectScope(mavenArtifact.getScope());
            if (!scope.isForProductionCompile() && !scope.isForProductionRuntime()) continue;
            if (classpath.length() > 0) {
                classpath.append(" ");
            }
            classpath.append(classpathPrefix);
            String artifactFileName = mavenArtifact.getArtifactId() + "-" + mavenArtifact.getVersion() + "." + mavenArtifact.getExtension();
            classpath.append(this.doGetClasspathItem(mavenProject, mavenArtifact, artifactFileName));
        }
        String string = classpath.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/importing/ManifestImporter", "getClasspath"));
        }
        return string;
    }

    protected abstract boolean isApplicable(String var1);

    protected abstract String doGetClasspathItem(@NotNull MavenProject var1, @NotNull MavenArtifact var2, @NotNull String var3);

    private static class DefaultManifestImporter
    extends ManifestImporter {
        private DefaultManifestImporter() {
        }

        @Override
        protected boolean isApplicable(String packaging) {
            return true;
        }

        @Override
        protected String doGetClasspathItem(@NotNull MavenProject mavenProject, @NotNull MavenArtifact mavenArtifact, @NotNull String artifactFileName) {
            if (mavenProject == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenProject", "org/jetbrains/idea/maven/importing/ManifestImporter$DefaultManifestImporter", "doGetClasspathItem"));
            }
            if (mavenArtifact == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenArtifact", "org/jetbrains/idea/maven/importing/ManifestImporter$DefaultManifestImporter", "doGetClasspathItem"));
            }
            if (artifactFileName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactFileName", "org/jetbrains/idea/maven/importing/ManifestImporter$DefaultManifestImporter", "doGetClasspathItem"));
            }
            return artifactFileName;
        }
    }
}

