/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions.dynamic.elements;

import com.intellij.openapi.project.Project;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.annotator.intentions.QuickfixUtil;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.DynamicManager;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.ParamInfo;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.elements.DItemElement;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.elements.DMethodElement;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.elements.DNamedElement;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.elements.DPropertyElement;

public class DClassElement
implements DNamedElement {
    public String myName;
    public Set<DPropertyElement> myProperties = new HashSet<DPropertyElement>();
    public Set<DMethodElement> myMethods = new HashSet<DMethodElement>();

    public DClassElement() {
    }

    public DClassElement(Project project, String name) {
        this.myName = name;
        DynamicManager.getInstance(project).getRootElement().mergeAddClass(this);
    }

    public void addMethod(DMethodElement methodElement) {
        this.myMethods.add(methodElement);
    }

    void addMethods(Collection<DMethodElement> methods) {
        this.myMethods.addAll(methods);
    }

    public void addProperty(DPropertyElement propertyElement) {
        this.myProperties.add(propertyElement);
    }

    protected void addProperties(Collection<DPropertyElement> properties) {
        for (DPropertyElement property : properties) {
            this.addProperty(property);
        }
    }

    @Nullable
    public DPropertyElement getPropertyByName(String propertyName) {
        for (DPropertyElement property : this.myProperties) {
            if (!propertyName.equals(property.getName())) continue;
            return property;
        }
        return null;
    }

    public Collection<DPropertyElement> getProperties() {
        return this.myProperties;
    }

    public Set<DMethodElement> getMethods() {
        return this.myMethods;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public void setName(String name) {
        this.myName = name;
    }

    public void removeProperty(DPropertyElement name) {
        this.myProperties.remove(name);
    }

    public boolean removeMethod(DMethodElement methodElement) {
        return this.myMethods.remove(methodElement);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DClassElement that = (DClassElement)o;
        return !(this.myName != null ? !this.myName.equals(that.myName) : that.myName != null);
    }

    public int hashCode() {
        int result = this.myName != null ? this.myName.hashCode() : 0;
        result = 31 * result + (this.myProperties != null ? this.myProperties.hashCode() : 0);
        result = 31 * result + (this.myMethods != null ? this.myMethods.hashCode() : 0);
        return result;
    }

    @Nullable
    public DMethodElement getMethod(String methodName, String[] parametersTypes) {
        for (DMethodElement method : this.myMethods) {
            List<ParamInfo> myPairList = method.getPairs();
            if (!method.getName().equals(methodName) || !Arrays.equals(QuickfixUtil.getArgumentsTypes(myPairList), parametersTypes)) continue;
            return method;
        }
        return null;
    }

    public boolean containsElement(DItemElement itemElement) {
        return this.myProperties.contains(itemElement) || itemElement instanceof DMethodElement && this.myMethods.contains(itemElement);
    }
}

