/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap.hprof;

import com.android.tools.perflib.heap.hprof.HprofConstant;
import com.android.tools.perflib.heap.hprof.HprofDumpRecord;
import com.android.tools.perflib.heap.hprof.HprofInstanceField;
import com.android.tools.perflib.heap.hprof.HprofOutputStream;
import com.android.tools.perflib.heap.hprof.HprofStaticField;
import java.io.IOException;

public class HprofClassDump
implements HprofDumpRecord {
    public static final byte SUBTAG = 32;
    public final long classObjectId;
    public final int stackTraceSerialNumber;
    public final long superClassObjectId;
    public final long classLoaderObjectId;
    public final long signersObjectId;
    public final long protectionDomainObjectId;
    public final long reserved1;
    public final long reserved2;
    public final int instanceSize;
    public final HprofConstant[] constantPool;
    public final HprofStaticField[] staticFields;
    public final HprofInstanceField[] instanceFields;

    public HprofClassDump(long classObjectId, int stackTraceSerialNumber, long superClassObjectId, long classLoaderObjectId, long signersObjectId, long protectionDomainObjectId, long reserved1, long reserved2, int instanceSize, HprofConstant[] constantPool, HprofStaticField[] staticFields, HprofInstanceField[] instanceFields) {
        this.classObjectId = classObjectId;
        this.stackTraceSerialNumber = stackTraceSerialNumber;
        this.superClassObjectId = superClassObjectId;
        this.classLoaderObjectId = classLoaderObjectId;
        this.signersObjectId = signersObjectId;
        this.protectionDomainObjectId = protectionDomainObjectId;
        this.reserved1 = reserved1;
        this.reserved2 = reserved2;
        this.instanceSize = instanceSize;
        this.constantPool = constantPool;
        this.staticFields = staticFields;
        this.instanceFields = instanceFields;
    }

    @Override
    public void write(HprofOutputStream hprof) throws IOException {
        hprof.writeU1((byte)32);
        hprof.writeId(this.classObjectId);
        hprof.writeU4(this.stackTraceSerialNumber);
        hprof.writeId(this.superClassObjectId);
        hprof.writeId(this.classLoaderObjectId);
        hprof.writeId(this.signersObjectId);
        hprof.writeId(this.protectionDomainObjectId);
        hprof.writeId(this.reserved1);
        hprof.writeId(this.reserved2);
        hprof.writeU4(this.instanceSize);
        hprof.writeU2((short)this.constantPool.length);
        for (HprofConstant hprofConstant : this.constantPool) {
            hprofConstant.write(hprof);
        }
        hprof.writeU2((short)this.staticFields.length);
        for (HprofStaticField hprofStaticField : this.staticFields) {
            hprofStaticField.write(hprof);
        }
        hprof.writeU2((short)this.instanceFields.length);
        for (HprofInstanceField hprofInstanceField : this.instanceFields) {
            hprofInstanceField.write(hprof);
        }
    }

    @Override
    public int getLength(int idSize) {
        int length = 1 + 7 * idSize + 8 + 6;
        for (HprofConstant hprofConstant : this.constantPool) {
            length += hprofConstant.getLength(idSize);
        }
        for (HprofStaticField hprofStaticField : this.staticFields) {
            length += hprofStaticField.getLength(idSize);
        }
        for (HprofInstanceField hprofInstanceField : this.instanceFields) {
            length += hprofInstanceField.getLength(idSize);
        }
        return length;
    }
}

