/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.jira.rest;

import com.intellij.tasks.Comment;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskState;
import com.intellij.tasks.TaskType;
import com.intellij.tasks.jira.JiraTask;
import com.intellij.tasks.jira.rest.model.JiraComment;
import com.intellij.tasks.jira.rest.model.JiraIssue;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JiraRestTask
extends JiraTask {
    private final JiraIssue myJiraIssue;

    public JiraRestTask(JiraIssue jiraIssue, TaskRepository repository) {
        super(repository);
        this.myJiraIssue = jiraIssue;
    }

    @Override
    @NotNull
    public String getId() {
        String string = this.myJiraIssue.getKey();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/jira/rest/JiraRestTask", "getId"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getSummary() {
        String string = this.myJiraIssue.getSummary();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/jira/rest/JiraRestTask", "getSummary"));
        }
        return string;
    }

    @Override
    public String getDescription() {
        return this.myJiraIssue.getDescription();
    }

    @Override
    @NotNull
    public Comment[] getComments() {
        Comment[] commentArray = (Comment[])ContainerUtil.map2Array(this.myJiraIssue.getComments(), Comment.class, (Function)new Function<JiraComment, Comment>(){

            public Comment fun(final JiraComment comment) {
                return new Comment(){

                    public String getText() {
                        return comment.getBody();
                    }

                    public String getAuthor() {
                        return comment.getAuthor().getDisplayName();
                    }

                    public Date getDate() {
                        return comment.getCreated();
                    }

                    public String toString() {
                        return comment.getAuthor().getDisplayName();
                    }
                };
            }
        });
        if (commentArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/jira/rest/JiraRestTask", "getComments"));
        }
        return commentArray;
    }

    @Override
    @Nullable
    protected String getIconUrl() {
        return this.myJiraIssue.getIssueType().getIconUrl();
    }

    @Override
    @NotNull
    public TaskType getType() {
        TaskType taskType = this.getTypeByName(this.myJiraIssue.getIssueType().getName());
        if (taskType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/jira/rest/JiraRestTask", "getType"));
        }
        return taskType;
    }

    @Override
    public TaskState getState() {
        return this.getStateById(Integer.parseInt(this.myJiraIssue.getStatus().getId()));
    }

    @Override
    @Nullable
    public Date getUpdated() {
        return this.myJiraIssue.getUpdated();
    }

    @Override
    public Date getCreated() {
        return this.myJiraIssue.getCreated();
    }

    public JiraIssue getJiraIssue() {
        return this.myJiraIssue;
    }
}

