/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.actions;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.lw.LwComponent;
import com.intellij.uiDesigner.lw.LwContainer;
import com.intellij.uiDesigner.lw.LwRootContainer;
import com.intellij.uiDesigner.wizard.DataBindingWizard;
import com.intellij.uiDesigner.wizard.Generator;
import com.intellij.uiDesigner.wizard.WizardData;
import javax.swing.Icon;

public final class DataBindingWizardAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uiDesigner.actions.DataBindingWizardAction");

    public void actionPerformed(AnActionEvent e) {
        GuiEditor editor = FormEditingUtil.getActiveEditor(e.getDataContext());
        assert (editor != null);
        Project project = editor.getProject();
        VirtualFile formFile = editor.getFile();
        try {
            WizardData wizardData = new WizardData(project, formFile);
            Module module = ModuleUtilCore.findModuleForFile((VirtualFile)formFile, (Project)wizardData.myProject);
            LOG.assertTrue(module != null);
            LwRootContainer[] rootContainer = new LwRootContainer[1];
            Generator.exposeForm(wizardData.myProject, formFile, rootContainer);
            String classToBind = rootContainer[0].getClassToBind();
            if (classToBind == null) {
                Messages.showInfoMessage((Project)project, (String)UIDesignerBundle.message("info.form.not.bound", new Object[0]), (String)UIDesignerBundle.message("title.data.binding.wizard", new Object[0]));
                return;
            }
            PsiClass boundClass = FormEditingUtil.findClassToBind(module, classToBind);
            if (boundClass == null) {
                Messages.showErrorDialog((Project)project, (String)UIDesignerBundle.message("error.bound.to.not.found.class", classToBind), (String)UIDesignerBundle.message("title.data.binding.wizard", new Object[0]));
                return;
            }
            Generator.prepareWizardData(wizardData, boundClass);
            if (!DataBindingWizardAction.hasBinding((LwComponent)rootContainer[0])) {
                Messages.showInfoMessage((Project)project, (String)UIDesignerBundle.message("info.no.bound.components", new Object[0]), (String)UIDesignerBundle.message("title.data.binding.wizard", new Object[0]));
                return;
            }
            if (!wizardData.myBindToNewBean) {
                String[] variants = new String[]{UIDesignerBundle.message("action.alter.data.binding", new Object[0]), UIDesignerBundle.message("action.bind.to.another.bean", new Object[0]), CommonBundle.getCancelButtonText()};
                int result = Messages.showYesNoCancelDialog((Project)project, (String)UIDesignerBundle.message("info.data.binding.regenerate", wizardData.myBeanClass.getQualifiedName()), (String)UIDesignerBundle.message("title.data.binding", new Object[0]), (String)variants[0], (String)variants[1], (String)variants[2], (Icon)Messages.getQuestionIcon());
                if (result != 0) {
                    if (result == 1) {
                        wizardData.myBindToNewBean = true;
                    } else {
                        return;
                    }
                }
            }
            DataBindingWizard wizard = new DataBindingWizard(project, wizardData);
            wizard.show();
        }
        catch (Generator.MyException exc) {
            Messages.showErrorDialog((Project)project, (String)exc.getMessage(), (String)CommonBundle.getErrorTitle());
        }
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setVisible(FormEditingUtil.getActiveEditor(e.getDataContext()) != null);
    }

    private static boolean hasBinding(LwComponent component) {
        if (component.getBinding() != null) {
            return true;
        }
        if (component instanceof LwContainer) {
            LwContainer container = (LwContainer)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                if (!DataBindingWizardAction.hasBinding((LwComponent)container.getComponent(i))) continue;
                return true;
            }
        }
        return false;
    }
}

