/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.properties;

import com.intellij.uiDesigner.propertyInspector.IntrospectedProperty;
import com.intellij.uiDesigner.propertyInspector.PropertyEditor;
import com.intellij.uiDesigner.propertyInspector.PropertyRenderer;
import com.intellij.uiDesigner.propertyInspector.editors.PrimitiveTypeEditor;
import com.intellij.uiDesigner.propertyInspector.renderers.LabelPropertyRenderer;
import java.lang.reflect.Method;
import org.jetbrains.annotations.NotNull;

public class IntroPrimitiveTypeProperty<T>
extends IntrospectedProperty<T> {
    private LabelPropertyRenderer<T> myRenderer;
    private PropertyEditor<T> myEditor;
    private final Class<T> myClass;

    public IntroPrimitiveTypeProperty(String name, Method readMethod, Method writeMethod, boolean storeAsClient, Class<T> aClass) {
        super(name, readMethod, writeMethod, storeAsClient);
        this.myClass = aClass;
    }

    @Override
    @NotNull
    public PropertyRenderer<T> getRenderer() {
        if (this.myRenderer == null) {
            this.myRenderer = new LabelPropertyRenderer();
        }
        LabelPropertyRenderer<T> labelPropertyRenderer = this.myRenderer;
        if (labelPropertyRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/propertyInspector/properties/IntroPrimitiveTypeProperty", "getRenderer"));
        }
        return labelPropertyRenderer;
    }

    @Override
    public PropertyEditor<T> getEditor() {
        if (this.myEditor == null) {
            this.myEditor = this.createEditor();
        }
        return this.myEditor;
    }

    protected PropertyEditor<T> createEditor() {
        return new PrimitiveTypeEditor<T>(this.myClass);
    }
}

