/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.util;

import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.tooling.annotation.TargetVersions;

public class VersionMatcher {
    private static final String RANGE_TOKEN = " <=> ";
    @NotNull
    private final GradleVersion myGradleVersion;

    public VersionMatcher(@NotNull GradleVersion version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "org/jetbrains/plugins/gradle/tooling/util/VersionMatcher", "<init>"));
        }
        this.myGradleVersion = version;
    }

    public boolean isVersionMatch(@Nullable TargetVersions targetVersions) {
        if (targetVersions == null || targetVersions.value() == null || targetVersions.value().isEmpty()) {
            return true;
        }
        GradleVersion current = VersionMatcher.adjust(this.myGradleVersion, targetVersions.checkBaseVersions());
        if (targetVersions.value().endsWith("+")) {
            String minVersion = targetVersions.value().substring(0, targetVersions.value().length() - 1);
            return VersionMatcher.compare(current, minVersion, targetVersions.checkBaseVersions()) >= 0;
        }
        int rangeIndex = targetVersions.value().indexOf(RANGE_TOKEN);
        if (rangeIndex != -1) {
            String minVersion = targetVersions.value().substring(0, rangeIndex);
            String maxVersion = targetVersions.value().substring(rangeIndex + RANGE_TOKEN.length());
            return VersionMatcher.compare(current, minVersion, targetVersions.checkBaseVersions()) >= 0 && VersionMatcher.compare(current, maxVersion, targetVersions.checkBaseVersions()) <= 0;
        }
        return VersionMatcher.compare(current, targetVersions.value(), targetVersions.checkBaseVersions()) == 0;
    }

    private static int compare(@NotNull GradleVersion gradleVersion, @NotNull String otherGradleVersion, boolean checkBaseVersions) {
        if (gradleVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleVersion", "org/jetbrains/plugins/gradle/tooling/util/VersionMatcher", "compare"));
        }
        if (otherGradleVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "otherGradleVersion", "org/jetbrains/plugins/gradle/tooling/util/VersionMatcher", "compare"));
        }
        return gradleVersion.compareTo(VersionMatcher.adjust(GradleVersion.version((String)otherGradleVersion), checkBaseVersions));
    }

    private static GradleVersion adjust(@NotNull GradleVersion version, boolean checkBaseVersions) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "org/jetbrains/plugins/gradle/tooling/util/VersionMatcher", "adjust"));
        }
        return checkBaseVersions ? version.getBaseVersion() : version;
    }
}

