/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.service.impl;

import com.intellij.util.ConcurrencyUtil;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.service.SharedThreadPool;

public class SharedThreadPoolImpl
extends SharedThreadPool {
    private final ExecutorService myService = Executors.newCachedThreadPool(ConcurrencyUtil.newNamedThreadFactory((String)"JPS thread pool"));

    public void execute(@NotNull Runnable command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/jps/service/impl/SharedThreadPoolImpl", "execute"));
        }
        this.executeOnPooledThread(command);
    }

    @NotNull
    public Future<?> executeOnPooledThread(final @NotNull Runnable action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "org/jetbrains/jps/service/impl/SharedThreadPoolImpl", "executeOnPooledThread"));
        }
        Future<?> future = this.myService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    action.run();
                }
                finally {
                    Thread.interrupted();
                }
            }
        });
        if (future == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/service/impl/SharedThreadPoolImpl", "executeOnPooledThread"));
        }
        return future;
    }
}

