/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xsltDebugger.rt.engine.local.xalan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.apache.xalan.templates.ElemLiteralResult;
import org.apache.xalan.templates.ElemParam;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.ElemVariable;
import org.apache.xalan.trace.TracerEvent;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.dtm.ref.DTMNodeProxy;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.PrefixResolverDefault;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.intellij.plugins.xsltDebugger.rt.engine.Debugger;
import org.intellij.plugins.xsltDebugger.rt.engine.Value;
import org.intellij.plugins.xsltDebugger.rt.engine.local.AbstractFrame;
import org.intellij.plugins.xsltDebugger.rt.engine.local.VariableComparator;
import org.intellij.plugins.xsltDebugger.rt.engine.local.VariableImpl;
import org.intellij.plugins.xsltDebugger.rt.engine.local.xalan.XObjectValue;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XalanStyleFrame
extends AbstractFrame<Debugger.StyleFrame>
implements Debugger.StyleFrame {
    private final boolean myWithSourceFrame;
    private final TransformerImpl myTransformer;
    private final ElemTemplateElement myCurrentElement;
    private final XPathContext myContext;
    private final int myCurrentNode;
    private final int myLineNumber;
    private final String myURI;
    private final String myInstr;

    public XalanStyleFrame(TracerEvent ev, Debugger.StyleFrame currentFrame, boolean withSourceFrame) {
        super(currentFrame);
        this.myWithSourceFrame = withSourceFrame;
        this.myInstr = XalanStyleFrame.getInstruction(ev.m_styleNode);
        this.myLineNumber = ev.m_styleNode.getLineNumber();
        this.myURI = ev.m_styleNode.getSystemId() != null ? ev.m_styleNode.getSystemId() : (currentFrame != null && currentFrame.getURI() != null ? currentFrame.getURI() : ev.m_processor.getStylesheet().getSystemId());
        this.myTransformer = ev.m_processor;
        this.myCurrentElement = this.myTransformer.getCurrentElement();
        this.myContext = ev.m_processor.getXPathContext();
        this.myCurrentNode = this.myContext.getCurrentNode();
    }

    private void addVariable(ElemVariable variable, boolean global, Collection<Debugger.Variable> variables) {
        Debugger.Variable.Kind kind;
        Debugger.Variable.Kind kind2 = kind = variable instanceof ElemParam ? Debugger.Variable.Kind.PARAMETER : Debugger.Variable.Kind.VARIABLE;
        assert (global == variable.getIsTopLevel()) : global + " vs. " + variable.getIsTopLevel() + " (" + variable.getName() + ")";
        String name = variable.getName().getLocalName();
        try {
            XObjectValue value = kind == Debugger.Variable.Kind.PARAMETER ? this.eval("$" + variable.getName().toString()) : new XObjectValue(variable.getValue(this.myTransformer, this.myCurrentNode));
            variables.add(new VariableImpl(name, value, global, kind, variable.getSystemId(), variable.getLineNumber()));
        }
        catch (TransformerException e) {
            XalanStyleFrame.debug(e);
        }
        catch (Debugger.EvaluationException e) {
            XalanStyleFrame.debug(e);
        }
    }

    public boolean isWithSourceFrame() {
        return this.myWithSourceFrame;
    }

    public String getInstruction() {
        return this.myInstr;
    }

    public List<Debugger.Variable> getVariables() {
        assert (this.isValid());
        return this.collectVariables();
    }

    private List<Debugger.Variable> collectVariables() {
        HashSet<Debugger.Variable> variables = new HashSet<Debugger.Variable>();
        for (ElemTemplateElement p = this.myCurrentElement; p != null; p = p.getParentElem()) {
            ElemTemplateElement s = p;
            while ((s = s.getPreviousSiblingElem()) != null) {
                ElemVariable variable;
                if (!(s instanceof ElemVariable) || (variable = (ElemVariable)s).getIsTopLevel()) continue;
                this.addVariable(variable, false, variables);
            }
        }
        Vector globals = this.myTransformer.getStylesheet().getVariablesAndParamsComposed();
        for (ElemVariable variable : globals) {
            this.addVariable(variable, true, variables);
        }
        ArrayList<Debugger.Variable> result = new ArrayList<Debugger.Variable>(variables);
        Collections.sort(result, VariableComparator.INSTANCE);
        return result;
    }

    public String getURI() {
        return this.myURI;
    }

    public int getLineNumber() {
        return this.myLineNumber;
    }

    public Value eval(String expr) throws Debugger.EvaluationException {
        assert (this.isValid());
        try {
            DTMIterator context = this.myTransformer.getContextNodeList();
            DTM dtm = context.getDTM(this.myCurrentNode);
            int ctx = dtm.getDocumentRoot(this.myCurrentNode) == this.myCurrentNode ? dtm.getFirstChild(this.myCurrentNode) : this.myCurrentNode;
            DTMNodeProxy c = new DTMNodeProxy(dtm, ctx);
            PrefixResolverDefault prefixResolver = new PrefixResolverDefault((Node)c){

                public String getNamespaceForPrefix(String prefix, Node context) {
                    if (context instanceof DTMNodeProxy) {
                        DTMNodeProxy proxy = (DTMNodeProxy)context;
                        DTM dtm = proxy.getDTM();
                        int p = proxy.getDTMNodeNumber();
                        while (p != -1) {
                            int nsNode = dtm.getFirstNamespaceNode(p, true);
                            while (nsNode != -1) {
                                String s = dtm.getLocalName(nsNode);
                                if (s.equals(prefix)) {
                                    return dtm.getNodeValue(nsNode);
                                }
                                nsNode = dtm.getNextNamespaceNode(p, nsNode, true);
                            }
                            p = dtm.getParent(p);
                        }
                    }
                    return super.getNamespaceForPrefix(prefix, context);
                }
            };
            XPath xPath = new XPath(expr, (SourceLocator)this.myCurrentElement, (PrefixResolver)prefixResolver, 0, this.myTransformer.getErrorListener());
            return new XObjectValue(xPath.execute(this.myContext, this.myCurrentNode, (PrefixResolver)this.myCurrentElement));
        }
        catch (Exception e) {
            XalanStyleFrame.debug(e);
            String message = e.getMessage();
            throw new Debugger.EvaluationException(message != null ? message : e.getClass().getSimpleName());
        }
    }

    static String getInstruction(ElemTemplateElement node) {
        String name = node.getNodeName();
        if (node instanceof ElemLiteralResult) {
            return name;
        }
        if (name != null && name.indexOf(58) == -1) {
            return "xsl:" + name;
        }
        return name;
    }
}

