/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge.svg12;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.event.EventListenerList;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.svg12.BindingListener;
import org.apache.batik.bridge.svg12.ContentManager;
import org.apache.batik.bridge.svg12.ContentSelectionChangedListener;
import org.apache.batik.dom.AbstractAttrNS;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.AbstractNode;
import org.apache.batik.dom.events.NodeEventTarget;
import org.apache.batik.dom.svg12.BindableElement;
import org.apache.batik.dom.svg12.XBLEventSupport;
import org.apache.batik.dom.svg12.XBLOMContentElement;
import org.apache.batik.dom.svg12.XBLOMDefinitionElement;
import org.apache.batik.dom.svg12.XBLOMImportElement;
import org.apache.batik.dom.svg12.XBLOMShadowTreeElement;
import org.apache.batik.dom.svg12.XBLOMTemplateElement;
import org.apache.batik.dom.xbl.NodeXBL;
import org.apache.batik.dom.xbl.ShadowTreeEvent;
import org.apache.batik.dom.xbl.XBLManager;
import org.apache.batik.dom.xbl.XBLManagerData;
import org.apache.batik.dom.xbl.XBLShadowTreeElement;
import org.apache.batik.util.DoublyIndexedTable;
import org.apache.batik.util.XBLConstants;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;

public class DefaultXBLManager
implements XBLManager,
XBLConstants {
    protected boolean isProcessing;
    protected Document document;
    protected BridgeContext ctx;
    protected DoublyIndexedTable definitionLists = new DoublyIndexedTable();
    protected DoublyIndexedTable definitions = new DoublyIndexedTable();
    protected Map contentManagers = new HashMap();
    protected Map imports = new HashMap();
    protected DocInsertedListener docInsertedListener = new DocInsertedListener();
    protected DocRemovedListener docRemovedListener = new DocRemovedListener();
    protected DocSubtreeListener docSubtreeListener = new DocSubtreeListener();
    protected ImportAttrListener importAttrListener = new ImportAttrListener();
    protected RefAttrListener refAttrListener = new RefAttrListener();
    protected EventListenerList bindingListenerList = new EventListenerList();
    protected EventListenerList contentSelectionChangedListenerList = new EventListenerList();

    public DefaultXBLManager(Document document, BridgeContext bridgeContext) {
        this.document = document;
        this.ctx = bridgeContext;
        ImportRecord importRecord = new ImportRecord(null, null);
        this.imports.put(null, importRecord);
    }

    @Override
    public void startProcessing() {
        int n;
        if (this.isProcessing) {
            return;
        }
        NodeList nodeList = this.document.getElementsByTagNameNS("http://www.w3.org/2004/xbl", "definition");
        XBLOMDefinitionElement[] xBLOMDefinitionElementArray = new XBLOMDefinitionElement[nodeList.getLength()];
        for (int i = 0; i < xBLOMDefinitionElementArray.length; ++i) {
            xBLOMDefinitionElementArray[i] = (XBLOMDefinitionElement)nodeList.item(i);
        }
        nodeList = this.document.getElementsByTagNameNS("http://www.w3.org/2004/xbl", "import");
        Element[] elementArray = new Element[nodeList.getLength()];
        for (int i = 0; i < elementArray.length; ++i) {
            elementArray[i] = (Element)nodeList.item(i);
        }
        AbstractDocument abstractDocument = (AbstractDocument)this.document;
        XBLEventSupport xBLEventSupport = (XBLEventSupport)abstractDocument.initializeEventSupport();
        xBLEventSupport.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", this.docRemovedListener, true);
        xBLEventSupport.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", this.docInsertedListener, true);
        xBLEventSupport.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMSubtreeModified", this.docSubtreeListener, true);
        for (n = 0; n < xBLOMDefinitionElementArray.length; ++n) {
            if (xBLOMDefinitionElementArray[n].getAttributeNS(null, "ref").length() != 0) {
                this.addDefinitionRef(xBLOMDefinitionElementArray[n]);
                continue;
            }
            String string = xBLOMDefinitionElementArray[n].getElementNamespaceURI();
            String string2 = xBLOMDefinitionElementArray[n].getElementLocalName();
            this.addDefinition(string, string2, xBLOMDefinitionElementArray[n], null);
        }
        for (n = 0; n < elementArray.length; ++n) {
            this.addImport(elementArray[n]);
        }
        this.isProcessing = true;
        this.bind(this.document.getDocumentElement());
    }

    @Override
    public void stopProcessing() {
        if (!this.isProcessing) {
            return;
        }
        this.isProcessing = false;
        AbstractDocument abstractDocument = (AbstractDocument)this.document;
        XBLEventSupport xBLEventSupport = (XBLEventSupport)abstractDocument.initializeEventSupport();
        xBLEventSupport.removeImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", this.docRemovedListener, true);
        xBLEventSupport.removeImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", this.docInsertedListener, true);
        xBLEventSupport.removeImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMSubtreeModified", this.docSubtreeListener, true);
        int n = this.imports.values().size();
        ImportRecord[] importRecordArray = new ImportRecord[n];
        this.imports.values().toArray(importRecordArray);
        for (int i = 0; i < importRecordArray.length; ++i) {
            ImportRecord importRecord = importRecordArray[i];
            if (importRecord.importElement.getLocalName().equals("definition")) {
                this.removeDefinitionRef(importRecord.importElement);
                continue;
            }
            this.removeImport(importRecord.importElement);
        }
        Object[] objectArray = this.definitions.getValuesArray();
        this.definitions.clear();
        for (int i = 0; i < objectArray.length; ++i) {
            DefinitionRecord definitionRecord = (DefinitionRecord)objectArray[i];
            TreeSet treeSet = (TreeSet)this.definitionLists.get(definitionRecord.namespaceURI, definitionRecord.localName);
            if (treeSet == null) continue;
            while (!treeSet.isEmpty()) {
                definitionRecord = (DefinitionRecord)treeSet.first();
                treeSet.remove(definitionRecord);
                this.removeDefinition(definitionRecord);
            }
            this.definitionLists.put(definitionRecord.namespaceURI, definitionRecord.localName, null);
        }
        this.definitionLists = new DoublyIndexedTable();
        this.contentManagers.clear();
    }

    @Override
    public boolean isProcessing() {
        return this.isProcessing;
    }

    protected void addDefinitionRef(Element element) {
        String string = element.getAttributeNS(null, "ref");
        Element element2 = this.ctx.getReferencedElement(element, string);
        if (!"http://www.w3.org/2004/xbl".equals(element2.getNamespaceURI()) || !"definition".equals(element2.getLocalName())) {
            throw new BridgeException(this.ctx, element, "uri.badTarget", new Object[]{string});
        }
        ImportRecord importRecord = new ImportRecord(element, element2);
        this.imports.put(element, importRecord);
        NodeEventTarget nodeEventTarget = (NodeEventTarget)((Object)element);
        nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", this.refAttrListener, false, null);
        XBLOMDefinitionElement xBLOMDefinitionElement = (XBLOMDefinitionElement)element;
        String string2 = xBLOMDefinitionElement.getElementNamespaceURI();
        String string3 = xBLOMDefinitionElement.getElementLocalName();
        this.addDefinition(string2, string3, (XBLOMDefinitionElement)element2, element);
    }

    protected void removeDefinitionRef(Element element) {
        ImportRecord importRecord = (ImportRecord)this.imports.get(element);
        NodeEventTarget nodeEventTarget = (NodeEventTarget)((Object)element);
        nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", this.refAttrListener, false);
        DefinitionRecord definitionRecord = (DefinitionRecord)this.definitions.get(importRecord.node, element);
        this.removeDefinition(definitionRecord);
        this.imports.remove(element);
    }

    protected void addImport(Element element) {
        String string = element.getAttributeNS(null, "bindings");
        Node node = this.ctx.getReferencedNode(element, string);
        if (!(node.getNodeType() != 1 || "http://www.w3.org/2004/xbl".equals(node.getNamespaceURI()) && "xbl".equals(node.getLocalName()))) {
            throw new BridgeException(this.ctx, element, "uri.badTarget", new Object[]{node});
        }
        ImportRecord importRecord = new ImportRecord(element, node);
        this.imports.put(element, importRecord);
        NodeEventTarget nodeEventTarget = (NodeEventTarget)((Object)element);
        nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", this.importAttrListener, false, null);
        nodeEventTarget = (NodeEventTarget)((Object)node);
        nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", importRecord.importInsertedListener, false, null);
        nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", importRecord.importRemovedListener, false, null);
        nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMSubtreeModified", importRecord.importSubtreeListener, false, null);
        this.addImportedDefinitions(element, node);
    }

    protected void addImportedDefinitions(Element element, Node node) {
        if (node instanceof XBLOMDefinitionElement) {
            XBLOMDefinitionElement xBLOMDefinitionElement = (XBLOMDefinitionElement)node;
            String string = xBLOMDefinitionElement.getElementNamespaceURI();
            String string2 = xBLOMDefinitionElement.getElementLocalName();
            this.addDefinition(string, string2, xBLOMDefinitionElement, element);
        } else {
            for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
                this.addImportedDefinitions(element, node);
            }
        }
    }

    protected void removeImport(Element element) {
        ImportRecord importRecord = (ImportRecord)this.imports.get(element);
        NodeEventTarget nodeEventTarget = (NodeEventTarget)((Object)importRecord.node);
        nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", importRecord.importInsertedListener, false);
        nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", importRecord.importRemovedListener, false);
        nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMSubtreeModified", importRecord.importSubtreeListener, false);
        nodeEventTarget = (NodeEventTarget)((Object)element);
        nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", this.importAttrListener, false);
        Object[] objectArray = this.definitions.getValuesArray();
        for (int i = 0; i < objectArray.length; ++i) {
            DefinitionRecord definitionRecord = (DefinitionRecord)objectArray[i];
            if (definitionRecord.importElement != element) continue;
            this.removeDefinition(definitionRecord);
        }
        this.imports.remove(element);
    }

    protected void addDefinition(String string, String string2, XBLOMDefinitionElement xBLOMDefinitionElement, Element element) {
        Node node;
        ImportRecord importRecord = (ImportRecord)this.imports.get(element);
        DefinitionRecord definitionRecord = null;
        TreeSet<DefinitionRecord> treeSet = (TreeSet<DefinitionRecord>)this.definitionLists.get(string, string2);
        if (treeSet == null) {
            treeSet = new TreeSet<DefinitionRecord>();
            this.definitionLists.put(string, string2, treeSet);
        } else if (treeSet.size() > 0) {
            definitionRecord = (DefinitionRecord)treeSet.first();
        }
        XBLOMTemplateElement xBLOMTemplateElement = null;
        for (node = xBLOMDefinitionElement.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof XBLOMTemplateElement)) continue;
            xBLOMTemplateElement = (XBLOMTemplateElement)node;
            break;
        }
        DefinitionRecord definitionRecord2 = new DefinitionRecord(string, string2, xBLOMDefinitionElement, xBLOMTemplateElement, element);
        treeSet.add(definitionRecord2);
        this.definitions.put(xBLOMDefinitionElement, element, definitionRecord2);
        this.addDefinitionElementListeners(xBLOMDefinitionElement, importRecord);
        if (treeSet.first() != definitionRecord2) {
            return;
        }
        if (definitionRecord != null) {
            node = definitionRecord.definition;
            XBLOMTemplateElement xBLOMTemplateElement2 = definitionRecord.template;
            if (xBLOMTemplateElement2 != null) {
                this.removeTemplateElementListeners(xBLOMTemplateElement2, importRecord);
            }
            this.removeDefinitionElementListeners((XBLOMDefinitionElement)node, importRecord);
        }
        if (xBLOMTemplateElement != null) {
            this.addTemplateElementListeners(xBLOMTemplateElement, importRecord);
        }
        if (this.isProcessing) {
            this.rebind(string, string2, this.document.getDocumentElement());
        }
    }

    protected void addDefinitionElementListeners(XBLOMDefinitionElement xBLOMDefinitionElement, ImportRecord importRecord) {
        XBLEventSupport xBLEventSupport = (XBLEventSupport)xBLOMDefinitionElement.initializeEventSupport();
        xBLEventSupport.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", importRecord.defAttrListener, false);
        xBLEventSupport.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", importRecord.defNodeInsertedListener, false);
        xBLEventSupport.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", importRecord.defNodeRemovedListener, false);
    }

    protected void addTemplateElementListeners(XBLOMTemplateElement xBLOMTemplateElement, ImportRecord importRecord) {
        XBLEventSupport xBLEventSupport = (XBLEventSupport)xBLOMTemplateElement.initializeEventSupport();
        xBLEventSupport.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", importRecord.templateMutationListener, false);
        xBLEventSupport.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", importRecord.templateMutationListener, false);
        xBLEventSupport.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", importRecord.templateMutationListener, false);
        xBLEventSupport.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMCharacterDataModified", importRecord.templateMutationListener, false);
    }

    protected void removeDefinition(DefinitionRecord definitionRecord) {
        TreeSet treeSet = (TreeSet)this.definitionLists.get(definitionRecord.namespaceURI, definitionRecord.localName);
        if (treeSet == null) {
            return;
        }
        Element element = definitionRecord.importElement;
        ImportRecord importRecord = (ImportRecord)this.imports.get(element);
        DefinitionRecord definitionRecord2 = (DefinitionRecord)treeSet.first();
        treeSet.remove(definitionRecord);
        this.definitions.remove(definitionRecord.definition, element);
        this.removeDefinitionElementListeners(definitionRecord.definition, importRecord);
        if (definitionRecord != definitionRecord2) {
            return;
        }
        if (definitionRecord.template != null) {
            this.removeTemplateElementListeners(definitionRecord.template, importRecord);
        }
        this.rebind(definitionRecord.namespaceURI, definitionRecord.localName, this.document.getDocumentElement());
    }

    protected void removeDefinitionElementListeners(XBLOMDefinitionElement xBLOMDefinitionElement, ImportRecord importRecord) {
        XBLEventSupport xBLEventSupport = (XBLEventSupport)xBLOMDefinitionElement.initializeEventSupport();
        xBLEventSupport.removeImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", importRecord.defAttrListener, false);
        xBLEventSupport.removeImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", importRecord.defNodeInsertedListener, false);
        xBLEventSupport.removeImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", importRecord.defNodeRemovedListener, false);
    }

    protected void removeTemplateElementListeners(XBLOMTemplateElement xBLOMTemplateElement, ImportRecord importRecord) {
        XBLEventSupport xBLEventSupport = (XBLEventSupport)xBLOMTemplateElement.initializeEventSupport();
        xBLEventSupport.removeImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", importRecord.templateMutationListener, false);
        xBLEventSupport.removeImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", importRecord.templateMutationListener, false);
        xBLEventSupport.removeImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", importRecord.templateMutationListener, false);
        xBLEventSupport.removeImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMCharacterDataModified", importRecord.templateMutationListener, false);
    }

    protected DefinitionRecord getActiveDefinition(String string, String string2) {
        TreeSet treeSet = (TreeSet)this.definitionLists.get(string, string2);
        if (treeSet == null || treeSet.size() == 0) {
            return null;
        }
        return (DefinitionRecord)treeSet.first();
    }

    protected void unbind(Element element) {
        if (element instanceof BindableElement) {
            this.setActiveDefinition((BindableElement)element, null);
        } else {
            NodeList nodeList = this.getXblScopedChildNodes(element);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                this.unbind((Element)node);
            }
        }
    }

    protected void bind(Element element) {
        Object object;
        AbstractDocument abstractDocument = (AbstractDocument)element.getOwnerDocument();
        if (abstractDocument != this.document && (object = abstractDocument.getXBLManager()) instanceof DefaultXBLManager) {
            ((DefaultXBLManager)object).bind(element);
            return;
        }
        if (element instanceof BindableElement) {
            object = this.getActiveDefinition(element.getNamespaceURI(), element.getLocalName());
            this.setActiveDefinition((BindableElement)element, (DefinitionRecord)object);
        } else {
            object = this.getXblScopedChildNodes(element);
            for (int i = 0; i < object.getLength(); ++i) {
                Node node = object.item(i);
                if (node.getNodeType() != 1) continue;
                this.bind((Element)node);
            }
        }
    }

    protected void rebind(String string, String string2, Element element) {
        Object object;
        AbstractDocument abstractDocument = (AbstractDocument)element.getOwnerDocument();
        if (abstractDocument != this.document && (object = abstractDocument.getXBLManager()) instanceof DefaultXBLManager) {
            ((DefaultXBLManager)object).rebind(string, string2, element);
            return;
        }
        if (element instanceof BindableElement && string.equals(element.getNamespaceURI()) && string2.equals(element.getLocalName())) {
            object = this.getActiveDefinition(element.getNamespaceURI(), element.getLocalName());
            this.setActiveDefinition((BindableElement)element, (DefinitionRecord)object);
        } else {
            object = this.getXblScopedChildNodes(element);
            for (int i = 0; i < object.getLength(); ++i) {
                Node node = object.item(i);
                if (node.getNodeType() != 1) continue;
                this.rebind(string, string2, (Element)node);
            }
        }
    }

    protected void setActiveDefinition(BindableElement bindableElement, DefinitionRecord definitionRecord) {
        XBLRecord xBLRecord = this.getRecord(bindableElement);
        XBLOMDefinitionElement xBLOMDefinitionElement = xBLRecord.definitionElement = definitionRecord == null ? null : definitionRecord.definition;
        if (definitionRecord != null && definitionRecord.definition != null && definitionRecord.template != null) {
            this.setXblShadowTree(bindableElement, this.cloneTemplate(definitionRecord.template));
        } else {
            this.setXblShadowTree(bindableElement, null);
        }
    }

    protected void setXblShadowTree(BindableElement bindableElement, XBLOMShadowTreeElement xBLOMShadowTreeElement) {
        Object object;
        Object object2;
        Object object3;
        XBLOMShadowTreeElement xBLOMShadowTreeElement2 = (XBLOMShadowTreeElement)this.getXblShadowTree(bindableElement);
        if (xBLOMShadowTreeElement2 != null) {
            this.fireShadowTreeEvent(bindableElement, "unbinding", xBLOMShadowTreeElement2);
            object3 = this.getContentManager(xBLOMShadowTreeElement2);
            if (object3 != null) {
                ((ContentManager)object3).dispose();
            }
            bindableElement.setShadowTree(null);
            object2 = this.getRecord(xBLOMShadowTreeElement2);
            ((XBLRecord)object2).boundElement = null;
            xBLOMShadowTreeElement2.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMSubtreeModified", this.docSubtreeListener, false);
        }
        if (xBLOMShadowTreeElement != null) {
            xBLOMShadowTreeElement.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMSubtreeModified", this.docSubtreeListener, false, null);
            this.fireShadowTreeEvent(bindableElement, "prebind", xBLOMShadowTreeElement);
            bindableElement.setShadowTree(xBLOMShadowTreeElement);
            object3 = this.getRecord(xBLOMShadowTreeElement);
            ((XBLRecord)object3).boundElement = bindableElement;
            object2 = (AbstractDocument)bindableElement.getOwnerDocument();
            object = ((AbstractDocument)object2).getXBLManager();
            ContentManager contentManager = new ContentManager(xBLOMShadowTreeElement, (XBLManager)object);
            this.setContentManager(xBLOMShadowTreeElement, contentManager);
        }
        this.invalidateChildNodes(bindableElement);
        if (xBLOMShadowTreeElement != null) {
            object3 = this.getXblScopedChildNodes(bindableElement);
            for (int i = 0; i < object3.getLength(); ++i) {
                object = object3.item(i);
                if (object.getNodeType() != 1) continue;
                this.bind((Element)object);
            }
            this.dispatchBindingChangedEvent(bindableElement, xBLOMShadowTreeElement);
            this.fireShadowTreeEvent(bindableElement, "bound", xBLOMShadowTreeElement);
        } else {
            this.dispatchBindingChangedEvent(bindableElement, xBLOMShadowTreeElement);
        }
    }

    protected void fireShadowTreeEvent(BindableElement bindableElement, String string, XBLShadowTreeElement xBLShadowTreeElement) {
        DocumentEvent documentEvent = (DocumentEvent)((Object)bindableElement.getOwnerDocument());
        ShadowTreeEvent shadowTreeEvent = (ShadowTreeEvent)documentEvent.createEvent("ShadowTreeEvent");
        shadowTreeEvent.initShadowTreeEventNS("http://www.w3.org/2004/xbl", string, true, false, xBLShadowTreeElement);
        bindableElement.dispatchEvent(shadowTreeEvent);
    }

    protected XBLOMShadowTreeElement cloneTemplate(XBLOMTemplateElement xBLOMTemplateElement) {
        XBLOMShadowTreeElement xBLOMShadowTreeElement = (XBLOMShadowTreeElement)xBLOMTemplateElement.getOwnerDocument().createElementNS("http://www.w3.org/2004/xbl", "shadowTree");
        NamedNodeMap namedNodeMap = xBLOMTemplateElement.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            if (attr instanceof AbstractAttrNS) {
                xBLOMShadowTreeElement.setAttributeNodeNS(attr);
                continue;
            }
            xBLOMShadowTreeElement.setAttributeNode(attr);
        }
        for (Node node = xBLOMTemplateElement.getFirstChild(); node != null; node = node.getNextSibling()) {
            xBLOMShadowTreeElement.appendChild(node.cloneNode(true));
        }
        return xBLOMShadowTreeElement;
    }

    @Override
    public Node getXblParentNode(Node node) {
        Node node2;
        XBLOMContentElement xBLOMContentElement = this.getXblContentElement(node);
        Node node3 = node2 = xBLOMContentElement == null ? node.getParentNode() : xBLOMContentElement.getParentNode();
        if (node2 instanceof XBLOMContentElement) {
            node2 = node2.getParentNode();
        }
        if (node2 instanceof XBLOMShadowTreeElement) {
            node2 = this.getXblBoundElement(node2);
        }
        return node2;
    }

    @Override
    public NodeList getXblChildNodes(Node node) {
        XBLRecord xBLRecord = this.getRecord(node);
        if (xBLRecord.childNodes == null) {
            xBLRecord.childNodes = new XblChildNodes(xBLRecord);
        }
        return xBLRecord.childNodes;
    }

    @Override
    public NodeList getXblScopedChildNodes(Node node) {
        XBLRecord xBLRecord = this.getRecord(node);
        if (xBLRecord.scopedChildNodes == null) {
            xBLRecord.scopedChildNodes = new XblScopedChildNodes(xBLRecord);
        }
        return xBLRecord.scopedChildNodes;
    }

    @Override
    public Node getXblFirstChild(Node node) {
        NodeList nodeList = this.getXblChildNodes(node);
        return nodeList.item(0);
    }

    @Override
    public Node getXblLastChild(Node node) {
        NodeList nodeList = this.getXblChildNodes(node);
        return nodeList.item(nodeList.getLength() - 1);
    }

    @Override
    public Node getXblPreviousSibling(Node node) {
        Node node2 = this.getXblParentNode(node);
        if (node2 == null || this.getRecord((Node)node2).childNodes == null) {
            return node.getPreviousSibling();
        }
        XBLRecord xBLRecord = this.getRecord(node);
        if (!xBLRecord.linksValid) {
            this.updateLinks(node);
        }
        return xBLRecord.previousSibling;
    }

    @Override
    public Node getXblNextSibling(Node node) {
        Node node2 = this.getXblParentNode(node);
        if (node2 == null || this.getRecord((Node)node2).childNodes == null) {
            return node.getNextSibling();
        }
        XBLRecord xBLRecord = this.getRecord(node);
        if (!xBLRecord.linksValid) {
            this.updateLinks(node);
        }
        return xBLRecord.nextSibling;
    }

    @Override
    public Element getXblFirstElementChild(Node node) {
        node = this.getXblFirstChild(node);
        while (node != null && node.getNodeType() != 1) {
            node = this.getXblNextSibling(node);
        }
        return (Element)node;
    }

    @Override
    public Element getXblLastElementChild(Node node) {
        node = this.getXblLastChild(node);
        while (node != null && node.getNodeType() != 1) {
            node = this.getXblPreviousSibling(node);
        }
        return (Element)node;
    }

    @Override
    public Element getXblPreviousElementSibling(Node node) {
        while ((node = this.getXblPreviousSibling(node)) != null && node.getNodeType() != 1) {
        }
        return (Element)node;
    }

    @Override
    public Element getXblNextElementSibling(Node node) {
        while ((node = this.getXblNextSibling(node)) != null && node.getNodeType() != 1) {
        }
        return (Element)node;
    }

    @Override
    public Element getXblBoundElement(Node node) {
        while (node != null && !(node instanceof XBLShadowTreeElement)) {
            XBLOMContentElement xBLOMContentElement = this.getXblContentElement(node);
            if (xBLOMContentElement != null) {
                node = xBLOMContentElement;
            }
            node = node.getParentNode();
        }
        if (node == null) {
            return null;
        }
        return this.getRecord((Node)node).boundElement;
    }

    @Override
    public Element getXblShadowTree(Node node) {
        if (node instanceof BindableElement) {
            BindableElement bindableElement = (BindableElement)node;
            return bindableElement.getShadowTree();
        }
        return null;
    }

    @Override
    public NodeList getXblDefinitions(Node node) {
        final String string = node.getNamespaceURI();
        final String string2 = node.getLocalName();
        return new NodeList(){

            @Override
            public Node item(int n) {
                TreeSet treeSet = (TreeSet)DefaultXBLManager.this.definitionLists.get(string, string2);
                if (treeSet != null && treeSet.size() != 0 && n == 0) {
                    DefinitionRecord definitionRecord = (DefinitionRecord)treeSet.first();
                    return definitionRecord.definition;
                }
                return null;
            }

            @Override
            public int getLength() {
                TreeSet treeSet = (TreeSet)DefaultXBLManager.this.definitionLists.get(string, string2);
                return treeSet != null && treeSet.size() != 0 ? 1 : 0;
            }
        };
    }

    protected XBLRecord getRecord(Node node) {
        XBLManagerData xBLManagerData = (XBLManagerData)((Object)node);
        XBLRecord xBLRecord = (XBLRecord)xBLManagerData.getManagerData();
        if (xBLRecord == null) {
            xBLRecord = new XBLRecord();
            xBLRecord.node = node;
            xBLManagerData.setManagerData(xBLRecord);
        }
        return xBLRecord;
    }

    protected void updateLinks(Node node) {
        NodeList nodeList;
        XBLRecord xBLRecord = this.getRecord(node);
        xBLRecord.previousSibling = null;
        xBLRecord.nextSibling = null;
        xBLRecord.linksValid = true;
        Node node2 = this.getXblParentNode(node);
        if (node2 != null && (nodeList = this.getXblChildNodes(node2)) instanceof XblChildNodes) {
            ((XblChildNodes)nodeList).update();
        }
    }

    public XBLOMContentElement getXblContentElement(Node node) {
        return this.getRecord((Node)node).contentElement;
    }

    public static int computeBubbleLimit(Node node, Node node2) {
        ArrayList<Node> arrayList = new ArrayList<Node>(10);
        ArrayList<Node> arrayList2 = new ArrayList<Node>(10);
        while (node != null) {
            arrayList.add(node);
            node = ((NodeXBL)((Object)node)).getXblParentNode();
        }
        while (node2 != null) {
            arrayList2.add(node2);
            node2 = ((NodeXBL)((Object)node2)).getXblParentNode();
        }
        int n = arrayList.size();
        int n2 = arrayList2.size();
        for (int i = 0; i < n && i < n2; ++i) {
            Node node3;
            Node node4 = (Node)arrayList.get(n - i - 1);
            if (node4 == (node3 = (Node)arrayList2.get(n2 - i - 1))) continue;
            Element element = ((NodeXBL)((Object)node4)).getXblBoundElement();
            while (i > 0 && element != arrayList.get(n - i - 1)) {
                --i;
            }
            return n - i - 1;
        }
        return 1;
    }

    public ContentManager getContentManager(Node node) {
        Element element;
        Element element2 = this.getXblBoundElement(node);
        if (element2 != null && (element = this.getXblShadowTree(element2)) != null) {
            ContentManager contentManager;
            Document document = element2.getOwnerDocument();
            if (document != this.document) {
                DefaultXBLManager defaultXBLManager = (DefaultXBLManager)((AbstractDocument)document).getXBLManager();
                contentManager = (ContentManager)defaultXBLManager.contentManagers.get(element);
            } else {
                contentManager = (ContentManager)this.contentManagers.get(element);
            }
            return contentManager;
        }
        return null;
    }

    void setContentManager(Element element, ContentManager contentManager) {
        if (contentManager == null) {
            this.contentManagers.remove(element);
        } else {
            this.contentManagers.put(element, contentManager);
        }
    }

    public void invalidateChildNodes(Node node) {
        XBLRecord xBLRecord = this.getRecord(node);
        if (xBLRecord.childNodes != null) {
            xBLRecord.childNodes.invalidate();
        }
        if (xBLRecord.scopedChildNodes != null) {
            xBLRecord.scopedChildNodes.invalidate();
        }
    }

    public void addContentSelectionChangedListener(ContentSelectionChangedListener contentSelectionChangedListener) {
        this.contentSelectionChangedListenerList.add(ContentSelectionChangedListener.class, contentSelectionChangedListener);
    }

    public void removeContentSelectionChangedListener(ContentSelectionChangedListener contentSelectionChangedListener) {
        this.contentSelectionChangedListenerList.remove(ContentSelectionChangedListener.class, contentSelectionChangedListener);
    }

    protected Object[] getContentSelectionChangedListeners() {
        return this.contentSelectionChangedListenerList.getListenerList();
    }

    void shadowTreeSelectedContentChanged(Set set, Set set2) {
        for (Node node : set) {
            if (node.getNodeType() != 1) continue;
            this.unbind((Element)node);
        }
        for (Node node : set2) {
            if (node.getNodeType() != 1) continue;
            this.bind((Element)node);
        }
    }

    public void addBindingListener(BindingListener bindingListener) {
        this.bindingListenerList.add(BindingListener.class, bindingListener);
    }

    public void removeBindingListener(BindingListener bindingListener) {
        this.bindingListenerList.remove(BindingListener.class, bindingListener);
    }

    protected void dispatchBindingChangedEvent(Element element, Element element2) {
        Object[] objectArray = this.bindingListenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            BindingListener bindingListener = (BindingListener)objectArray[i + 1];
            bindingListener.bindingChanged(element, element2);
        }
    }

    protected boolean isActiveDefinition(XBLOMDefinitionElement xBLOMDefinitionElement, Element element) {
        DefinitionRecord definitionRecord = (DefinitionRecord)this.definitions.get(xBLOMDefinitionElement, element);
        if (definitionRecord == null) {
            return false;
        }
        return definitionRecord == this.getActiveDefinition(definitionRecord.namespaceURI, definitionRecord.localName);
    }

    protected class XblScopedChildNodes
    extends XblChildNodes {
        public XblScopedChildNodes(XBLRecord xBLRecord) {
            super(xBLRecord);
        }

        @Override
        protected void update() {
            Node node;
            this.size = 0;
            Element element = DefaultXBLManager.this.getXblShadowTree(this.record.node);
            Node node2 = node = element == null ? this.record.node.getFirstChild() : element.getFirstChild();
            while (node != null) {
                this.collectXblScopedChildNodes(node);
                node = node.getNextSibling();
            }
        }

        protected void collectXblScopedChildNodes(Node node) {
            boolean bl = false;
            if (node.getNodeType() == 1) {
                ContentManager contentManager;
                if (!node.getNamespaceURI().equals("http://www.w3.org/2004/xbl")) {
                    bl = true;
                } else if (node instanceof XBLOMContentElement && (contentManager = DefaultXBLManager.this.getContentManager(node)) != null) {
                    NodeList nodeList = contentManager.getSelectedContent((XBLOMContentElement)node);
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        this.collectXblScopedChildNodes(nodeList.item(i));
                    }
                }
            } else {
                bl = true;
            }
            if (bl) {
                this.nodes.add(node);
                ++this.size;
            }
        }
    }

    protected class XblChildNodes
    implements NodeList {
        protected XBLRecord record;
        protected List nodes;
        protected int size;

        public XblChildNodes(XBLRecord xBLRecord) {
            this.record = xBLRecord;
            this.nodes = new ArrayList();
            this.size = -1;
        }

        protected void update() {
            Node node;
            this.size = 0;
            Element element = DefaultXBLManager.this.getXblShadowTree(this.record.node);
            Node node2 = null;
            Node node3 = node = element == null ? this.record.node.getFirstChild() : element.getFirstChild();
            while (node != null) {
                node2 = this.collectXblChildNodes(node, node2);
                node = node.getNextSibling();
            }
            if (node2 != null) {
                XBLRecord xBLRecord = DefaultXBLManager.this.getRecord(node2);
                xBLRecord.nextSibling = null;
                xBLRecord.linksValid = true;
            }
        }

        protected Node collectXblChildNodes(Node node, Node node2) {
            Object object;
            boolean bl = false;
            if (node.getNodeType() == 1) {
                if (!"http://www.w3.org/2004/xbl".equals(node.getNamespaceURI())) {
                    bl = true;
                } else if (node instanceof XBLOMContentElement && (object = DefaultXBLManager.this.getContentManager(node)) != null) {
                    NodeList nodeList = ((ContentManager)object).getSelectedContent((XBLOMContentElement)node);
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        node2 = this.collectXblChildNodes(nodeList.item(i), node2);
                    }
                }
            } else {
                bl = true;
            }
            if (bl) {
                this.nodes.add(node);
                ++this.size;
                if (node2 != null) {
                    object = DefaultXBLManager.this.getRecord(node2);
                    ((XBLRecord)object).nextSibling = node;
                    ((XBLRecord)object).linksValid = true;
                }
                object = DefaultXBLManager.this.getRecord(node);
                ((XBLRecord)object).previousSibling = node2;
                ((XBLRecord)object).linksValid = true;
                node2 = node;
            }
            return node2;
        }

        public void invalidate() {
            for (int i = 0; i < this.size; ++i) {
                XBLRecord xBLRecord = DefaultXBLManager.this.getRecord((Node)this.nodes.get(i));
                xBLRecord.previousSibling = null;
                xBLRecord.nextSibling = null;
                xBLRecord.linksValid = false;
            }
            this.nodes.clear();
            this.size = -1;
        }

        public Node getFirstNode() {
            if (this.size == -1) {
                this.update();
            }
            return this.size == 0 ? null : (Node)this.nodes.get(0);
        }

        public Node getLastNode() {
            if (this.size == -1) {
                this.update();
            }
            return this.size == 0 ? null : (Node)this.nodes.get(this.nodes.size() - 1);
        }

        @Override
        public Node item(int n) {
            if (this.size == -1) {
                this.update();
            }
            if (n < 0 || n >= this.size) {
                return null;
            }
            return (Node)this.nodes.get(n);
        }

        @Override
        public int getLength() {
            if (this.size == -1) {
                this.update();
            }
            return this.size;
        }
    }

    protected class XBLRecord {
        public Node node;
        public XblChildNodes childNodes;
        public XblScopedChildNodes scopedChildNodes;
        public XBLOMContentElement contentElement;
        public XBLOMDefinitionElement definitionElement;
        public BindableElement boundElement;
        public boolean linksValid;
        public Node nextSibling;
        public Node previousSibling;

        protected XBLRecord() {
        }
    }

    protected class RefAttrListener
    implements EventListener {
        protected RefAttrListener() {
        }

        @Override
        public void handleEvent(Event event) {
            EventTarget eventTarget = event.getTarget();
            if (eventTarget != event.getCurrentTarget()) {
                return;
            }
            MutationEvent mutationEvent = (MutationEvent)event;
            if (mutationEvent.getAttrName().equals("ref")) {
                Element element = (Element)((Object)eventTarget);
                DefaultXBLManager.this.removeDefinitionRef(element);
                if (mutationEvent.getNewValue().length() == 0) {
                    XBLOMDefinitionElement xBLOMDefinitionElement = (XBLOMDefinitionElement)element;
                    String string = xBLOMDefinitionElement.getElementNamespaceURI();
                    String string2 = xBLOMDefinitionElement.getElementLocalName();
                    DefaultXBLManager.this.addDefinition(string, string2, (XBLOMDefinitionElement)element, null);
                } else {
                    DefaultXBLManager.this.addDefinitionRef(element);
                }
            }
        }
    }

    protected class ImportAttrListener
    implements EventListener {
        protected ImportAttrListener() {
        }

        @Override
        public void handleEvent(Event event) {
            EventTarget eventTarget = event.getTarget();
            if (eventTarget != event.getCurrentTarget()) {
                return;
            }
            MutationEvent mutationEvent = (MutationEvent)event;
            if (mutationEvent.getAttrName().equals("bindings")) {
                Element element = (Element)((Object)eventTarget);
                DefaultXBLManager.this.removeImport(element);
                DefaultXBLManager.this.addImport(element);
            }
        }
    }

    protected class DefNodeRemovedListener
    implements EventListener {
        protected Element importElement;

        public DefNodeRemovedListener(Element element) {
            this.importElement = element;
        }

        @Override
        public void handleEvent(Event event) {
            MutationEvent mutationEvent = (MutationEvent)event;
            Node node = mutationEvent.getRelatedNode();
            if (!(node instanceof XBLOMDefinitionElement)) {
                return;
            }
            EventTarget eventTarget = event.getTarget();
            if (!(eventTarget instanceof XBLOMTemplateElement)) {
                return;
            }
            XBLOMTemplateElement xBLOMTemplateElement = (XBLOMTemplateElement)eventTarget;
            DefinitionRecord definitionRecord = (DefinitionRecord)DefaultXBLManager.this.definitions.get(node, this.importElement);
            if (definitionRecord == null || definitionRecord.template != xBLOMTemplateElement) {
                return;
            }
            ImportRecord importRecord = (ImportRecord)DefaultXBLManager.this.imports.get(this.importElement);
            DefaultXBLManager.this.removeTemplateElementListeners(xBLOMTemplateElement, importRecord);
            definitionRecord.template = null;
            for (Node node2 = xBLOMTemplateElement.getNextSibling(); node2 != null; node2 = node2.getNextSibling()) {
                if (!(node2 instanceof XBLOMTemplateElement)) continue;
                definitionRecord.template = (XBLOMTemplateElement)node2;
                break;
            }
            DefaultXBLManager.this.addTemplateElementListeners(definitionRecord.template, importRecord);
            DefaultXBLManager.this.rebind(definitionRecord.namespaceURI, definitionRecord.localName, DefaultXBLManager.this.document.getDocumentElement());
        }
    }

    protected class DefNodeInsertedListener
    implements EventListener {
        protected Element importElement;

        public DefNodeInsertedListener(Element element) {
            this.importElement = element;
        }

        @Override
        public void handleEvent(Event event) {
            MutationEvent mutationEvent = (MutationEvent)event;
            Node node = mutationEvent.getRelatedNode();
            if (!(node instanceof XBLOMDefinitionElement)) {
                return;
            }
            EventTarget eventTarget = event.getTarget();
            if (!(eventTarget instanceof XBLOMTemplateElement)) {
                return;
            }
            XBLOMTemplateElement xBLOMTemplateElement = (XBLOMTemplateElement)eventTarget;
            DefinitionRecord definitionRecord = (DefinitionRecord)DefaultXBLManager.this.definitions.get(node, this.importElement);
            if (definitionRecord == null) {
                return;
            }
            ImportRecord importRecord = (ImportRecord)DefaultXBLManager.this.imports.get(this.importElement);
            if (definitionRecord.template != null) {
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    if (node2 == xBLOMTemplateElement) {
                        DefaultXBLManager.this.removeTemplateElementListeners(definitionRecord.template, importRecord);
                        definitionRecord.template = xBLOMTemplateElement;
                        break;
                    }
                    if (node2 != definitionRecord.template) continue;
                    return;
                }
            } else {
                definitionRecord.template = xBLOMTemplateElement;
            }
            DefaultXBLManager.this.addTemplateElementListeners(xBLOMTemplateElement, importRecord);
            DefaultXBLManager.this.rebind(definitionRecord.namespaceURI, definitionRecord.localName, DefaultXBLManager.this.document.getDocumentElement());
        }
    }

    protected class DefAttrListener
    implements EventListener {
        protected Element importElement;

        public DefAttrListener(Element element) {
            this.importElement = element;
        }

        @Override
        public void handleEvent(Event event) {
            EventTarget eventTarget = event.getTarget();
            if (!(eventTarget instanceof XBLOMDefinitionElement)) {
                return;
            }
            XBLOMDefinitionElement xBLOMDefinitionElement = (XBLOMDefinitionElement)eventTarget;
            if (!DefaultXBLManager.this.isActiveDefinition(xBLOMDefinitionElement, this.importElement)) {
                return;
            }
            MutationEvent mutationEvent = (MutationEvent)event;
            String string = mutationEvent.getAttrName();
            if (string.equals("element")) {
                DefinitionRecord definitionRecord = (DefinitionRecord)DefaultXBLManager.this.definitions.get(xBLOMDefinitionElement, this.importElement);
                DefaultXBLManager.this.removeDefinition(definitionRecord);
                DefaultXBLManager.this.addDefinition(xBLOMDefinitionElement.getElementNamespaceURI(), xBLOMDefinitionElement.getElementLocalName(), xBLOMDefinitionElement, this.importElement);
            } else if (string.equals("ref") && mutationEvent.getNewValue().length() != 0) {
                DefinitionRecord definitionRecord = (DefinitionRecord)DefaultXBLManager.this.definitions.get(xBLOMDefinitionElement, this.importElement);
                DefaultXBLManager.this.removeDefinition(definitionRecord);
                DefaultXBLManager.this.addDefinitionRef(xBLOMDefinitionElement);
            }
        }
    }

    protected class TemplateMutationListener
    implements EventListener {
        protected Element importElement;

        public TemplateMutationListener(Element element) {
            this.importElement = element;
        }

        @Override
        public void handleEvent(Event event) {
            Node node;
            for (node = (Node)((Object)event.getTarget()); node != null && !(node instanceof XBLOMDefinitionElement); node = node.getParentNode()) {
            }
            DefinitionRecord definitionRecord = (DefinitionRecord)DefaultXBLManager.this.definitions.get(node, this.importElement);
            if (definitionRecord == null) {
                return;
            }
            DefaultXBLManager.this.rebind(definitionRecord.namespaceURI, definitionRecord.localName, DefaultXBLManager.this.document.getDocumentElement());
        }
    }

    protected class DocSubtreeListener
    implements EventListener {
        protected DocSubtreeListener() {
        }

        @Override
        public void handleEvent(Event event) {
            Object[] objectArray = DefaultXBLManager.this.docRemovedListener.defsToBeRemoved.toArray();
            DefaultXBLManager.this.docRemovedListener.defsToBeRemoved.clear();
            for (int i = 0; i < objectArray.length; ++i) {
                XBLOMDefinitionElement xBLOMDefinitionElement = (XBLOMDefinitionElement)objectArray[i];
                if (xBLOMDefinitionElement.getAttributeNS(null, "ref").length() == 0) {
                    DefinitionRecord definitionRecord = (DefinitionRecord)DefaultXBLManager.this.definitions.get(xBLOMDefinitionElement, null);
                    DefaultXBLManager.this.removeDefinition(definitionRecord);
                    continue;
                }
                DefaultXBLManager.this.removeDefinitionRef(xBLOMDefinitionElement);
            }
            Object[] objectArray2 = DefaultXBLManager.this.docRemovedListener.importsToBeRemoved.toArray();
            DefaultXBLManager.this.docRemovedListener.importsToBeRemoved.clear();
            for (int i = 0; i < objectArray2.length; ++i) {
                DefaultXBLManager.this.removeImport((Element)objectArray2[i]);
            }
            Object[] objectArray3 = DefaultXBLManager.this.docRemovedListener.nodesToBeInvalidated.toArray();
            DefaultXBLManager.this.docRemovedListener.nodesToBeInvalidated.clear();
            for (int i = 0; i < objectArray3.length; ++i) {
                DefaultXBLManager.this.invalidateChildNodes((Node)objectArray3[i]);
            }
        }
    }

    protected class DocRemovedListener
    implements EventListener {
        protected LinkedList defsToBeRemoved = new LinkedList();
        protected LinkedList importsToBeRemoved = new LinkedList();
        protected LinkedList nodesToBeInvalidated = new LinkedList();

        protected DocRemovedListener() {
        }

        @Override
        public void handleEvent(Event event) {
            Node node;
            EventTarget eventTarget = event.getTarget();
            if (eventTarget instanceof XBLOMDefinitionElement) {
                if (DefaultXBLManager.this.getXblBoundElement((Node)((Object)eventTarget)) == null) {
                    this.defsToBeRemoved.add(eventTarget);
                }
            } else if (eventTarget instanceof XBLOMImportElement && DefaultXBLManager.this.getXblBoundElement((Node)((Object)eventTarget)) == null) {
                this.importsToBeRemoved.add(eventTarget);
            }
            if ((node = DefaultXBLManager.this.getXblParentNode((Node)((Object)eventTarget))) != null) {
                this.nodesToBeInvalidated.add(node);
            }
        }
    }

    protected class DocInsertedListener
    implements EventListener {
        protected DocInsertedListener() {
        }

        @Override
        public void handleEvent(Event event) {
            EventTarget eventTarget = event.getTarget();
            if (eventTarget instanceof XBLOMDefinitionElement) {
                if (DefaultXBLManager.this.getXblBoundElement((Node)((Object)eventTarget)) == null) {
                    XBLOMDefinitionElement xBLOMDefinitionElement = (XBLOMDefinitionElement)eventTarget;
                    if (xBLOMDefinitionElement.getAttributeNS(null, "ref").length() == 0) {
                        DefaultXBLManager.this.addDefinition(xBLOMDefinitionElement.getElementNamespaceURI(), xBLOMDefinitionElement.getElementLocalName(), xBLOMDefinitionElement, null);
                    } else {
                        DefaultXBLManager.this.addDefinitionRef(xBLOMDefinitionElement);
                    }
                }
            } else if (eventTarget instanceof XBLOMImportElement) {
                if (DefaultXBLManager.this.getXblBoundElement((Node)((Object)eventTarget)) == null) {
                    DefaultXBLManager.this.addImport((Element)((Object)eventTarget));
                }
            } else {
                eventTarget = (event = XBLEventSupport.getUltimateOriginalEvent(event)).getTarget();
                Node node = DefaultXBLManager.this.getXblParentNode((Node)((Object)eventTarget));
                if (node != null) {
                    DefaultXBLManager.this.invalidateChildNodes(node);
                }
                if (eventTarget instanceof BindableElement) {
                    for (Node node2 = ((Node)((Object)eventTarget)).getParentNode(); node2 != null; node2 = node2.getParentNode()) {
                        if (!(node2 instanceof BindableElement) || DefaultXBLManager.this.getRecord((Node)node2).definitionElement == null) continue;
                        return;
                    }
                    DefaultXBLManager.this.bind((Element)((Object)eventTarget));
                }
            }
        }
    }

    protected class ImportSubtreeListener
    implements EventListener {
        protected Element importElement;
        protected ImportRemovedListener importRemovedListener;

        public ImportSubtreeListener(Element element, ImportRemovedListener importRemovedListener) {
            this.importElement = element;
            this.importRemovedListener = importRemovedListener;
        }

        @Override
        public void handleEvent(Event event) {
            Object[] objectArray = this.importRemovedListener.toBeRemoved.toArray();
            this.importRemovedListener.toBeRemoved.clear();
            for (int i = 0; i < objectArray.length; ++i) {
                XBLOMDefinitionElement xBLOMDefinitionElement = (XBLOMDefinitionElement)objectArray[i];
                DefinitionRecord definitionRecord = (DefinitionRecord)DefaultXBLManager.this.definitions.get(xBLOMDefinitionElement, this.importElement);
                DefaultXBLManager.this.removeDefinition(definitionRecord);
            }
        }
    }

    protected class ImportRemovedListener
    implements EventListener {
        protected LinkedList toBeRemoved = new LinkedList();

        protected ImportRemovedListener() {
        }

        @Override
        public void handleEvent(Event event) {
            this.toBeRemoved.add(event.getTarget());
        }
    }

    protected class ImportInsertedListener
    implements EventListener {
        protected Element importElement;

        public ImportInsertedListener(Element element) {
            this.importElement = element;
        }

        @Override
        public void handleEvent(Event event) {
            EventTarget eventTarget = event.getTarget();
            if (eventTarget instanceof XBLOMDefinitionElement) {
                XBLOMDefinitionElement xBLOMDefinitionElement = (XBLOMDefinitionElement)eventTarget;
                DefaultXBLManager.this.addDefinition(xBLOMDefinitionElement.getElementNamespaceURI(), xBLOMDefinitionElement.getElementLocalName(), xBLOMDefinitionElement, this.importElement);
            }
        }
    }

    protected class ImportRecord {
        public Element importElement;
        public Node node;
        public DefNodeInsertedListener defNodeInsertedListener;
        public DefNodeRemovedListener defNodeRemovedListener;
        public DefAttrListener defAttrListener;
        public ImportInsertedListener importInsertedListener;
        public ImportRemovedListener importRemovedListener;
        public ImportSubtreeListener importSubtreeListener;
        public TemplateMutationListener templateMutationListener;

        public ImportRecord(Element element, Node node) {
            this.importElement = element;
            this.node = node;
            this.defNodeInsertedListener = new DefNodeInsertedListener(element);
            this.defNodeRemovedListener = new DefNodeRemovedListener(element);
            this.defAttrListener = new DefAttrListener(element);
            this.importInsertedListener = new ImportInsertedListener(element);
            this.importRemovedListener = new ImportRemovedListener();
            this.importSubtreeListener = new ImportSubtreeListener(element, this.importRemovedListener);
            this.templateMutationListener = new TemplateMutationListener(element);
        }
    }

    protected class DefinitionRecord
    implements Comparable {
        public String namespaceURI;
        public String localName;
        public XBLOMDefinitionElement definition;
        public XBLOMTemplateElement template;
        public Element importElement;

        public DefinitionRecord(String string, String string2, XBLOMDefinitionElement xBLOMDefinitionElement, XBLOMTemplateElement xBLOMTemplateElement, Element element) {
            this.namespaceURI = string;
            this.localName = string2;
            this.definition = xBLOMDefinitionElement;
            this.template = xBLOMTemplateElement;
            this.importElement = element;
        }

        public boolean equals(Object object) {
            return this.compareTo(object) == 0;
        }

        public int compareTo(Object object) {
            AbstractNode abstractNode;
            AbstractNode abstractNode2;
            DefinitionRecord definitionRecord = (DefinitionRecord)object;
            if (this.importElement == null) {
                abstractNode2 = this.definition;
                abstractNode = definitionRecord.importElement == null ? definitionRecord.definition : (AbstractNode)((Object)definitionRecord.importElement);
            } else if (definitionRecord.importElement == null) {
                abstractNode2 = (AbstractNode)((Object)this.importElement);
                abstractNode = definitionRecord.definition;
            } else if (this.definition.getOwnerDocument() == definitionRecord.definition.getOwnerDocument()) {
                abstractNode2 = this.definition;
                abstractNode = definitionRecord.definition;
            } else {
                abstractNode2 = (AbstractNode)((Object)this.importElement);
                abstractNode = (AbstractNode)((Object)definitionRecord.importElement);
            }
            short s = abstractNode2.compareDocumentPosition(abstractNode);
            if ((s & 2) != 0) {
                return -1;
            }
            if ((s & 4) != 0) {
                return 1;
            }
            return 0;
        }
    }
}

