/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.controlFlow;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.BranchingInstruction;
import com.intellij.psi.controlFlow.CallInstruction;
import com.intellij.psi.controlFlow.CompositeInstructionClientVisitor;
import com.intellij.psi.controlFlow.ConditionalBranchingInstruction;
import com.intellij.psi.controlFlow.ConditionalGoToInstruction;
import com.intellij.psi.controlFlow.ConditionalThrowToInstruction;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowInstructionVisitor;
import com.intellij.psi.controlFlow.ControlFlowStack;
import com.intellij.psi.controlFlow.GoToInstruction;
import com.intellij.psi.controlFlow.Instruction;
import com.intellij.psi.controlFlow.InstructionClientVisitor;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.controlFlow.ReadVariableInstruction;
import com.intellij.psi.controlFlow.ReturnInstruction;
import com.intellij.psi.controlFlow.ReturnStatementsVisitor;
import com.intellij.psi.controlFlow.ThrowToInstruction;
import com.intellij.psi.controlFlow.WriteVariableInstruction;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.IntArrayList;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ControlFlowUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.controlFlow.ControlFlowUtil");
    public static final Class[] DEFAULT_EXIT_STATEMENTS_CLASSES = new Class[]{PsiReturnStatement.class, PsiBreakStatement.class, PsiContinueStatement.class};
    public static final int NORMAL_COMPLETION_REASON = 1;
    public static final int RETURN_COMPLETION_REASON = 2;

    public static List<PsiVariable> getSSAVariables(ControlFlow flow) {
        return ControlFlowUtil.getSSAVariables(flow, 0, flow.getSize(), false);
    }

    public static List<PsiVariable> getSSAVariables(ControlFlow flow, int from, int to, boolean reportVarsIfNonInitializingPathExists) {
        List<Instruction> instructions = flow.getInstructions();
        Collection<PsiVariable> writtenVariables = ControlFlowUtil.getWrittenVariables(flow, from, to, false);
        ArrayList<PsiVariable> result2 = new ArrayList<PsiVariable>(1);
        block0: for (PsiVariable psiVariable : writtenVariables) {
            ArrayList<SSAInstructionState> queue = new ArrayList<SSAInstructionState>();
            queue.add(new SSAInstructionState(0, from));
            THashSet<SSAInstructionState> processedStates = new THashSet<SSAInstructionState>();
            while (!queue.isEmpty()) {
                SSAInstructionState state2 = (SSAInstructionState)queue.remove(0);
                if (state2.getWriteCount() > 1) continue block0;
                if (processedStates.contains(state2)) continue;
                processedStates.add(state2);
                int i = state2.getInstructionIdx();
                if (i < to) {
                    Instruction instruction = instructions.get(i);
                    if (instruction instanceof ReturnInstruction) {
                        int[] offsets;
                        for (int offset : offsets = ((ReturnInstruction)instruction).getPossibleReturnOffsets()) {
                            queue.add(new SSAInstructionState(state2.getWriteCount(), Math.min(offset, to)));
                        }
                        continue;
                    }
                    if (instruction instanceof GoToInstruction) {
                        int nextOffset = ((GoToInstruction)instruction).offset;
                        nextOffset = Math.min(nextOffset, to);
                        queue.add(new SSAInstructionState(state2.getWriteCount(), nextOffset));
                        continue;
                    }
                    if (instruction instanceof ThrowToInstruction) {
                        int nextOffset = ((ThrowToInstruction)instruction).offset;
                        nextOffset = Math.min(nextOffset, to);
                        queue.add(new SSAInstructionState(state2.getWriteCount(), nextOffset));
                        continue;
                    }
                    if (instruction instanceof ConditionalGoToInstruction) {
                        int nextOffset = ((ConditionalGoToInstruction)instruction).offset;
                        nextOffset = Math.min(nextOffset, to);
                        queue.add(new SSAInstructionState(state2.getWriteCount(), nextOffset));
                        queue.add(new SSAInstructionState(state2.getWriteCount(), i + 1));
                        continue;
                    }
                    if (instruction instanceof ConditionalThrowToInstruction) {
                        int nextOffset = ((ConditionalThrowToInstruction)instruction).offset;
                        nextOffset = Math.min(nextOffset, to);
                        queue.add(new SSAInstructionState(state2.getWriteCount(), nextOffset));
                        queue.add(new SSAInstructionState(state2.getWriteCount(), i + 1));
                        continue;
                    }
                    if (instruction instanceof WriteVariableInstruction) {
                        WriteVariableInstruction write2 = (WriteVariableInstruction)instruction;
                        queue.add(new SSAInstructionState(state2.getWriteCount() + (write2.variable == psiVariable ? 1 : 0), i + 1));
                        continue;
                    }
                    if (instruction instanceof ReadVariableInstruction) {
                        ReadVariableInstruction read = (ReadVariableInstruction)instruction;
                        if (read.variable == psiVariable && state2.getWriteCount() == 0) continue block0;
                        queue.add(new SSAInstructionState(state2.getWriteCount(), i + 1));
                        continue;
                    }
                    queue.add(new SSAInstructionState(state2.getWriteCount(), i + 1));
                    continue;
                }
                if (reportVarsIfNonInitializingPathExists || state2.getWriteCount() != 0) continue;
                continue block0;
            }
            result2.add(psiVariable);
        }
        return result2;
    }

    private static boolean needVariableValueAt(final PsiVariable variable, final ControlFlow flow, final int offset) {
        InstructionClientVisitor<Boolean> visitor2 = new InstructionClientVisitor<Boolean>(){
            final boolean[] neededBelow;
            {
                this.neededBelow = new boolean[flow.getSize() + 1];
            }

            @Override
            public void procedureEntered(int startOffset, int endOffset) {
                for (int i = startOffset; i < endOffset; ++i) {
                    this.neededBelow[i] = false;
                }
            }

            @Override
            public void visitReadVariableInstruction(ReadVariableInstruction instruction, int offset2, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean needed = this.neededBelow[nextOffset];
                if (instruction.variable.equals(variable)) {
                    needed = true;
                }
                int n = offset2;
                this.neededBelow[n] = this.neededBelow[n] | needed;
            }

            @Override
            public void visitWriteVariableInstruction(WriteVariableInstruction instruction, int offset2, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean needed = this.neededBelow[nextOffset];
                if (instruction.variable.equals(variable)) {
                    needed = false;
                }
                this.neededBelow[offset2] = needed;
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset2, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean needed = this.neededBelow[nextOffset];
                int n = offset2;
                this.neededBelow[n] = this.neededBelow[n] | needed;
            }

            @Override
            public Boolean getResult() {
                return this.neededBelow[offset];
            }
        };
        ControlFlowUtil.depthFirstSearch(flow, visitor2, offset, flow.getSize());
        return (Boolean)visitor2.getResult();
    }

    public static Collection<PsiVariable> getWrittenVariables(ControlFlow flow, int start, int end, boolean ignoreNotReachingWrites) {
        HashSet<PsiVariable> set = new HashSet<PsiVariable>();
        ControlFlowUtil.getWrittenVariables(flow, start, end, ignoreNotReachingWrites, set);
        return set;
    }

    public static void getWrittenVariables(ControlFlow flow, int start, int end, boolean ignoreNotReachingWrites, Collection<PsiVariable> set) {
        List<Instruction> instructions = flow.getInstructions();
        for (int i = start; i < end; ++i) {
            Instruction instruction = instructions.get(i);
            if (!(instruction instanceof WriteVariableInstruction) || ignoreNotReachingWrites && !ControlFlowUtil.isInstructionReachable(flow, end, i)) continue;
            set.add(((WriteVariableInstruction)instruction).variable);
        }
    }

    public static List<PsiVariable> getUsedVariables(ControlFlow flow, int start, int end) {
        ArrayList<PsiVariable> array = new ArrayList<PsiVariable>();
        if (start < 0) {
            return array;
        }
        List<Instruction> instructions = flow.getInstructions();
        for (int i = start; i < end; ++i) {
            PsiVariable variable;
            Instruction instruction = instructions.get(i);
            if (instruction instanceof ReadVariableInstruction) {
                variable = ((ReadVariableInstruction)instruction).variable;
                if (array.contains(variable)) continue;
                array.add(variable);
                continue;
            }
            if (!(instruction instanceof WriteVariableInstruction) || array.contains(variable = ((WriteVariableInstruction)instruction).variable)) continue;
            array.add(variable);
        }
        return array;
    }

    public static List<PsiVariable> getInputVariables(ControlFlow flow, int start, int end) {
        List<PsiVariable> usedVariables = ControlFlowUtil.getUsedVariables(flow, start, end);
        ArrayList<PsiVariable> array = new ArrayList<PsiVariable>(usedVariables.size());
        for (PsiVariable variable : usedVariables) {
            if (!ControlFlowUtil.needVariableValueAt(variable, flow, start)) continue;
            array.add(variable);
        }
        return array;
    }

    public static PsiVariable[] getOutputVariables(ControlFlow flow, int start, int end, int[] exitPoints) {
        Collection<PsiVariable> writtenVariables = ControlFlowUtil.getWrittenVariables(flow, start, end, false);
        ArrayList<PsiVariable> array = new ArrayList<PsiVariable>();
        for (PsiVariable variable : writtenVariables) {
            int[] nArray = exitPoints;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int exitPoint = nArray[i];
                if (!ControlFlowUtil.needVariableValueAt(variable, flow, exitPoint)) continue;
                array.add(variable);
            }
        }
        PsiVariable[] outputVariables = array.toArray(new PsiVariable[array.size()]);
        if (LOG.isDebugEnabled()) {
            LOG.debug("output variables:");
            for (PsiVariable variable : outputVariables) {
                LOG.debug("  " + variable.toString());
            }
        }
        return outputVariables;
    }

    public static Collection<PsiStatement> findExitPointsAndStatements(final ControlFlow flow, final int start, final int end, final IntArrayList exitPoints, final Class ... classesFilter) {
        if (end == start) {
            exitPoints.add(end);
            return Collections.emptyList();
        }
        final THashSet<PsiStatement> exitStatements = new THashSet<PsiStatement>();
        InstructionClientVisitor visitor2 = new InstructionClientVisitor(){

            @Override
            public void visitThrowToInstruction(ThrowToInstruction instruction, int offset, int nextOffset) {
                ControlFlowUtil.processGotoStatement(classesFilter, exitStatements, ControlFlowUtil.findStatement(flow, offset));
            }

            @Override
            public void visitBranchingInstruction(BranchingInstruction instruction, int offset, int nextOffset) {
                ControlFlowUtil.processGoto(flow, start, end, exitPoints, exitStatements, instruction, classesFilter, ControlFlowUtil.findStatement(flow, offset));
            }

            @Override
            public void visitReturnInstruction(ReturnInstruction instruction, int offset, int nextOffset) {
            }

            @Override
            public void visitCallInstruction(CallInstruction instruction, int offset, int nextOffset) {
            }

            @Override
            public void visitConditionalThrowToInstruction(ConditionalThrowToInstruction instruction, int offset, int nextOffset) {
                this.visitInstruction(instruction, offset, nextOffset);
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset, int nextOffset) {
                if (offset >= end - 1) {
                    int exitOffset = end;
                    if (!exitPoints.contains(exitOffset = ControlFlowUtil.promoteThroughGotoChain(flow, exitOffset))) {
                        exitPoints.add(exitOffset);
                    }
                }
            }

            public Object getResult() {
                return null;
            }
        };
        ControlFlowUtil.depthFirstSearch(flow, visitor2, start, end);
        return exitStatements;
    }

    private static void processGoto(ControlFlow flow, int start, int end, IntArrayList exitPoints, Collection<PsiStatement> exitStatements, BranchingInstruction instruction, Class[] classesFilter, PsiStatement statement) {
        if (statement == null) {
            return;
        }
        int gotoOffset = instruction.offset;
        if (start > gotoOffset || gotoOffset >= end || ControlFlowUtil.isElementOfClass(statement, classesFilter)) {
            if (!(exitPoints.contains(gotoOffset = ControlFlowUtil.promoteThroughGotoChain(flow, gotoOffset)) || gotoOffset < end && gotoOffset >= start || gotoOffset <= 0)) {
                exitPoints.add(gotoOffset);
            }
            if (gotoOffset >= end || gotoOffset < start) {
                ControlFlowUtil.processGotoStatement(classesFilter, exitStatements, statement);
            } else {
                boolean isReturn = instruction instanceof GoToInstruction && ((GoToInstruction)instruction).isReturn;
                Instruction gotoInstruction = flow.getInstructions().get(gotoOffset);
                if (isReturn |= gotoInstruction instanceof GoToInstruction && ((GoToInstruction)gotoInstruction).isReturn) {
                    ControlFlowUtil.processGotoStatement(classesFilter, exitStatements, statement);
                }
            }
        }
    }

    private static void processGotoStatement(Class[] classesFilter, Collection<PsiStatement> exitStatements, PsiStatement statement) {
        if (statement != null && ControlFlowUtil.isElementOfClass(statement, classesFilter)) {
            exitStatements.add(statement);
        }
    }

    private static boolean isElementOfClass(PsiElement element, Class[] classesFilter) {
        if (classesFilter == null) {
            return true;
        }
        for (Class aClassesFilter : classesFilter) {
            if (!ReflectionUtil.isAssignable(aClassesFilter, element.getClass())) continue;
            return true;
        }
        return false;
    }

    private static int promoteThroughGotoChain(ControlFlow flow, int offset) {
        Instruction instruction;
        List<Instruction> instructions = flow.getInstructions();
        while (offset < instructions.size() && (instruction = instructions.get(offset)) instanceof GoToInstruction && !((GoToInstruction)instruction).isReturn) {
            offset = ((BranchingInstruction)instruction).offset;
        }
        return offset;
    }

    private static PsiStatement findStatement(ControlFlow flow, int offset) {
        PsiElement element = flow.getElement(offset);
        return PsiTreeUtil.getParentOfType(element, PsiStatement.class, false);
    }

    @NotNull
    public static PsiElement findCodeFragment(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/controlFlow/ControlFlowUtil", "findCodeFragment"));
        }
        PsiElement codeFragment = element;
        for (PsiElement parent2 = codeFragment.getParent(); !(parent2 == null || parent2 instanceof PsiDirectory || parent2 instanceof PsiMethod || parent2 instanceof PsiField || parent2 instanceof PsiClassInitializer || parent2 instanceof DummyHolder || parent2 instanceof PsiLambdaExpression); parent2 = parent2.getParent()) {
            codeFragment = parent2;
        }
        PsiElement psiElement = codeFragment;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/ControlFlowUtil", "findCodeFragment"));
        }
        return psiElement;
    }

    private static boolean checkReferenceExpressionScope(PsiReferenceExpression ref, @NotNull PsiElement targetClassMember) {
        if (targetClassMember == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetClassMember", "com/intellij/psi/controlFlow/ControlFlowUtil", "checkReferenceExpressionScope"));
        }
        JavaResolveResult resolveResult = ref.advancedResolve(false);
        PsiElement def = resolveResult.getElement();
        if (def != null) {
            PsiElement commonParent;
            PsiElement parent2 = def.getParent();
            PsiElement psiElement = commonParent = parent2 == null ? null : PsiTreeUtil.findCommonParent(parent2, targetClassMember);
            if (commonParent == null) {
                parent2 = resolveResult.getCurrentFileResolveScope();
            }
            if (parent2 instanceof PsiClass) {
                PsiClass clss = (PsiClass)parent2;
                if (PsiTreeUtil.isAncestor(targetClassMember, clss, false)) {
                    return false;
                }
                for (PsiClass containingClass = PsiTreeUtil.getParentOfType((PsiElement)ref, PsiClass.class); containingClass != null; containingClass = containingClass.getContainingClass()) {
                    if (!containingClass.isInheritor(clss, true) || !PsiTreeUtil.isAncestor(targetClassMember, containingClass, false)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean collectOuterLocals(List<PsiVariable> array, PsiElement scope2, PsiElement member, PsiElement targetClassMember) {
        PsiJavaCodeReferenceElement qualifier2;
        PsiMethodCallExpression call;
        if (scope2 instanceof PsiMethodCallExpression ? !ControlFlowUtil.checkReferenceExpressionScope((call = (PsiMethodCallExpression)scope2).getMethodExpression(), targetClassMember) : scope2 instanceof PsiReferenceExpression && !ControlFlowUtil.checkReferenceExpressionScope((PsiReferenceExpression)scope2, targetClassMember)) {
            return false;
        }
        if (scope2 instanceof PsiJavaCodeReferenceElement) {
            PsiJavaCodeReferenceElement ref = (PsiJavaCodeReferenceElement)scope2;
            JavaResolveResult result2 = ref.advancedResolve(false);
            PsiElement refElement = result2.getElement();
            if (refElement != null) {
                PsiElement parent2 = refElement.getParent();
                PsiElement psiElement = parent2 = parent2 != null ? PsiTreeUtil.findCommonParent(parent2, member) : null;
                if (parent2 == null) {
                    parent2 = result2.getCurrentFileResolveScope();
                }
                if (parent2 != null && !member.equals(parent2) && targetClassMember.equals(parent2 = PsiTreeUtil.findCommonParent(parent2, targetClassMember))) {
                    if (!(refElement instanceof PsiVariable)) return false;
                    if (scope2 instanceof PsiReferenceExpression && PsiUtil.isAccessedForWriting((PsiReferenceExpression)scope2)) {
                        return false;
                    }
                    PsiVariable variable = (PsiVariable)refElement;
                    if (!array.contains(variable)) {
                        array.add(variable);
                    }
                }
            }
        } else if (scope2 instanceof PsiThisExpression ? (qualifier2 = ((PsiThisExpression)scope2).getQualifier()) == null : scope2 instanceof PsiSuperExpression && ((PsiSuperExpression)scope2).getQualifier() == null) {
            return false;
        }
        for (PsiElement child = scope2.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (ControlFlowUtil.collectOuterLocals(array, child, member, targetClassMember)) continue;
            return false;
        }
        return true;
    }

    public static boolean returnPresent(ControlFlow flow) {
        ReturnPresentClientVisitor visitor2 = new ReturnPresentClientVisitor(flow);
        ControlFlowUtil.depthFirstSearch(flow, visitor2);
        return (Boolean)((InstructionClientVisitor)visitor2).getResult();
    }

    public static boolean processReturns(ControlFlow flow, ReturnStatementsVisitor afterVisitor) throws IncorrectOperationException {
        ConvertReturnClientVisitor instructionsVisitor = new ConvertReturnClientVisitor(flow, afterVisitor);
        ControlFlowUtil.depthFirstSearch(flow, instructionsVisitor);
        instructionsVisitor.afterProcessing();
        return instructionsVisitor.getResult();
    }

    public static boolean returnPresentBetween(final ControlFlow flow, final int startOffset, final int endOffset) {
        class MyVisitor
        extends InstructionClientVisitor<Boolean> {
            final boolean[] isNormalCompletion;

            public MyVisitor() {
                int i;
                this.isNormalCompletion = new boolean[flow.getSize() + 1];
                int length = flow.getSize();
                for (i = 0; i < startOffset; ++i) {
                    this.isNormalCompletion[i] = true;
                }
                for (i = endOffset; i <= length; ++i) {
                    this.isNormalCompletion[i] = true;
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void visitConditionalThrowToInstruction(ConditionalThrowToInstruction instruction, int offset, int nextOffset) {
                boolean isNormal;
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                if (offset > endOffset) {
                    return;
                }
                int throwToOffset = instruction.offset;
                if (throwToOffset == nextOffset) {
                    if (throwToOffset > endOffset) return;
                    isNormal = !this.isLeaf(nextOffset) && this.isNormalCompletion[nextOffset];
                } else {
                    isNormal = this.isLeaf(nextOffset) || this.isNormalCompletion[nextOffset];
                }
                int n = offset;
                this.isNormalCompletion[n] = this.isNormalCompletion[n] | isNormal;
            }

            @Override
            public void visitThrowToInstruction(ThrowToInstruction instruction, int offset, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                if (offset > endOffset) {
                    return;
                }
                if (nextOffset <= endOffset) {
                    boolean isNormal = !this.isLeaf(nextOffset) && this.isNormalCompletion[nextOffset];
                    int n = offset;
                    this.isNormalCompletion[n] = this.isNormalCompletion[n] | isNormal;
                }
            }

            @Override
            public void visitCallInstruction(CallInstruction instruction, int offset, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                if (offset > endOffset) {
                    return;
                }
                if (nextOffset > endOffset && nextOffset != offset + 1) {
                    return;
                }
                boolean isNormal = this.isNormalCompletion[nextOffset];
                int n = offset;
                this.isNormalCompletion[n] = this.isNormalCompletion[n] | isNormal;
            }

            @Override
            public void visitGoToInstruction(GoToInstruction instruction, int offset, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                if (offset > endOffset) {
                    return;
                }
                boolean isRethrowFromFinally = instruction instanceof ReturnInstruction && ((ReturnInstruction)instruction).isRethrowFromFinally();
                boolean isNormal = !instruction.isReturn && this.isNormalCompletion[nextOffset] && !isRethrowFromFinally;
                int n = offset;
                this.isNormalCompletion[n] = this.isNormalCompletion[n] | isNormal;
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                if (offset > endOffset) {
                    return;
                }
                boolean isNormal = this.isLeaf(nextOffset) || this.isNormalCompletion[nextOffset];
                int n = offset;
                this.isNormalCompletion[n] = this.isNormalCompletion[n] | isNormal;
            }

            @Override
            public Boolean getResult() {
                return !this.isNormalCompletion[startOffset];
            }
        }
        MyVisitor visitor2 = new MyVisitor();
        ControlFlowUtil.depthFirstSearch(flow, visitor2, startOffset, endOffset);
        return visitor2.getResult();
    }

    public static Object[] getAllWorldProblemsAtOnce(ControlFlow flow) {
        InstructionClientVisitor[] visitors = new InstructionClientVisitor[]{new ReturnPresentClientVisitor(flow), new UnreachableStatementClientVisitor(flow), new ReadBeforeWriteClientVisitor(flow, true), new InitializedTwiceClientVisitor(flow, 0)};
        CompositeInstructionClientVisitor visitor2 = new CompositeInstructionClientVisitor(visitors);
        ControlFlowUtil.depthFirstSearch(flow, visitor2);
        return visitor2.getResult();
    }

    public static boolean canCompleteNormally(final ControlFlow flow, final int startOffset, final int endOffset) {
        class MyVisitor
        extends InstructionClientVisitor<Boolean> {
            final boolean[] canCompleteNormally;

            MyVisitor() {
                this.canCompleteNormally = new boolean[flow.getSize() + 1];
            }

            @Override
            public void visitConditionalGoToInstruction(ConditionalGoToInstruction instruction, int offset, int nextOffset) {
                this.checkInstruction(offset, nextOffset, false);
            }

            @Override
            public void visitGoToInstruction(GoToInstruction instruction, int offset, int nextOffset) {
                this.checkInstruction(offset, nextOffset, instruction.isReturn);
            }

            private void checkInstruction(int offset, int nextOffset, boolean isReturn) {
                PsiElement element;
                boolean isNormal;
                if (offset > endOffset) {
                    return;
                }
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean bl = isNormal = nextOffset <= endOffset && !isReturn && (nextOffset == endOffset || this.canCompleteNormally[nextOffset]);
                if (isNormal && nextOffset == endOffset && ((element = flow.getElement(offset)) instanceof PsiBreakStatement || element instanceof PsiContinueStatement)) {
                    isNormal = false;
                }
                int n = offset;
                this.canCompleteNormally[n] = this.canCompleteNormally[n] | isNormal;
            }

            @Override
            public void visitConditionalThrowToInstruction(ConditionalThrowToInstruction instruction, int offset, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                if (offset > endOffset) {
                    return;
                }
                int throwToOffset = instruction.offset;
                boolean isNormal = false;
                if (throwToOffset == nextOffset) {
                    if (nextOffset == endOffset) {
                        int lastOffset = endOffset - 1;
                        Instruction lastInstruction = flow.getInstructions().get(lastOffset);
                        while (lastInstruction instanceof GoToInstruction && ((GoToInstruction)lastInstruction).role == BranchingInstruction.Role.END && !((GoToInstruction)lastInstruction).isReturn) {
                            if (((GoToInstruction)lastInstruction).offset == startOffset) {
                                lastOffset = -1;
                                break;
                            }
                            if (--lastOffset < 0) break;
                            lastInstruction = flow.getInstructions().get(lastOffset);
                        }
                        if (lastOffset >= 0) {
                            isNormal = (!(lastInstruction instanceof GoToInstruction) || !((GoToInstruction)lastInstruction).isReturn) && !(lastInstruction instanceof ThrowToInstruction);
                        }
                    }
                    isNormal |= throwToOffset <= endOffset && !this.isLeaf(nextOffset) && this.canCompleteNormally[nextOffset];
                } else {
                    isNormal = this.canCompleteNormally[nextOffset];
                }
                int n = offset;
                this.canCompleteNormally[n] = this.canCompleteNormally[n] | isNormal;
            }

            @Override
            public void visitThrowToInstruction(ThrowToInstruction instruction, int offset, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                if (offset > endOffset) {
                    return;
                }
                if (nextOffset <= endOffset) {
                    boolean isNormal = !this.isLeaf(nextOffset) && this.canCompleteNormally[nextOffset];
                    int n = offset;
                    this.canCompleteNormally[n] = this.canCompleteNormally[n] | isNormal;
                }
            }

            @Override
            public void visitCallInstruction(CallInstruction instruction, int offset, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                if (offset > endOffset) {
                    return;
                }
                if (nextOffset > endOffset && nextOffset != offset + 1) {
                    return;
                }
                boolean isNormal = this.canCompleteNormally[nextOffset];
                int n = offset;
                this.canCompleteNormally[n] = this.canCompleteNormally[n] | isNormal;
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset, int nextOffset) {
                this.checkInstruction(offset, nextOffset, false);
            }

            @Override
            public Boolean getResult() {
                return this.canCompleteNormally[startOffset];
            }
        }
        MyVisitor visitor2 = new MyVisitor();
        ControlFlowUtil.depthFirstSearch(flow, visitor2, startOffset, endOffset);
        return visitor2.getResult();
    }

    public static PsiElement getUnreachableStatement(ControlFlow flow) {
        UnreachableStatementClientVisitor visitor2 = new UnreachableStatementClientVisitor(flow);
        ControlFlowUtil.depthFirstSearch(flow, visitor2);
        return (PsiElement)((InstructionClientVisitor)visitor2).getResult();
    }

    private static PsiReferenceExpression getEnclosingReferenceExpression(PsiElement element, PsiVariable variable) {
        PsiReferenceExpression reference = ControlFlowUtil.findReferenceTo(element, variable);
        if (reference != null) {
            return reference;
        }
        while (element != null) {
            if (element instanceof PsiReferenceExpression) {
                return (PsiReferenceExpression)element;
            }
            if (element instanceof PsiMethod || element instanceof PsiClass) {
                return null;
            }
            element = element.getParent();
        }
        return null;
    }

    private static PsiReferenceExpression findReferenceTo(PsiElement element, PsiVariable variable) {
        PsiElement[] children;
        if (element instanceof PsiReferenceExpression && !((PsiReferenceExpression)element).isQualified() && ((PsiReferenceExpression)element).resolve() == variable) {
            return (PsiReferenceExpression)element;
        }
        for (PsiElement child : children = element.getChildren()) {
            PsiReferenceExpression reference = ControlFlowUtil.findReferenceTo(child, variable);
            if (reference == null) continue;
            return reference;
        }
        return null;
    }

    public static boolean isVariableDefinitelyAssigned(final @NotNull PsiVariable variable, final @NotNull ControlFlow flow) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/psi/controlFlow/ControlFlowUtil", "isVariableDefinitelyAssigned"));
        }
        if (flow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flow", "com/intellij/psi/controlFlow/ControlFlowUtil", "isVariableDefinitelyAssigned"));
        }
        if (flow.getSize() == 0) {
            return false;
        }
        class MyVisitor
        extends InstructionClientVisitor<Boolean> {
            final boolean[] maybeUnassigned;

            MyVisitor() {
                this.maybeUnassigned = new boolean[flow.getSize() + 1];
                this.maybeUnassigned[this.maybeUnassigned.length - 1] = true;
            }

            @Override
            public void visitWriteVariableInstruction(WriteVariableInstruction instruction, int offset, int nextOffset) {
                if (instruction.variable == variable) {
                    this.maybeUnassigned[offset] = false;
                } else {
                    this.visitInstruction(instruction, offset, nextOffset);
                }
            }

            @Override
            public void visitConditionalThrowToInstruction(ConditionalThrowToInstruction instruction, int offset, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean unassigned = offset == flow.getSize() - 1 || !this.isLeaf(nextOffset) && this.maybeUnassigned[nextOffset];
                int n = offset;
                this.maybeUnassigned[n] = this.maybeUnassigned[n] | unassigned;
            }

            @Override
            public void visitCallInstruction(CallInstruction instruction, int offset, int nextOffset) {
                this.visitInstruction(instruction, offset, nextOffset);
                for (int i = instruction.procBegin; i < instruction.procEnd + 3; ++i) {
                    this.maybeUnassigned[i] = false;
                }
            }

            @Override
            public void visitThrowToInstruction(ThrowToInstruction instruction, int offset, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean unassigned = !this.isLeaf(nextOffset) && this.maybeUnassigned[nextOffset];
                int n = offset;
                this.maybeUnassigned[n] = this.maybeUnassigned[n] | unassigned;
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean unassigned = this.isLeaf(nextOffset) || this.maybeUnassigned[nextOffset];
                int n = offset;
                this.maybeUnassigned[n] = this.maybeUnassigned[n] | unassigned;
            }

            @Override
            public Boolean getResult() {
                int variableDeclarationOffset = flow.getStartOffset(variable.getParent());
                return !this.maybeUnassigned[variableDeclarationOffset > -1 ? variableDeclarationOffset : 0];
            }
        }
        MyVisitor visitor2 = new MyVisitor();
        ControlFlowUtil.depthFirstSearch(flow, visitor2);
        return visitor2.getResult();
    }

    public static boolean isVariableDefinitelyNotAssigned(final PsiVariable variable, final ControlFlow flow) {
        class MyVisitor
        extends InstructionClientVisitor<Boolean> {
            final boolean[] maybeAssigned;

            MyVisitor() {
                this.maybeAssigned = new boolean[flow.getSize() + 1];
            }

            @Override
            public void visitWriteVariableInstruction(WriteVariableInstruction instruction, int offset, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean assigned = instruction.variable == variable || this.maybeAssigned[nextOffset];
                int n = offset;
                this.maybeAssigned[n] = this.maybeAssigned[n] | assigned;
            }

            @Override
            public void visitThrowToInstruction(ThrowToInstruction instruction, int offset, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean assigned = !this.isLeaf(nextOffset) && this.maybeAssigned[nextOffset];
                int n = offset;
                this.maybeAssigned[n] = this.maybeAssigned[n] | assigned;
            }

            @Override
            public void visitConditionalThrowToInstruction(ConditionalThrowToInstruction instruction, int offset, int nextOffset) {
                int throwToOffset;
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean assigned = (throwToOffset = instruction.offset) == nextOffset ? !this.isLeaf(nextOffset) && this.maybeAssigned[nextOffset] : this.maybeAssigned[nextOffset];
                int n = offset;
                this.maybeAssigned[n] = this.maybeAssigned[n] | assigned;
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean assigned = this.maybeAssigned[nextOffset];
                int n = offset;
                this.maybeAssigned[n] = this.maybeAssigned[n] | assigned;
            }

            @Override
            public Boolean getResult() {
                return !this.maybeAssigned[0];
            }
        }
        MyVisitor visitor2 = new MyVisitor();
        ControlFlowUtil.depthFirstSearch(flow, visitor2);
        return visitor2.getResult();
    }

    public static int getMinDefinitelyReachedOffset(final ControlFlow flow, final int sourceOffset, final List references) {
        class MyVisitor
        extends InstructionClientVisitor<Integer> {
            final TIntHashSet[] exitPoints;

            MyVisitor() {
                this.exitPoints = new TIntHashSet[flow.getSize()];
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                if (this.exitPoints[offset] == null) {
                    this.exitPoints[offset] = new TIntHashSet();
                }
                if (this.isLeaf(nextOffset)) {
                    this.exitPoints[offset].add(offset);
                } else if (this.exitPoints[nextOffset] != null) {
                    this.exitPoints[offset].addAll(this.exitPoints[nextOffset].toArray());
                }
            }

            @Override
            public Integer getResult() {
                int minOffset = flow.getSize();
                int maxExitPoints = 0;
                block0: for (int i = sourceOffset; i < this.exitPoints.length; ++i) {
                    int size;
                    TIntHashSet exitPointSet = this.exitPoints[i];
                    int n = size = exitPointSet == null ? 0 : exitPointSet.size();
                    if (size <= maxExitPoints) continue;
                    for (Object reference : references) {
                        int endOffset;
                        PsiElement element = (PsiElement)reference;
                        PsiElement statement = PsiUtil.getEnclosingStatement(element);
                        if (statement == null || (endOffset = flow.getEndOffset(statement)) == -1 || i == endOffset || ControlFlowUtil.isInstructionReachable(flow, i, endOffset)) continue;
                        continue block0;
                    }
                    minOffset = i;
                    maxExitPoints = size;
                }
                return minOffset;
            }
        }
        MyVisitor visitor2 = new MyVisitor();
        ControlFlowUtil.depthFirstSearch(flow, visitor2);
        return visitor2.getResult();
    }

    private static void depthFirstSearch(ControlFlow flow, InstructionClientVisitor visitor2) {
        ControlFlowUtil.depthFirstSearch(flow, visitor2, 0, flow.getSize());
    }

    private static void depthFirstSearch(ControlFlow flow, InstructionClientVisitor visitor2, int startOffset, int endOffset) {
        visitor2.processedInstructions = new boolean[endOffset];
        ControlFlowUtil.internalDepthFirstSearch(flow.getInstructions(), visitor2, startOffset, endOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void internalDepthFirstSearch(final List<Instruction> instructions, final InstructionClientVisitor clientVisitor, int offset, int endOffset) {
        final IntArrayList oldOffsets = new IntArrayList(instructions.size() / 2);
        final IntArrayList newOffsets = new IntArrayList(instructions.size() / 2);
        oldOffsets.add(offset);
        newOffsets.add(-1);
        List<Instruction> list2 = instructions;
        synchronized (list2) {
            final IntArrayList currentProcedureReturnOffsets = new IntArrayList();
            ControlFlowInstructionVisitor getNextOffsetVisitor = new ControlFlowInstructionVisitor(){

                @Override
                public void visitCallInstruction(CallInstruction instruction, int offset, int nextOffset) {
                    int i;
                    instruction.execute(offset + 1);
                    int newOffset = instruction.offset;
                    for (i = instruction.procBegin; i < instruction.procEnd || instructions.get(i) instanceof ReturnInstruction; ++i) {
                        clientVisitor.processedInstructions[i] = false;
                    }
                    clientVisitor.procedureEntered(instruction.procBegin, i);
                    oldOffsets.add(offset);
                    newOffsets.add(newOffset);
                    oldOffsets.add(newOffset);
                    newOffsets.add(-1);
                    currentProcedureReturnOffsets.add(offset + 1);
                }

                @Override
                public void visitReturnInstruction(ReturnInstruction instruction, int offset, int nextOffset) {
                    int newOffset = instruction.execute(false);
                    if (newOffset != -1) {
                        oldOffsets.add(offset);
                        newOffsets.add(newOffset);
                        oldOffsets.add(newOffset);
                        newOffsets.add(-1);
                    }
                }

                @Override
                public void visitBranchingInstruction(BranchingInstruction instruction, int offset, int nextOffset) {
                    int newOffset = instruction.offset;
                    oldOffsets.add(offset);
                    newOffsets.add(newOffset);
                    oldOffsets.add(newOffset);
                    newOffsets.add(-1);
                }

                @Override
                public void visitConditionalBranchingInstruction(ConditionalBranchingInstruction instruction, int offset, int nextOffset) {
                    int newOffset = instruction.offset;
                    oldOffsets.add(offset);
                    newOffsets.add(newOffset);
                    oldOffsets.add(offset);
                    newOffsets.add(offset + 1);
                    oldOffsets.add(newOffset);
                    newOffsets.add(-1);
                    oldOffsets.add(offset + 1);
                    newOffsets.add(-1);
                }

                @Override
                public void visitInstruction(Instruction instruction, int offset, int nextOffset) {
                    int newOffset = offset + 1;
                    oldOffsets.add(offset);
                    newOffsets.add(newOffset);
                    oldOffsets.add(newOffset);
                    newOffsets.add(-1);
                }
            };
            while (!oldOffsets.isEmpty()) {
                offset = oldOffsets.remove(oldOffsets.size() - 1);
                int newOffset = newOffsets.remove(newOffsets.size() - 1);
                if (offset >= endOffset) continue;
                Instruction instruction = instructions.get(offset);
                if (clientVisitor.processedInstructions[offset]) {
                    if (newOffset != -1) {
                        instruction.accept(clientVisitor, offset, newOffset);
                    }
                    if (currentProcedureReturnOffsets.isEmpty() || currentProcedureReturnOffsets.get(currentProcedureReturnOffsets.size() - 1) - 1 != offset) continue;
                    currentProcedureReturnOffsets.remove(currentProcedureReturnOffsets.size() - 1);
                    continue;
                }
                if (!currentProcedureReturnOffsets.isEmpty()) {
                    int returnOffset = currentProcedureReturnOffsets.get(currentProcedureReturnOffsets.size() - 1);
                    CallInstruction callInstruction = (CallInstruction)instructions.get(returnOffset - 1);
                    ControlFlowStack controlFlowStack = callInstruction.stack;
                    synchronized (controlFlowStack) {
                        if (callInstruction.procBegin <= offset && offset < callInstruction.procEnd + 2 && (callInstruction.stack.size() == 0 || callInstruction.stack.peekReturnOffset() != returnOffset)) {
                            callInstruction.stack.push(returnOffset, callInstruction);
                        }
                    }
                }
                clientVisitor.processedInstructions[offset] = true;
                instruction.accept(getNextOffsetVisitor, offset, newOffset);
            }
        }
    }

    private static boolean isInsideReturnStatement(PsiElement element) {
        while (element instanceof PsiExpression) {
            element = element.getParent();
        }
        return element instanceof PsiReturnStatement;
    }

    private static void merge(int offset, CopyOnWriteList source, CopyOnWriteList[] target) {
        if (source != null) {
            CopyOnWriteList existing = target[offset];
            target[offset] = existing == null ? source : existing.addAll(source);
        }
    }

    public static List<PsiReferenceExpression> getReadBeforeWriteLocals(ControlFlow flow) {
        ReadBeforeWriteClientVisitor visitor2 = new ReadBeforeWriteClientVisitor(flow, true);
        ControlFlowUtil.depthFirstSearch(flow, visitor2);
        return (List)((InstructionClientVisitor)visitor2).getResult();
    }

    public static List<PsiReferenceExpression> getReadBeforeWrite(ControlFlow flow) {
        ReadBeforeWriteClientVisitor visitor2 = new ReadBeforeWriteClientVisitor(flow, false);
        ControlFlowUtil.depthFirstSearch(flow, visitor2);
        return (List)((InstructionClientVisitor)visitor2).getResult();
    }

    public static int getCompletionReasons(final ControlFlow flow, final int offset, final int endOffset) {
        class MyVisitor
        extends InstructionClientVisitor<Integer> {
            final boolean[] normalCompletion;
            final boolean[] returnCalled;

            MyVisitor() {
                this.normalCompletion = new boolean[endOffset];
                this.returnCalled = new boolean[endOffset];
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset2, int nextOffset) {
                boolean goToReturn;
                boolean ret = nextOffset < endOffset && this.returnCalled[nextOffset];
                boolean normal = nextOffset < endOffset && this.normalCompletion[nextOffset];
                PsiElement element = flow.getElement(offset2);
                boolean bl = goToReturn = instruction instanceof GoToInstruction && ((GoToInstruction)instruction).isReturn;
                if (goToReturn || ControlFlowUtil.isInsideReturnStatement(element)) {
                    ret = true;
                } else if (instruction instanceof ConditionalThrowToInstruction) {
                    int throwOffset = ((ConditionalThrowToInstruction)instruction).offset;
                    boolean normalWhenThrow = throwOffset < endOffset && this.normalCompletion[throwOffset];
                    boolean normalWhenNotThrow = offset2 == endOffset - 1 || this.normalCompletion[offset2 + 1];
                    normal = normalWhenThrow || normalWhenNotThrow;
                } else if (!(instruction instanceof ThrowToInstruction) && nextOffset >= endOffset) {
                    normal = true;
                }
                int n = offset2;
                this.returnCalled[n] = this.returnCalled[n] | ret;
                int n2 = offset2;
                this.normalCompletion[n2] = this.normalCompletion[n2] | normal;
            }

            @Override
            public Integer getResult() {
                return (this.returnCalled[offset] ? 2 : 0) | (this.normalCompletion[offset] ? 1 : 0);
            }
        }
        MyVisitor visitor2 = new MyVisitor();
        ControlFlowUtil.depthFirstSearch(flow, visitor2, offset, endOffset);
        return visitor2.getResult();
    }

    @NotNull
    public static Collection<VariableInfo> getInitializedTwice(@NotNull ControlFlow flow) {
        if (flow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flow", "com/intellij/psi/controlFlow/ControlFlowUtil", "getInitializedTwice"));
        }
        Collection<VariableInfo> collection = ControlFlowUtil.getInitializedTwice(flow, 0, flow.getSize());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/ControlFlowUtil", "getInitializedTwice"));
        }
        return collection;
    }

    @NotNull
    public static Collection<VariableInfo> getInitializedTwice(@NotNull ControlFlow flow, int startOffset, int endOffset) {
        if (flow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flow", "com/intellij/psi/controlFlow/ControlFlowUtil", "getInitializedTwice"));
        }
        InitializedTwiceClientVisitor visitor2 = new InitializedTwiceClientVisitor(flow, startOffset);
        ControlFlowUtil.depthFirstSearch(flow, visitor2, startOffset, endOffset);
        Object object = visitor2.getResult();
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/ControlFlowUtil", "getInitializedTwice"));
        }
        return object;
    }

    public static boolean isInstructionReachable(ControlFlow flow, int instructionOffset, int startOffset) {
        class MyVisitor
        extends InstructionClientVisitor<Boolean> {
            boolean reachable;
            final /* synthetic */ int val$instructionOffset;

            MyVisitor(int n) {
                this.val$instructionOffset = n;
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset, int nextOffset) {
                if (nextOffset == this.val$instructionOffset) {
                    this.reachable = true;
                }
            }

            @Override
            public Boolean getResult() {
                return this.reachable;
            }
        }
        MyVisitor visitor2 = new MyVisitor(instructionOffset);
        ControlFlowUtil.depthFirstSearch(flow, visitor2, startOffset, flow.getSize());
        return visitor2.getResult();
    }

    public static boolean isVariableAssignedInLoop(@NotNull PsiReferenceExpression expression, PsiElement resolved) {
        ControlFlow flow;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/psi/controlFlow/ControlFlowUtil", "isVariableAssignedInLoop"));
        }
        if (!(expression.getParent() instanceof PsiAssignmentExpression) || ((PsiAssignmentExpression)expression.getParent()).getLExpression() != expression) {
            return false;
        }
        PsiExpression qualifier2 = expression.getQualifierExpression();
        if (qualifier2 != null && !(qualifier2 instanceof PsiThisExpression)) {
            return false;
        }
        if (!(resolved instanceof PsiVariable)) {
            return false;
        }
        PsiVariable variable = (PsiVariable)resolved;
        PsiElement codeBlock = PsiUtil.getVariableCodeBlock(variable, expression);
        if (codeBlock == null) {
            return false;
        }
        try {
            flow = ControlFlowFactory.getInstance(codeBlock.getProject()).getControlFlow(codeBlock, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance(), false);
        }
        catch (AnalysisCanceledException e) {
            return false;
        }
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression.getParent();
        int startOffset = flow.getStartOffset(assignmentExpression);
        return startOffset != -1 && ControlFlowUtil.isInstructionReachable(flow, startOffset, startOffset);
    }

    private static class InitializedTwiceClientVisitor
    extends InstructionClientVisitor<Collection<VariableInfo>> {
        private final CopyOnWriteList[] writtenVariables;
        private final CopyOnWriteList[] writtenTwiceVariables;
        private final ControlFlow myFlow;
        private final int myStartOffset;

        public InitializedTwiceClientVisitor(@NotNull ControlFlow flow, int startOffset) {
            if (flow == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flow", "com/intellij/psi/controlFlow/ControlFlowUtil$InitializedTwiceClientVisitor", "<init>"));
            }
            this.myFlow = flow;
            this.myStartOffset = startOffset;
            this.writtenVariables = new CopyOnWriteList[this.myFlow.getSize() + 1];
            this.writtenTwiceVariables = new CopyOnWriteList[this.myFlow.getSize() + 1];
        }

        @Override
        public void visitInstruction(Instruction instruction, int offset, int nextOffset) {
            int safeNextOffset = Math.min(nextOffset, this.myFlow.getSize());
            CopyOnWriteList writeVars = this.writtenVariables[safeNextOffset];
            CopyOnWriteList writeTwiceVars = this.writtenTwiceVariables[safeNextOffset];
            if (instruction instanceof WriteVariableInstruction) {
                PsiVariable variable = ((WriteVariableInstruction)instruction).variable;
                PsiElement latestWriteVarExpression = InitializedTwiceClientVisitor.getLatestWriteVarExpression(writeVars, variable);
                if (latestWriteVarExpression == null) {
                    PsiElement expression = InitializedTwiceClientVisitor.getExpression(this.myFlow.getElement(offset));
                    writeVars = CopyOnWriteList.add(writeVars, new VariableInfo(variable, expression));
                } else {
                    writeTwiceVars = CopyOnWriteList.add(writeTwiceVars, new VariableInfo(variable, latestWriteVarExpression));
                }
            }
            ControlFlowUtil.merge(offset, writeVars, this.writtenVariables);
            ControlFlowUtil.merge(offset, writeTwiceVars, this.writtenTwiceVariables);
        }

        @Nullable
        private static PsiElement getExpression(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/controlFlow/ControlFlowUtil$InitializedTwiceClientVisitor", "getExpression"));
            }
            if (element instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)element).getLExpression() instanceof PsiReferenceExpression) {
                return ((PsiAssignmentExpression)element).getLExpression();
            }
            if (element instanceof PsiPostfixExpression) {
                return ((PsiPostfixExpression)element).getOperand();
            }
            if (element instanceof PsiPrefixExpression) {
                return ((PsiPrefixExpression)element).getOperand();
            }
            if (element instanceof PsiDeclarationStatement) {
                return element;
            }
            return null;
        }

        @Nullable
        private static PsiElement getLatestWriteVarExpression(@Nullable CopyOnWriteList writeVars, @Nullable PsiVariable variable) {
            if (writeVars == null) {
                return null;
            }
            for (VariableInfo variableInfo : writeVars.getList()) {
                if (variableInfo.variable != variable) continue;
                return variableInfo.expression;
            }
            return null;
        }

        @Override
        @NotNull
        public Collection<VariableInfo> getResult() {
            CopyOnWriteList writtenTwiceVariable = this.writtenTwiceVariables[this.myStartOffset];
            if (writtenTwiceVariable == null) {
                List<VariableInfo> list2 = Collections.emptyList();
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/ControlFlowUtil$InitializedTwiceClientVisitor", "getResult"));
                }
                return list2;
            }
            List<VariableInfo> list3 = writtenTwiceVariable.getList();
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/ControlFlowUtil$InitializedTwiceClientVisitor", "getResult"));
            }
            return list3;
        }
    }

    private static class ReadBeforeWriteClientVisitor
    extends InstructionClientVisitor<List<PsiReferenceExpression>> {
        private final CopyOnWriteList[] readVariables;
        private final ControlFlow myFlow;
        private final boolean localVariablesOnly;

        public ReadBeforeWriteClientVisitor(ControlFlow flow, boolean localVariablesOnly) {
            this.myFlow = flow;
            this.localVariablesOnly = localVariablesOnly;
            this.readVariables = new CopyOnWriteList[this.myFlow.getSize() + 1];
        }

        @Override
        public void visitReadVariableInstruction(ReadVariableInstruction instruction, int offset, int nextOffset) {
            PsiReferenceExpression expression;
            CopyOnWriteList readVars = this.readVariables[Math.min(nextOffset, this.myFlow.getSize())];
            PsiVariable variable = instruction.variable;
            if (!(this.localVariablesOnly && ReadBeforeWriteClientVisitor.isMethodParameter(variable) || (expression = ControlFlowUtil.getEnclosingReferenceExpression(this.myFlow.getElement(offset), variable)) == null)) {
                readVars = CopyOnWriteList.add(readVars, new VariableInfo(variable, expression));
            }
            ControlFlowUtil.merge(offset, readVars, this.readVariables);
        }

        @Override
        public void visitWriteVariableInstruction(WriteVariableInstruction instruction, int offset, int nextOffset) {
            CopyOnWriteList readVars = this.readVariables[Math.min(nextOffset, this.myFlow.getSize())];
            if (readVars == null) {
                return;
            }
            PsiVariable variable = instruction.variable;
            if (!this.localVariablesOnly || !ReadBeforeWriteClientVisitor.isMethodParameter(variable)) {
                readVars = readVars.remove(new VariableInfo(variable, null));
            }
            ControlFlowUtil.merge(offset, readVars, this.readVariables);
        }

        private static boolean isMethodParameter(@NotNull PsiVariable variable) {
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/psi/controlFlow/ControlFlowUtil$ReadBeforeWriteClientVisitor", "isMethodParameter"));
            }
            if (variable instanceof PsiParameter) {
                PsiParameter parameter = (PsiParameter)variable;
                return !(parameter.getDeclarationScope() instanceof PsiForeachStatement);
            }
            return false;
        }

        @Override
        public void visitInstruction(Instruction instruction, int offset, int nextOffset) {
            ControlFlowUtil.merge(offset, this.readVariables[Math.min(nextOffset, this.myFlow.getSize())], this.readVariables);
        }

        @Override
        public void visitCallInstruction(CallInstruction instruction, int offset, int nextOffset) {
            this.visitInstruction(instruction, offset, nextOffset);
            for (int i = instruction.procBegin; i <= instruction.procEnd; ++i) {
                this.readVariables[i] = null;
            }
        }

        @Override
        public List<PsiReferenceExpression> getResult() {
            CopyOnWriteList topReadVariables = this.readVariables[0];
            if (topReadVariables == null) {
                return Collections.emptyList();
            }
            ArrayList<PsiReferenceExpression> result2 = new ArrayList<PsiReferenceExpression>();
            List<VariableInfo> list2 = topReadVariables.getList();
            for (VariableInfo variableInfo : list2) {
                result2.add((PsiReferenceExpression)variableInfo.expression);
            }
            return result2;
        }
    }

    public static class VariableInfo {
        private final PsiVariable variable;
        public final PsiElement expression;

        public VariableInfo(PsiVariable variable, PsiElement expression) {
            this.variable = variable;
            this.expression = expression;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof VariableInfo && this.variable.equals(((VariableInfo)o).variable);
        }

        public int hashCode() {
            return this.variable.hashCode();
        }
    }

    private static class CopyOnWriteList {
        private final List<VariableInfo> list;

        public CopyOnWriteList add(VariableInfo value) {
            CopyOnWriteList newList = new CopyOnWriteList();
            List<VariableInfo> list2 = this.getList();
            for (VariableInfo variableInfo : list2) {
                if (value.equals(variableInfo)) continue;
                newList.list.add(variableInfo);
            }
            newList.list.add(value);
            return newList;
        }

        public CopyOnWriteList remove(VariableInfo value) {
            CopyOnWriteList newList = new CopyOnWriteList();
            List<VariableInfo> list2 = this.getList();
            for (VariableInfo variableInfo : list2) {
                if (value.equals(variableInfo)) continue;
                newList.list.add(variableInfo);
            }
            return newList;
        }

        @NotNull
        public List<VariableInfo> getList() {
            List<VariableInfo> list2 = this.list;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/ControlFlowUtil$CopyOnWriteList", "getList"));
            }
            return list2;
        }

        public CopyOnWriteList() {
            this(Collections.emptyList());
        }

        public CopyOnWriteList(VariableInfo ... infos) {
            this(Arrays.asList(infos));
        }

        public CopyOnWriteList(Collection<VariableInfo> infos) {
            this.list = new LinkedList<VariableInfo>(infos);
        }

        public CopyOnWriteList addAll(CopyOnWriteList addList) {
            CopyOnWriteList newList = new CopyOnWriteList();
            List<VariableInfo> list2 = this.getList();
            for (VariableInfo variableInfo : list2) {
                newList.list.add(variableInfo);
            }
            List<VariableInfo> toAdd = addList.getList();
            for (VariableInfo variableInfo : toAdd) {
                if (newList.list.contains(variableInfo)) continue;
                newList.list.add(variableInfo);
            }
            return newList;
        }

        public static CopyOnWriteList add(@Nullable CopyOnWriteList list2, @NotNull VariableInfo value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/controlFlow/ControlFlowUtil$CopyOnWriteList", "add"));
            }
            return list2 == null ? new CopyOnWriteList(value) : list2.add(value);
        }
    }

    private static class UnreachableStatementClientVisitor
    extends InstructionClientVisitor<PsiElement> {
        private final ControlFlow myFlow;

        public UnreachableStatementClientVisitor(ControlFlow flow) {
            this.myFlow = flow;
        }

        @Override
        public PsiElement getResult() {
            for (int i = 0; i < this.processedInstructions.length; ++i) {
                int startOffset;
                int endOffset;
                PsiElement element;
                if (this.processedInstructions[i] || (element = this.myFlow.getElement(i)) == null || !PsiUtil.isStatement(element) || element.getParent() instanceof PsiExpression) continue;
                while (element instanceof PsiExpression) {
                    element = element.getParent();
                }
                if (element instanceof PsiStatement && element.getParent() instanceof PsiForStatement && element == ((PsiForStatement)element.getParent()).getUpdate() || (endOffset = this.myFlow.getEndOffset(element)) != i + 1 || 0 <= (startOffset = this.myFlow.getStartOffset(element)) && startOffset < this.processedInstructions.length && this.processedInstructions[startOffset]) continue;
                return element;
            }
            return null;
        }
    }

    private static class ReturnPresentClientVisitor
    extends InstructionClientVisitor<Boolean> {
        private final boolean[] isNormalCompletion;
        protected final ControlFlow myFlow;

        public ReturnPresentClientVisitor(ControlFlow flow) {
            this.myFlow = flow;
            this.isNormalCompletion = new boolean[this.myFlow.getSize() + 1];
            this.isNormalCompletion[this.myFlow.getSize()] = true;
        }

        @Override
        public void visitConditionalThrowToInstruction(ConditionalThrowToInstruction instruction, int offset, int nextOffset) {
            if (nextOffset > this.myFlow.getSize()) {
                nextOffset = this.myFlow.getSize();
            }
            boolean isNormal = instruction.offset == nextOffset && nextOffset != offset + 1 ? !this.isLeaf(nextOffset) && this.isNormalCompletion[nextOffset] : this.isLeaf(nextOffset) || this.isNormalCompletion[nextOffset];
            int n = offset;
            this.isNormalCompletion[n] = this.isNormalCompletion[n] | isNormal;
        }

        @Override
        public void visitThrowToInstruction(ThrowToInstruction instruction, int offset, int nextOffset) {
            if (nextOffset > this.myFlow.getSize()) {
                nextOffset = this.myFlow.getSize();
            }
            int n = offset;
            this.isNormalCompletion[n] = this.isNormalCompletion[n] | (!this.isLeaf(nextOffset) && this.isNormalCompletion[nextOffset]);
        }

        @Override
        public void visitGoToInstruction(GoToInstruction instruction, int offset, int nextOffset) {
            if (nextOffset > this.myFlow.getSize()) {
                nextOffset = this.myFlow.getSize();
            }
            int n = offset;
            this.isNormalCompletion[n] = this.isNormalCompletion[n] | (!instruction.isReturn && this.isNormalCompletion[nextOffset]);
        }

        @Override
        public void visitInstruction(Instruction instruction, int offset, int nextOffset) {
            if (nextOffset > this.myFlow.getSize()) {
                nextOffset = this.myFlow.getSize();
            }
            boolean isNormal = this.isLeaf(nextOffset) || this.isNormalCompletion[nextOffset];
            int n = offset;
            this.isNormalCompletion[n] = this.isNormalCompletion[n] | isNormal;
        }

        @Override
        public Boolean getResult() {
            return !this.isNormalCompletion[0];
        }
    }

    private static class ConvertReturnClientVisitor
    extends ReturnPresentClientVisitor {
        private final List<PsiReturnStatement> myAffectedReturns = new ArrayList<PsiReturnStatement>();
        private final ReturnStatementsVisitor myVisitor;

        ConvertReturnClientVisitor(ControlFlow flow, ReturnStatementsVisitor visitor2) {
            super(flow);
            this.myVisitor = visitor2;
        }

        @Override
        public void visitGoToInstruction(GoToInstruction instruction, int offset, int nextOffset) {
            PsiElement element;
            super.visitGoToInstruction(instruction, offset, nextOffset);
            if (instruction.isReturn && (element = this.myFlow.getElement(offset)) instanceof PsiReturnStatement) {
                PsiReturnStatement returnStatement = (PsiReturnStatement)element;
                this.myAffectedReturns.add(returnStatement);
            }
        }

        public void afterProcessing() throws IncorrectOperationException {
            this.myVisitor.visit(this.myAffectedReturns);
        }
    }

    private static class SSAInstructionState
    implements Cloneable {
        private final int myWriteCount;
        private final int myInstructionIdx;

        public SSAInstructionState(int writeCount, int instructionIdx) {
            this.myWriteCount = writeCount;
            this.myInstructionIdx = instructionIdx;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SSAInstructionState)) {
                return false;
            }
            SSAInstructionState ssaInstructionState = (SSAInstructionState)o;
            if (this.myInstructionIdx != ssaInstructionState.myInstructionIdx) {
                return false;
            }
            return Math.min(2, this.myWriteCount) == Math.min(2, ssaInstructionState.myWriteCount);
        }

        public int hashCode() {
            int result2 = Math.min(2, this.myWriteCount);
            result2 = 29 * result2 + this.myInstructionIdx;
            return result2;
        }

        public int getWriteCount() {
            return this.myWriteCount;
        }

        public int getInstructionIdx() {
            return this.myInstructionIdx;
        }
    }
}

