/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import com.google.common.collect.Lists;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtConstructorDelegationReferenceExpression;
import org.jetbrains.kotlin.psi.KtElementImpl;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtProjectionKind;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DelegatingBindingTrace;
import org.jetbrains.kotlin.resolve.DeprecationUtilKt;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ModifierCheckerCore;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallCompleter;
import org.jetbrains.kotlin.resolve.calls.CallTransformer;
import org.jetbrains.kotlin.resolve.calls.CandidateResolver;
import org.jetbrains.kotlin.resolve.calls.GenericCandidateResolver;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.ResolveArgumentsMode;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CallCandidateResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CandidateResolveMode;
import org.jetbrains.kotlin.resolve.calls.context.CheckArgumentTypesMode;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.kotlin.resolve.calls.results.ResolutionResultsHandler;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.tasks.ResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.tasks.ResolutionTask;
import org.jetbrains.kotlin.resolve.calls.tasks.TaskPrioritizer;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategyForImplicitConstructorDelegationCall;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategyForInvoke;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategyImpl;
import org.jetbrains.kotlin.resolve.calls.tasks.collectors.CallableDescriptorCollectors;
import org.jetbrains.kotlin.resolve.calls.tower.NewResolveOldInference;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingVisitorDispatcher;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.kotlin.util.PerformanceCounter;

public class CallResolver {
    private ExpressionTypingServices expressionTypingServices;
    private TypeResolver typeResolver;
    private CandidateResolver candidateResolver;
    private ArgumentTypeResolver argumentTypeResolver;
    private GenericCandidateResolver genericCandidateResolver;
    private CallCompleter callCompleter;
    private NewResolveOldInference newCallResolver;
    private final TaskPrioritizer taskPrioritizer;
    private final ResolutionResultsHandler resolutionResultsHandler;
    @NotNull
    private KotlinBuiltIns builtIns;
    private static final PerformanceCounter callResolvePerfCounter = PerformanceCounter.Companion.create("Call resolve", ExpressionTypingVisitorDispatcher.typeInfoPerfCounter);
    private static final PerformanceCounter candidatePerfCounter = PerformanceCounter.Companion.create("Call resolve candidate analysis", true);
    public static boolean useNewResolve = !"false".equals(System.getProperty("kotlin.internal.new_resolve"));

    public CallResolver(@NotNull TaskPrioritizer taskPrioritizer, @NotNull ResolutionResultsHandler resolutionResultsHandler, @NotNull KotlinBuiltIns builtIns) {
        if (taskPrioritizer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskPrioritizer", "org/jetbrains/kotlin/resolve/calls/CallResolver", "<init>"));
        }
        if (resolutionResultsHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolutionResultsHandler", "org/jetbrains/kotlin/resolve/calls/CallResolver", "<init>"));
        }
        if (builtIns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builtIns", "org/jetbrains/kotlin/resolve/calls/CallResolver", "<init>"));
        }
        this.taskPrioritizer = taskPrioritizer;
        this.resolutionResultsHandler = resolutionResultsHandler;
        this.builtIns = builtIns;
    }

    @Inject
    public void setExpressionTypingServices(@NotNull ExpressionTypingServices expressionTypingServices) {
        if (expressionTypingServices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionTypingServices", "org/jetbrains/kotlin/resolve/calls/CallResolver", "setExpressionTypingServices"));
        }
        this.expressionTypingServices = expressionTypingServices;
    }

    @Inject
    public void setTypeResolver(@NotNull TypeResolver typeResolver) {
        if (typeResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeResolver", "org/jetbrains/kotlin/resolve/calls/CallResolver", "setTypeResolver"));
        }
        this.typeResolver = typeResolver;
    }

    @Inject
    public void setCandidateResolver(@NotNull CandidateResolver candidateResolver) {
        if (candidateResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateResolver", "org/jetbrains/kotlin/resolve/calls/CallResolver", "setCandidateResolver"));
        }
        this.candidateResolver = candidateResolver;
    }

    @Inject
    public void setArgumentTypeResolver(@NotNull ArgumentTypeResolver argumentTypeResolver) {
        if (argumentTypeResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentTypeResolver", "org/jetbrains/kotlin/resolve/calls/CallResolver", "setArgumentTypeResolver"));
        }
        this.argumentTypeResolver = argumentTypeResolver;
    }

    @Inject
    public void setGenericCandidateResolver(GenericCandidateResolver genericCandidateResolver) {
        this.genericCandidateResolver = genericCandidateResolver;
    }

    @Inject
    public void setCallCompleter(@NotNull CallCompleter callCompleter) {
        if (callCompleter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callCompleter", "org/jetbrains/kotlin/resolve/calls/CallResolver", "setCallCompleter"));
        }
        this.callCompleter = callCompleter;
    }

    @Inject
    public void setCallCompleter(@NotNull NewResolveOldInference newCallResolver) {
        if (newCallResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newCallResolver", "org/jetbrains/kotlin/resolve/calls/CallResolver", "setCallCompleter"));
        }
        this.newCallResolver = newCallResolver;
    }

    @NotNull
    public OverloadResolutionResults<VariableDescriptor> resolveSimpleProperty(@NotNull BasicCallResolutionContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveSimpleProperty"));
        }
        KtExpression calleeExpression = context.call.getCalleeExpression();
        assert (calleeExpression instanceof KtSimpleNameExpression);
        KtSimpleNameExpression nameExpression = (KtSimpleNameExpression)calleeExpression;
        Name referencedName = nameExpression.getReferencedNameAsName();
        CallableDescriptorCollectors<VariableDescriptor> callableDescriptorCollectors = CallableDescriptorCollectors.VARIABLES;
        OverloadResolutionResults<VariableDescriptor> overloadResolutionResults = this.computeTasksAndResolveCall(context, referencedName, nameExpression, callableDescriptorCollectors, CallTransformer.VARIABLE_CALL_TRANSFORMER, ResolveKind.VARIABLE);
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveSimpleProperty"));
        }
        return overloadResolutionResults;
    }

    @NotNull
    public OverloadResolutionResults<CallableDescriptor> resolveCallForMember(@NotNull KtSimpleNameExpression nameExpression, @NotNull BasicCallResolutionContext context) {
        if (nameExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameExpression", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveCallForMember"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveCallForMember"));
        }
        OverloadResolutionResults<CallableDescriptor> overloadResolutionResults = this.computeTasksAndResolveCall(context, nameExpression.getReferencedNameAsName(), nameExpression, CallableDescriptorCollectors.FUNCTIONS_AND_VARIABLES, CallTransformer.MEMBER_CALL_TRANSFORMER, ResolveKind.CALLABLE_REFERENCE);
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveCallForMember"));
        }
        return overloadResolutionResults;
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveCallWithGivenName(@NotNull ExpressionTypingContext context, @NotNull Call call, @NotNull KtReferenceExpression functionReference, @NotNull Name name) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveCallWithGivenName"));
        }
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveCallWithGivenName"));
        }
        if (functionReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionReference", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveCallWithGivenName"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveCallWithGivenName"));
        }
        BasicCallResolutionContext callResolutionContext = BasicCallResolutionContext.create(context, call, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS);
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.computeTasksAndResolveCall(callResolutionContext, name, functionReference, CallableDescriptorCollectors.FUNCTIONS_AND_VARIABLES, CallTransformer.FUNCTION_CALL_TRANSFORMER, ResolveKind.FUNCTION);
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveCallWithGivenName"));
        }
        return overloadResolutionResults;
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveCallForInvoke(@NotNull BasicCallResolutionContext context, @NotNull TracingStrategy tracing) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveCallForInvoke"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveCallForInvoke"));
        }
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.computeTasksAndResolveCall(context, OperatorNameConventions.INVOKE, tracing, CallableDescriptorCollectors.FUNCTIONS, CallTransformer.FUNCTION_CALL_TRANSFORMER, ResolveKind.INVOKE);
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveCallForInvoke"));
        }
        return overloadResolutionResults;
    }

    @NotNull
    private <D extends CallableDescriptor, F extends D> OverloadResolutionResults<F> computeTasksAndResolveCall(@NotNull BasicCallResolutionContext context, @NotNull Name name, @NotNull KtReferenceExpression referenceExpression, @NotNull CallableDescriptorCollectors<D> collectors, @NotNull CallTransformer<D, F> callTransformer, @NotNull ResolveKind kind) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksAndResolveCall"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksAndResolveCall"));
        }
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksAndResolveCall"));
        }
        if (collectors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collectors", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksAndResolveCall"));
        }
        if (callTransformer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callTransformer", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksAndResolveCall"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksAndResolveCall"));
        }
        TracingStrategy tracing = TracingStrategyImpl.create(referenceExpression, context.call);
        OverloadResolutionResults<F> overloadResolutionResults = this.computeTasksAndResolveCall(context, name, tracing, collectors, callTransformer, kind);
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksAndResolveCall"));
        }
        return overloadResolutionResults;
    }

    @NotNull
    private <D extends CallableDescriptor, F extends D> OverloadResolutionResults<F> computeTasksAndResolveCall(final @NotNull BasicCallResolutionContext context, final @NotNull Name name, final @NotNull TracingStrategy tracing, final @NotNull CallableDescriptorCollectors<D> collectors, final @NotNull CallTransformer<D, F> callTransformer, final @NotNull ResolveKind kind) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksAndResolveCall"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksAndResolveCall"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksAndResolveCall"));
        }
        if (collectors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collectors", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksAndResolveCall"));
        }
        if (callTransformer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callTransformer", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksAndResolveCall"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksAndResolveCall"));
        }
        OverloadResolutionResults overloadResolutionResults = (OverloadResolutionResults)callResolvePerfCounter.time(new Function0<OverloadResolutionResults<F>>(){

            @Override
            public OverloadResolutionResults<F> invoke() {
                TaskContextForMigration contextForMigration = new TaskContextForMigration(kind, callTransformer, name, null, new Function0<List<ResolutionTask<D, F>>>(){

                    @Override
                    public List<ResolutionTask<D, F>> invoke() {
                        return CallResolver.this.taskPrioritizer.computePrioritizedTasks(context, name, tracing, collectors);
                    }
                });
                return CallResolver.this.doResolveCallOrGetCachedResults(context, contextForMigration, tracing);
            }
        });
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksAndResolveCall"));
        }
        return overloadResolutionResults;
    }

    @NotNull
    private <D extends CallableDescriptor, F extends D> OverloadResolutionResults<F> computeTasksFromCandidatesAndResolvedCall(@NotNull BasicCallResolutionContext context, @NotNull KtReferenceExpression referenceExpression, @NotNull Collection<ResolutionCandidate<D>> candidates, @NotNull CallTransformer<D, F> callTransformer) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksFromCandidatesAndResolvedCall"));
        }
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksFromCandidatesAndResolvedCall"));
        }
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksFromCandidatesAndResolvedCall"));
        }
        if (callTransformer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callTransformer", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksFromCandidatesAndResolvedCall"));
        }
        OverloadResolutionResults<F> overloadResolutionResults = this.computeTasksFromCandidatesAndResolvedCall(context, candidates, callTransformer, TracingStrategyImpl.create(referenceExpression, context.call));
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksFromCandidatesAndResolvedCall"));
        }
        return overloadResolutionResults;
    }

    @NotNull
    private <D extends CallableDescriptor, F extends D> OverloadResolutionResults<F> computeTasksFromCandidatesAndResolvedCall(final @NotNull BasicCallResolutionContext context, final @NotNull Collection<ResolutionCandidate<D>> candidates, final @NotNull CallTransformer<D, F> callTransformer, final @NotNull TracingStrategy tracing) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksFromCandidatesAndResolvedCall"));
        }
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksFromCandidatesAndResolvedCall"));
        }
        if (callTransformer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callTransformer", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksFromCandidatesAndResolvedCall"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksFromCandidatesAndResolvedCall"));
        }
        OverloadResolutionResults overloadResolutionResults = (OverloadResolutionResults)callResolvePerfCounter.time(new Function0<OverloadResolutionResults<F>>(){

            @Override
            public OverloadResolutionResults<F> invoke() {
                TaskContextForMigration contextForMigration = new TaskContextForMigration(ResolveKind.GIVEN_CANDIDATES, callTransformer, null, candidates, new Function0<List<ResolutionTask<D, F>>>(){

                    @Override
                    public List<ResolutionTask<D, F>> invoke() {
                        return CallResolver.this.taskPrioritizer.computePrioritizedTasksFromCandidates(context, candidates, tracing);
                    }
                });
                return CallResolver.this.doResolveCallOrGetCachedResults(context, contextForMigration, tracing);
            }
        });
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksFromCandidatesAndResolvedCall"));
        }
        return overloadResolutionResults;
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveBinaryCall(ExpressionTypingContext context, ExpressionReceiver receiver, KtBinaryExpression binaryExpression, Name name) {
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.resolveCallWithGivenName(context, CallMaker.makeCall((ReceiverValue)receiver, binaryExpression), binaryExpression.getOperationReference(), name);
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveBinaryCall"));
        }
        return overloadResolutionResults;
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveFunctionCall(@NotNull BindingTrace trace, @NotNull LexicalScope scope2, @NotNull Call call, @NotNull KotlinType expectedType, @NotNull DataFlowInfo dataFlowInfo, boolean isAnnotationContext) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveFunctionCall"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveFunctionCall"));
        }
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveFunctionCall"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveFunctionCall"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveFunctionCall"));
        }
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.resolveFunctionCall(BasicCallResolutionContext.create(trace, scope2, call, expectedType, dataFlowInfo, ContextDependency.INDEPENDENT, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS, CallChecker.DoNothing.INSTANCE, isAnnotationContext));
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveFunctionCall"));
        }
        return overloadResolutionResults;
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveFunctionCall(@NotNull BasicCallResolutionContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveFunctionCall"));
        }
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        Call.CallType callType = context.call.getCallType();
        if (callType == Call.CallType.ARRAY_GET_METHOD || callType == Call.CallType.ARRAY_SET_METHOD) {
            Name name = Name.identifier(callType == Call.CallType.ARRAY_GET_METHOD ? "get" : "set");
            KtArrayAccessExpression arrayAccessExpression = (KtArrayAccessExpression)context.call.getCallElement();
            OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.computeTasksAndResolveCall(context, name, arrayAccessExpression, CallableDescriptorCollectors.FUNCTIONS_AND_VARIABLES, CallTransformer.FUNCTION_CALL_TRANSFORMER, ResolveKind.FUNCTION);
            if (overloadResolutionResults == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveFunctionCall"));
            }
            return overloadResolutionResults;
        }
        KtExpression calleeExpression = context.call.getCalleeExpression();
        if (calleeExpression instanceof KtSimpleNameExpression) {
            KtSimpleNameExpression expression = (KtSimpleNameExpression)calleeExpression;
            OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.computeTasksAndResolveCall(context, expression.getReferencedNameAsName(), expression, CallableDescriptorCollectors.FUNCTIONS_AND_VARIABLES, CallTransformer.FUNCTION_CALL_TRANSFORMER, ResolveKind.FUNCTION);
            if (overloadResolutionResults == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveFunctionCall"));
            }
            return overloadResolutionResults;
        }
        if (calleeExpression instanceof KtConstructorCalleeExpression) {
            OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.resolveCallForConstructor(context, (KtConstructorCalleeExpression)calleeExpression);
            if (overloadResolutionResults == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveFunctionCall"));
            }
            return overloadResolutionResults;
        }
        if (calleeExpression instanceof KtConstructorDelegationReferenceExpression) {
            KtConstructorDelegationCall delegationCall = (KtConstructorDelegationCall)context.call.getCallElement();
            DeclarationDescriptor container = context.scope.getOwnerDescriptor();
            assert (container instanceof ConstructorDescriptor) : "Trying to resolve JetConstructorDelegationCall not in constructor. scope.ownerDescriptor = " + container;
            OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.resolveConstructorDelegationCall(context, delegationCall, (KtConstructorDelegationReferenceExpression)calleeExpression, (ConstructorDescriptor)container);
            if (overloadResolutionResults == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveFunctionCall"));
            }
            return overloadResolutionResults;
        }
        if (calleeExpression == null) {
            OverloadResolutionResultsImpl<FunctionDescriptor> overloadResolutionResultsImpl = this.checkArgumentTypesAndFail(context);
            if (overloadResolutionResultsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveFunctionCall"));
            }
            return overloadResolutionResultsImpl;
        }
        KotlinType expectedType = TypeUtils.NO_EXPECTED_TYPE;
        if (calleeExpression instanceof KtLambdaExpression) {
            int parameterNumber = ((KtLambdaExpression)calleeExpression).getValueParameters().size();
            ArrayList<KotlinType> parameterTypes = new ArrayList<KotlinType>(parameterNumber);
            for (int i = 0; i < parameterNumber; ++i) {
                parameterTypes.add(TypeUtils.NO_EXPECTED_TYPE);
            }
            expectedType = this.builtIns.getFunctionType(Annotations.Companion.getEMPTY(), null, parameterTypes, context.expectedType);
        }
        KotlinType calleeType = this.expressionTypingServices.safeGetType(context.scope, calleeExpression, expectedType, context.dataFlowInfo, context.trace);
        ExpressionReceiver expressionReceiver = ExpressionReceiver.Companion.create(calleeExpression, calleeType, context.trace.getBindingContext());
        CallTransformer.CallForImplicitInvoke call = new CallTransformer.CallForImplicitInvoke(context.call.getExplicitReceiver(), expressionReceiver, context.call);
        TracingStrategyForInvoke tracingForInvoke = new TracingStrategyForInvoke(calleeExpression, call, calleeType);
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.resolveCallForInvoke(context.replaceCall(call), tracingForInvoke);
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveFunctionCall"));
        }
        return overloadResolutionResults;
    }

    private OverloadResolutionResults<FunctionDescriptor> resolveCallForConstructor(@NotNull BasicCallResolutionContext context, @NotNull KtConstructorCalleeExpression expression) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveCallForConstructor"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveCallForConstructor"));
        }
        assert (context.call.getExplicitReceiver() == null) : "Constructor can't be invoked with explicit receiver: " + context.call.getCallElement().getText();
        context.trace.record(BindingContext.LEXICAL_SCOPE, context.call.getCallElement(), context.scope);
        KtSimpleNameExpression functionReference = expression.getConstructorReferenceExpression();
        KtTypeReference typeReference = expression.getTypeReference();
        if (functionReference == null || typeReference == null) {
            return this.checkArgumentTypesAndFail(context);
        }
        KotlinType constructedType = this.typeResolver.resolveType(context.scope, typeReference, context.trace, true);
        if (constructedType.isError()) {
            return this.checkArgumentTypesAndFail(context);
        }
        ClassifierDescriptor declarationDescriptor = constructedType.getConstructor().getDeclarationDescriptor();
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            context.trace.report(Errors.NOT_A_CLASS.on(expression));
            return this.checkArgumentTypesAndFail(context);
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
        Collection<ConstructorDescriptor> constructors2 = classDescriptor.getConstructors();
        if (constructors2.isEmpty()) {
            context.trace.report(Errors.NO_CONSTRUCTOR.on(CallUtilKt.getValueArgumentListOrElement(context.call)));
            return this.checkArgumentTypesAndFail(context);
        }
        TypeSubstitutor knownSubstitutor = TypeSubstitutor.create(constructedType);
        Collection candidates = this.taskPrioritizer.convertWithImpliedThisAndNoReceiver(context.scope, constructors2, context.call, knownSubstitutor);
        return this.computeTasksFromCandidatesAndResolvedCall(context, functionReference, candidates, CallTransformer.FUNCTION_CALL_TRANSFORMER);
    }

    @Nullable
    public OverloadResolutionResults<FunctionDescriptor> resolveConstructorDelegationCall(@NotNull BindingTrace trace, @NotNull LexicalScope scope2, @NotNull DataFlowInfo dataFlowInfo, @NotNull ConstructorDescriptor constructorDescriptor, @NotNull KtConstructorDelegationCall call) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveConstructorDelegationCall"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveConstructorDelegationCall"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveConstructorDelegationCall"));
        }
        if (constructorDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorDescriptor", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveConstructorDelegationCall"));
        }
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveConstructorDelegationCall"));
        }
        BasicCallResolutionContext context = BasicCallResolutionContext.create(trace, scope2, CallMaker.makeCall(null, null, call), TypeUtils.NO_EXPECTED_TYPE, dataFlowInfo, ContextDependency.INDEPENDENT, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS, CallChecker.DoNothing.INSTANCE, false);
        if (call.getCalleeExpression() == null) {
            return this.checkArgumentTypesAndFail(context);
        }
        if (constructorDescriptor.getContainingDeclaration().getKind() == ClassKind.ENUM_CLASS && call.isImplicit()) {
            return null;
        }
        return this.resolveConstructorDelegationCall(context, call, call.getCalleeExpression(), constructorDescriptor);
    }

    @NotNull
    private OverloadResolutionResults<FunctionDescriptor> resolveConstructorDelegationCall(@NotNull BasicCallResolutionContext context, @NotNull KtConstructorDelegationCall call, @NotNull KtConstructorDelegationReferenceExpression calleeExpression, @NotNull ConstructorDescriptor calleeConstructor) {
        KtElementImpl reportOn;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveConstructorDelegationCall"));
        }
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveConstructorDelegationCall"));
        }
        if (calleeExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "calleeExpression", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveConstructorDelegationCall"));
        }
        if (calleeConstructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "calleeConstructor", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveConstructorDelegationCall"));
        }
        context.trace.record(BindingContext.LEXICAL_SCOPE, call, context.scope);
        ClassDescriptor currentClassDescriptor = calleeConstructor.getContainingDeclaration();
        boolean isThisCall = calleeExpression.isThis();
        if (currentClassDescriptor.getKind() == ClassKind.ENUM_CLASS && !isThisCall) {
            context.trace.report(Errors.DELEGATION_SUPER_CALL_IN_ENUM_CONSTRUCTOR.on(calleeExpression));
            OverloadResolutionResultsImpl<FunctionDescriptor> overloadResolutionResultsImpl = this.checkArgumentTypesAndFail(context);
            if (overloadResolutionResultsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveConstructorDelegationCall"));
            }
            return overloadResolutionResultsImpl;
        }
        ClassDescriptor delegateClassDescriptor = isThisCall ? currentClassDescriptor : DescriptorUtilsKt.getSuperClassOrAny(currentClassDescriptor);
        Collection<ConstructorDescriptor> constructors2 = delegateClassDescriptor.getConstructors();
        if (!isThisCall && currentClassDescriptor.getUnsubstitutedPrimaryConstructor() != null) {
            if (DescriptorUtils.canHaveDeclaredConstructors(currentClassDescriptor)) {
                context.trace.report(Errors.PRIMARY_CONSTRUCTOR_DELEGATION_CALL_EXPECTED.on((KtConstructorDelegationCall)calleeExpression.getParent()));
            }
            if (call.isImplicit()) {
                OverloadResolutionResultsImpl<FunctionDescriptor> overloadResolutionResultsImpl = OverloadResolutionResultsImpl.nameNotFound();
                if (overloadResolutionResultsImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveConstructorDelegationCall"));
                }
                return overloadResolutionResultsImpl;
            }
        }
        if (constructors2.isEmpty()) {
            context.trace.report(Errors.NO_CONSTRUCTOR.on(CallUtilKt.getValueArgumentListOrElement(context.call)));
            OverloadResolutionResultsImpl<FunctionDescriptor> overloadResolutionResultsImpl = this.checkArgumentTypesAndFail(context);
            if (overloadResolutionResultsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveConstructorDelegationCall"));
            }
            return overloadResolutionResultsImpl;
        }
        KotlinType superType = isThisCall ? calleeConstructor.getContainingDeclaration().getDefaultType() : DescriptorUtils.getSuperClassType(currentClassDescriptor);
        TypeSubstitutor knownTypeParametersSubstitutor = TypeSubstitutor.create(superType);
        Collection candidates = this.taskPrioritizer.convertWithImpliedThisAndNoReceiver(context.scope, constructors2, context.call, knownTypeParametersSubstitutor);
        TracingStrategy tracing = call.isImplicit() ? new TracingStrategyForImplicitConstructorDelegationCall(call, context.call) : TracingStrategyImpl.create(calleeExpression, context.call);
        KtElementImpl ktElementImpl = reportOn = call.isImplicit() ? call : calleeExpression;
        if (delegateClassDescriptor.isInner() && !DescriptorResolver.checkHasOuterClassInstance(context.scope, context.trace, reportOn, (ClassDescriptor)delegateClassDescriptor.getContainingDeclaration())) {
            OverloadResolutionResultsImpl<FunctionDescriptor> overloadResolutionResultsImpl = this.checkArgumentTypesAndFail(context);
            if (overloadResolutionResultsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveConstructorDelegationCall"));
            }
            return overloadResolutionResultsImpl;
        }
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.computeTasksFromCandidatesAndResolvedCall(context, candidates, CallTransformer.FUNCTION_CALL_TRANSFORMER, tracing);
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveConstructorDelegationCall"));
        }
        return overloadResolutionResults;
    }

    public OverloadResolutionResults<FunctionDescriptor> resolveCallWithKnownCandidate(final @NotNull Call call, final @NotNull TracingStrategy tracing, final @NotNull ResolutionContext<?> context, final @NotNull ResolutionCandidate<CallableDescriptor> candidate, final @Nullable MutableDataFlowInfoForArguments dataFlowInfoForArguments) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveCallWithKnownCandidate"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveCallWithKnownCandidate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveCallWithKnownCandidate"));
        }
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveCallWithKnownCandidate"));
        }
        return callResolvePerfCounter.time(new Function0<OverloadResolutionResults<FunctionDescriptor>>(){

            @Override
            public OverloadResolutionResults<FunctionDescriptor> invoke() {
                final BasicCallResolutionContext basicCallResolutionContext = BasicCallResolutionContext.create(context, call, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS, dataFlowInfoForArguments);
                final Set<ResolutionCandidate> candidates = Collections.singleton(candidate);
                TaskContextForMigration contextForMigration = new TaskContextForMigration(ResolveKind.GIVEN_CANDIDATES, CallTransformer.FUNCTION_CALL_TRANSFORMER, null, candidates, new Function0<List<ResolutionTask<CallableDescriptor, FunctionDescriptor>>>(){

                    @Override
                    public List<ResolutionTask<CallableDescriptor, FunctionDescriptor>> invoke() {
                        return CallResolver.this.taskPrioritizer.computePrioritizedTasksFromCandidates(basicCallResolutionContext, candidates, tracing);
                    }
                });
                return CallResolver.this.doResolveCallOrGetCachedResults(basicCallResolutionContext, contextForMigration, tracing);
            }
        });
    }

    private <D extends CallableDescriptor, F extends D> OverloadResolutionResultsImpl<F> doResolveCallOrGetCachedResults(@NotNull BasicCallResolutionContext context, @NotNull TaskContextForMigration<D, F> contextForMigration, @NotNull TracingStrategy tracing) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallResolver", "doResolveCallOrGetCachedResults"));
        }
        if (contextForMigration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextForMigration", "org/jetbrains/kotlin/resolve/calls/CallResolver", "doResolveCallOrGetCachedResults"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/kotlin/resolve/calls/CallResolver", "doResolveCallOrGetCachedResults"));
        }
        Call call = context.call;
        tracing.bindCall(context.trace, call);
        TemporaryBindingTrace traceToResolveCall = TemporaryBindingTrace.create(context.trace, "trace to resolve call", call);
        BasicCallResolutionContext newContext = (BasicCallResolutionContext)context.replaceBindingTrace(traceToResolveCall);
        BindingContextUtilsKt.recordScope(newContext.trace, newContext.scope, newContext.call.getCalleeExpression());
        BindingContextUtilsKt.recordDataFlowInfo(newContext, newContext.call.getCalleeExpression());
        OverloadResolutionResultsImpl<F> results = this.doResolveCall(newContext, contextForMigration, tracing);
        DelegatingBindingTrace deltasTraceForTypeInference = results.getTrace();
        if (deltasTraceForTypeInference != null) {
            deltasTraceForTypeInference.addOwnDataTo(traceToResolveCall);
        }
        this.completeTypeInferenceDependentOnFunctionLiterals(newContext, results, tracing);
        if (context.contextDependency == ContextDependency.DEPENDENT) {
            CallResolver.cacheResults(context, results, traceToResolveCall, tracing);
        }
        traceToResolveCall.commit();
        if (context.contextDependency == ContextDependency.INDEPENDENT) {
            results = this.callCompleter.completeCall(context, results, tracing);
        }
        return results;
    }

    private <D extends CallableDescriptor> void completeTypeInferenceDependentOnFunctionLiterals(@NotNull BasicCallResolutionContext context, @NotNull OverloadResolutionResultsImpl<D> results, @NotNull TracingStrategy tracing) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallResolver", "completeTypeInferenceDependentOnFunctionLiterals"));
        }
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "org/jetbrains/kotlin/resolve/calls/CallResolver", "completeTypeInferenceDependentOnFunctionLiterals"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/kotlin/resolve/calls/CallResolver", "completeTypeInferenceDependentOnFunctionLiterals"));
        }
        if (CallResolverUtilKt.isInvokeCallOnVariable(context.call)) {
            return;
        }
        if (!results.isSingleResult()) {
            if (results.getResultCode() == OverloadResolutionResults.Code.INCOMPLETE_TYPE_INFERENCE) {
                this.argumentTypeResolver.checkTypesWithNoCallee(context, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
            }
            return;
        }
        CallCandidateResolutionContext candidateContext = CallCandidateResolutionContext.createForCallBeingAnalyzed(results.getResultingCall(), context, tracing);
        this.genericCandidateResolver.completeTypeInferenceDependentOnFunctionArgumentsForCall(candidateContext);
    }

    private static <F extends CallableDescriptor> void cacheResults(@NotNull BasicCallResolutionContext context, @NotNull OverloadResolutionResultsImpl<F> results, @NotNull DelegatingBindingTrace traceToResolveCall, @NotNull TracingStrategy tracing) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallResolver", "cacheResults"));
        }
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "org/jetbrains/kotlin/resolve/calls/CallResolver", "cacheResults"));
        }
        if (traceToResolveCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traceToResolveCall", "org/jetbrains/kotlin/resolve/calls/CallResolver", "cacheResults"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/kotlin/resolve/calls/CallResolver", "cacheResults"));
        }
        Call call = context.call;
        if (CallResolverUtilKt.isInvokeCallOnVariable(call)) {
            return;
        }
        DelegatingBindingTrace deltasTraceToCacheResolve = new DelegatingBindingTrace(BindingContext.EMPTY, "delta trace for caching resolve of", context.call);
        traceToResolveCall.addOwnDataTo(deltasTraceToCacheResolve);
        context.resolutionResultsCache.record(call, results, context, tracing, deltasTraceToCacheResolve);
    }

    private <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> checkArgumentTypesAndFail(BasicCallResolutionContext context) {
        this.argumentTypeResolver.checkTypesWithNoCallee(context, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
        return OverloadResolutionResultsImpl.nameNotFound();
    }

    @NotNull
    private <D extends CallableDescriptor, F extends D> OverloadResolutionResultsImpl<F> doResolveCall(@NotNull BasicCallResolutionContext context, @NotNull TaskContextForMigration<D, F> contextForMigration, @NotNull TracingStrategy tracing) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallResolver", "doResolveCall"));
        }
        if (contextForMigration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextForMigration", "org/jetbrains/kotlin/resolve/calls/CallResolver", "doResolveCall"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/kotlin/resolve/calls/CallResolver", "doResolveCall"));
        }
        if (context.checkArguments == CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS) {
            this.argumentTypeResolver.analyzeArgumentsAndRecordTypes(context);
        }
        List<KtTypeProjection> typeArguments = context.call.getTypeArguments();
        for (KtTypeProjection projection : typeArguments) {
            KotlinType type2;
            if (projection.getProjectionKind() != KtProjectionKind.NONE) {
                context.trace.report(Errors.PROJECTION_ON_NON_CLASS_TYPE_ARGUMENT.on(projection));
                ModifierCheckerCore.INSTANCE.check(projection, context.trace, null);
            }
            if ((type2 = this.argumentTypeResolver.resolveTypeRefWithDefault(projection.getTypeReference(), context.scope, context.trace, null)) == null) continue;
            ForceResolveUtil.forceResolveAllContents(type2);
        }
        if (contextForMigration.resolveKind != ResolveKind.GIVEN_CANDIDATES && useNewResolve) {
            assert (contextForMigration.name != null);
            OverloadResolutionResultsImpl<?> overloadResolutionResultsImpl = this.newCallResolver.runResolve(context, contextForMigration.name, contextForMigration.resolveKind, tracing);
            if (overloadResolutionResultsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "doResolveCall"));
            }
            return overloadResolutionResultsImpl;
        }
        OverloadResolutionResultsImpl overloadResolutionResultsImpl = this.doResolveCall(context, contextForMigration.lazyTasks.invoke(), contextForMigration.callTransformer, tracing);
        if (overloadResolutionResultsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "doResolveCall"));
        }
        return overloadResolutionResultsImpl;
    }

    @NotNull
    private <D extends CallableDescriptor, F extends D> OverloadResolutionResultsImpl<F> doResolveCall(@NotNull BasicCallResolutionContext context, @NotNull List<ResolutionTask<D, F>> prioritizedTasks, @NotNull CallTransformer<D, F> callTransformer, @NotNull TracingStrategy tracing) {
        OverloadResolutionResultsImpl results;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallResolver", "doResolveCall"));
        }
        if (prioritizedTasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prioritizedTasks", "org/jetbrains/kotlin/resolve/calls/CallResolver", "doResolveCall"));
        }
        if (callTransformer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callTransformer", "org/jetbrains/kotlin/resolve/calls/CallResolver", "doResolveCall"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/kotlin/resolve/calls/CallResolver", "doResolveCall"));
        }
        ArrayList allCandidates = Lists.newArrayList();
        OverloadResolutionResultsImpl<Object> successfulResults = null;
        TemporaryBindingTrace traceForFirstNonemptyCandidateSet = null;
        OverloadResolutionResultsImpl<Object> resultsForFirstNonemptyCandidateSet = null;
        for (ResolutionTask<D, F> task : prioritizedTasks) {
            boolean updateResults;
            if (task.getCandidates().isEmpty()) continue;
            TemporaryBindingTrace taskTrace = TemporaryBindingTrace.create(context.trace, "trace to resolve a task for", task.call.getCalleeExpression());
            OverloadResolutionResultsImpl<F> results2 = this.performResolution((ResolutionTask)task.replaceBindingTrace(taskTrace), callTransformer);
            allCandidates.addAll(task.getResolvedCalls());
            if (successfulResults != null) continue;
            if (results2.isSuccess() || results2.isAmbiguity()) {
                taskTrace.commit();
                successfulResults = results2;
            }
            if (results2.getResultCode() == OverloadResolutionResults.Code.INCOMPLETE_TYPE_INFERENCE) {
                results2.setTrace(taskTrace);
                successfulResults = results2;
            }
            boolean bl = updateResults = traceForFirstNonemptyCandidateSet == null || resultsForFirstNonemptyCandidateSet.getResultCode() == OverloadResolutionResults.Code.CANDIDATES_WITH_WRONG_RECEIVER && results2.getResultCode() != OverloadResolutionResults.Code.CANDIDATES_WITH_WRONG_RECEIVER;
            if (!task.getCandidates().isEmpty() && !results2.isNothing() && updateResults) {
                traceForFirstNonemptyCandidateSet = taskTrace;
                resultsForFirstNonemptyCandidateSet = results2;
            }
            if (successfulResults == null || context.collectAllCandidates) continue;
            break;
        }
        if (successfulResults != null) {
            results = successfulResults;
        } else if (traceForFirstNonemptyCandidateSet == null) {
            tracing.unresolvedReference(context.trace);
            this.argumentTypeResolver.checkTypesWithNoCallee(context, ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS);
            results = OverloadResolutionResultsImpl.nameNotFound();
        } else {
            traceForFirstNonemptyCandidateSet.commit();
            results = resultsForFirstNonemptyCandidateSet;
        }
        results.setAllCandidates(context.collectAllCandidates ? allCandidates : null);
        OverloadResolutionResultsImpl overloadResolutionResultsImpl = results;
        if (overloadResolutionResultsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "doResolveCall"));
        }
        return overloadResolutionResultsImpl;
    }

    @NotNull
    private <D extends CallableDescriptor, F extends D> OverloadResolutionResultsImpl<F> performResolution(@NotNull ResolutionTask<D, F> task, @NotNull CallTransformer<D, F> callTransformer) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/kotlin/resolve/calls/CallResolver", "performResolution"));
        }
        if (callTransformer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callTransformer", "org/jetbrains/kotlin/resolve/calls/CallResolver", "performResolution"));
        }
        CandidateResolveMode mode = task.collectAllCandidates ? CandidateResolveMode.FULLY : CandidateResolveMode.EXIT_ON_FIRST_ERROR;
        List<CallCandidateResolutionContext<D>> contexts = this.collectCallCandidateContext(task, callTransformer, mode);
        boolean isSuccess = ContainerUtil.exists(contexts, new Condition<CallCandidateResolutionContext<D>>(){

            @Override
            public boolean value(CallCandidateResolutionContext<D> context) {
                return context.candidateCall.getStatus().possibleTransformToSuccess();
            }
        });
        if (!isSuccess && mode == CandidateResolveMode.EXIT_ON_FIRST_ERROR) {
            contexts = this.collectCallCandidateContext(task, callTransformer, CandidateResolveMode.FULLY);
        }
        for (CallCandidateResolutionContext<D> context : contexts) {
            this.addResolvedCall(task, callTransformer, context);
        }
        OverloadResolutionResultsImpl results = this.resolutionResultsHandler.computeResultAndReportErrors(task, task.tracing, task.getResolvedCalls());
        if (!results.isSingleResult() && !results.isIncomplete()) {
            this.argumentTypeResolver.checkTypesWithNoCallee(task.toBasic());
        }
        OverloadResolutionResultsImpl overloadResolutionResultsImpl = results;
        if (overloadResolutionResultsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "performResolution"));
        }
        return overloadResolutionResultsImpl;
    }

    @NotNull
    private <D extends CallableDescriptor, F extends D> List<CallCandidateResolutionContext<D>> collectCallCandidateContext(final @NotNull ResolutionTask<D, F> task, final @NotNull CallTransformer<D, F> callTransformer, final @NotNull CandidateResolveMode candidateResolveMode) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/kotlin/resolve/calls/CallResolver", "collectCallCandidateContext"));
        }
        if (callTransformer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callTransformer", "org/jetbrains/kotlin/resolve/calls/CallResolver", "collectCallCandidateContext"));
        }
        if (candidateResolveMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateResolveMode", "org/jetbrains/kotlin/resolve/calls/CallResolver", "collectCallCandidateContext"));
        }
        final ArrayList<CallCandidateResolutionContext<D>> candidateResolutionContexts = ContainerUtil.newArrayList();
        for (final ResolutionCandidate<D> resolutionCandidate : task.getCandidates()) {
            if (DeprecationUtilKt.isHiddenInResolution(resolutionCandidate.getDescriptor())) continue;
            candidatePerfCounter.time(new Function0<Unit>(){

                @Override
                public Unit invoke() {
                    TemporaryBindingTrace candidateTrace = TemporaryBindingTrace.create(task.trace, "trace to resolve candidate");
                    Collection contexts = callTransformer.createCallContexts(resolutionCandidate, task, candidateTrace, candidateResolveMode);
                    for (CallCandidateResolutionContext context : contexts) {
                        CallResolver.this.candidateResolver.performResolutionForCandidateCall(context, task.checkArguments);
                        candidateResolutionContexts.add(context);
                    }
                    return Unit.INSTANCE;
                }
            });
        }
        ArrayList<CallCandidateResolutionContext<D>> arrayList = candidateResolutionContexts;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "collectCallCandidateContext"));
        }
        return arrayList;
    }

    private <D extends CallableDescriptor, F extends D> void addResolvedCall(@NotNull ResolutionTask<D, F> task, @NotNull CallTransformer<D, F> callTransformer, @NotNull CallCandidateResolutionContext<D> context) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/kotlin/resolve/calls/CallResolver", "addResolvedCall"));
        }
        if (callTransformer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callTransformer", "org/jetbrains/kotlin/resolve/calls/CallResolver", "addResolvedCall"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallResolver", "addResolvedCall"));
        }
        task.tracing.bindReference(context.candidateCall.getTrace(), context.candidateCall);
        Collection<MutableResolvedCall<F>> resolvedCalls = callTransformer.transformCall(context, this, task);
        for (MutableResolvedCall<F> resolvedCall : resolvedCalls) {
            DelegatingBindingTrace trace = resolvedCall.getTrace();
            task.tracing.bindReference(trace, resolvedCall);
            task.tracing.bindResolvedCall(trace, resolvedCall);
            task.addResolvedCall(resolvedCall);
        }
    }

    public static enum ResolveKind {
        FUNCTION,
        INVOKE,
        VARIABLE,
        CALLABLE_REFERENCE,
        GIVEN_CANDIDATES;

    }

    private static class TaskContextForMigration<D extends CallableDescriptor, F extends D> {
        @NotNull
        final Function0<List<ResolutionTask<D, F>>> lazyTasks;
        @NotNull
        final CallTransformer<D, F> callTransformer;
        @Nullable
        final Name name;
        @Nullable
        final Collection<ResolutionCandidate<D>> givenCandidates;
        @NotNull
        final ResolveKind resolveKind;

        private TaskContextForMigration(@NotNull ResolveKind kind, @NotNull CallTransformer<D, F> transformer, @Nullable Name name, @Nullable Collection<ResolutionCandidate<D>> candidates, @NotNull Function0<List<ResolutionTask<D, F>>> tasks) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/resolve/calls/CallResolver$TaskContextForMigration", "<init>"));
            }
            if (transformer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transformer", "org/jetbrains/kotlin/resolve/calls/CallResolver$TaskContextForMigration", "<init>"));
            }
            if (tasks == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasks", "org/jetbrains/kotlin/resolve/calls/CallResolver$TaskContextForMigration", "<init>"));
            }
            this.lazyTasks = tasks;
            this.callTransformer = transformer;
            this.name = name;
            this.givenCandidates = candidates;
            this.resolveKind = kind;
        }
    }
}

