/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.dvcs.branch.DvcsTaskHandler;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitLocalBranch;
import git4idea.branch.GitBrancher;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.validators.GitRefNameValidator;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitTaskHandler
extends DvcsTaskHandler<GitRepository> {
    @NotNull
    private final GitBrancher myBrancher;
    @NotNull
    private final GitRefNameValidator myNameValidator;

    public GitTaskHandler(@NotNull GitBrancher brancher, @NotNull GitRepositoryManager repositoryManager, @NotNull Project project) {
        if (brancher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "brancher", "git4idea/GitTaskHandler", "<init>"));
        }
        if (repositoryManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryManager", "git4idea/GitTaskHandler", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/GitTaskHandler", "<init>"));
        }
        super((AbstractRepositoryManager)repositoryManager, project, "branch");
        this.myBrancher = brancher;
        this.myNameValidator = GitRefNameValidator.getInstance();
    }

    protected void checkout(@NotNull String taskName, @NotNull List<GitRepository> repos, @Nullable Runnable callInAwtLater) {
        if (taskName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskName", "git4idea/GitTaskHandler", "checkout"));
        }
        if (repos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repos", "git4idea/GitTaskHandler", "checkout"));
        }
        this.myBrancher.checkout(taskName, false, repos, callInAwtLater);
    }

    protected void checkoutAsNewBranch(@NotNull String name, @NotNull List<GitRepository> repositories) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "git4idea/GitTaskHandler", "checkoutAsNewBranch"));
        }
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/GitTaskHandler", "checkoutAsNewBranch"));
        }
        this.myBrancher.checkoutNewBranch(name, repositories);
    }

    protected String getActiveBranch(GitRepository repository) {
        return repository.getCurrentBranchName();
    }

    protected void mergeAndClose(@NotNull String branch, @NotNull List<GitRepository> repositories) {
        if (branch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branch", "git4idea/GitTaskHandler", "mergeAndClose"));
        }
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/GitTaskHandler", "mergeAndClose"));
        }
        this.myBrancher.merge(branch, GitBrancher.DeleteOnMergeOption.DELETE, repositories);
    }

    protected boolean hasBranch(@NotNull GitRepository repository, @NotNull String name) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/GitTaskHandler", "hasBranch"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "git4idea/GitTaskHandler", "hasBranch"));
        }
        return repository.getBranches().findLocalBranch(name) != null;
    }

    @NotNull
    protected Collection<String> getAllBranches(@NotNull GitRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/GitTaskHandler", "getAllBranches"));
        }
        List list = ContainerUtil.map(repository.getBranches().getLocalBranches(), (Function)new Function<GitLocalBranch, String>(){

            public String fun(GitLocalBranch branch) {
                return branch.getName();
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitTaskHandler", "getAllBranches"));
        }
        return list;
    }

    public boolean isBranchNameValid(@NotNull String branchName) {
        if (branchName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "git4idea/GitTaskHandler", "isBranchNameValid"));
        }
        return this.myNameValidator.checkInput(branchName);
    }

    @NotNull
    public String cleanUpBranchName(@NotNull String suggestedName) {
        if (suggestedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suggestedName", "git4idea/GitTaskHandler", "cleanUpBranchName"));
        }
        String string = this.myNameValidator.cleanUpBranchName(suggestedName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitTaskHandler", "cleanUpBranchName"));
        }
        return string;
    }
}

