/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.dvcs.push.VcsPushOptionValue;
import com.intellij.dvcs.push.VcsPushOptionsPanel;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBCheckBox;
import git4idea.push.GitPushTagMode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitPushTagPanel
extends VcsPushOptionsPanel {
    private final ComboBox myCombobox;
    private final JBCheckBox myCheckBox;

    public GitPushTagPanel(@Nullable GitPushTagMode defaultMode, boolean followTagsSupported) {
        String checkboxText = "Push Tags";
        if (followTagsSupported) {
            checkboxText = checkboxText + ": ";
        }
        this.myCheckBox = new JBCheckBox(checkboxText);
        this.myCheckBox.setMnemonic('T');
        this.myCheckBox.setSelected(defaultMode != null);
        this.setLayout(new BorderLayout());
        this.add((Component)this.myCheckBox, "West");
        if (followTagsSupported) {
            this.myCombobox = new ComboBox(GitPushTagMode.getValues());
            this.myCombobox.setRenderer((ListCellRenderer)new ListCellRendererWrapper<GitPushTagMode>(){

                public void customize(JList list, GitPushTagMode value, int index, boolean selected, boolean hasFocus) {
                    this.setText(value.getTitle());
                }
            });
            this.myCombobox.setEnabled(this.myCheckBox.isSelected());
            if (defaultMode != null) {
                this.myCombobox.setSelectedItem((Object)defaultMode);
            }
            this.myCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(@NotNull ActionEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "git4idea/push/GitPushTagPanel$2", "actionPerformed"));
                    }
                    GitPushTagPanel.this.myCombobox.setEnabled(GitPushTagPanel.this.myCheckBox.isSelected());
                }
            });
            this.add((Component)this.myCombobox, "Center");
        } else {
            this.myCombobox = null;
        }
    }

    @Nullable
    public VcsPushOptionValue getValue() {
        return this.myCheckBox.isSelected() ? (this.myCombobox == null ? GitPushTagMode.ALL : (VcsPushOptionValue)this.myCombobox.getSelectedItem()) : null;
    }
}

