/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.vcsUtil.VcsImplUtil;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerAdapter;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.update.GitFetchResult;
import git4idea.util.GitUIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitFetcher {
    private static final Logger LOG = Logger.getInstance(GitFetcher.class);
    private final Project myProject;
    private final GitRepositoryManager myRepositoryManager;
    private final ProgressIndicator myProgressIndicator;
    private final boolean myFetchAll;
    private final GitVcs myVcs;
    private final Collection<Exception> myErrors;

    public GitFetcher(@NotNull Project project, @NotNull ProgressIndicator progressIndicator, boolean fetchAll) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/update/GitFetcher", "<init>"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "git4idea/update/GitFetcher", "<init>"));
        }
        this.myErrors = new ArrayList<Exception>();
        this.myProject = project;
        this.myProgressIndicator = progressIndicator;
        this.myFetchAll = fetchAll;
        this.myRepositoryManager = GitUtil.getRepositoryManager(this.myProject);
        this.myVcs = GitVcs.getInstance(project);
    }

    public GitFetchResult fetch(@NotNull GitRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/update/GitFetcher", "fetch"));
        }
        GitFetchResult fetchResult = GitFetchResult.success();
        if (!this.myFetchAll) {
            return this.fetchCurrentRemote(repository);
        }
        fetchResult = this.fetchAll(repository, fetchResult);
        repository.getRepositoryFiles().refresh(false);
        return fetchResult;
    }

    @NotNull
    public GitFetchResult fetch(@NotNull VirtualFile root, @NotNull String remoteName, @Nullable String branch) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/update/GitFetcher", "fetch"));
        }
        if (remoteName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteName", "git4idea/update/GitFetcher", "fetch"));
        }
        GitRepository repository = (GitRepository)this.myRepositoryManager.getRepositoryForRoot(root);
        if (repository == null) {
            GitFetchResult gitFetchResult = GitFetcher.logError("Repository can't be null for " + root, ((Object)((Object)this.myRepositoryManager)).toString());
            if (gitFetchResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitFetcher", "fetch"));
            }
            return gitFetchResult;
        }
        GitRemote remote = GitUtil.findRemoteByName(repository, remoteName);
        if (remote == null) {
            GitFetchResult gitFetchResult = GitFetcher.logError("Couldn't find remote with the name " + remoteName, null);
            if (gitFetchResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitFetcher", "fetch"));
            }
            return gitFetchResult;
        }
        GitFetchResult gitFetchResult = this.fetchRemote(repository, remote, branch);
        if (gitFetchResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitFetcher", "fetch"));
        }
        return gitFetchResult;
    }

    private static GitFetchResult logError(@NotNull String message, @Nullable String additionalInfo) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "git4idea/update/GitFetcher", "logError"));
        }
        String addInfo = additionalInfo != null ? "\n" + additionalInfo : "";
        LOG.error(message + addInfo);
        return GitFetchResult.error(message);
    }

    @NotNull
    private GitFetchResult fetchCurrentRemote(@NotNull GitRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/update/GitFetcher", "fetchCurrentRemote"));
        }
        FetchParams fetchParams = GitFetcher.getFetchParams(repository);
        if (fetchParams.isError()) {
            GitFetchResult gitFetchResult = fetchParams.getError();
            if (gitFetchResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitFetcher", "fetchCurrentRemote"));
            }
            return gitFetchResult;
        }
        GitRemote remote = fetchParams.getRemote();
        GitFetchResult gitFetchResult = this.fetchRemote(repository, remote, null);
        if (gitFetchResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitFetcher", "fetchCurrentRemote"));
        }
        return gitFetchResult;
    }

    @NotNull
    private GitFetchResult fetchRemote(@NotNull GitRepository repository, @NotNull GitRemote remote, @Nullable String branch) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/update/GitFetcher", "fetchRemote"));
        }
        if (remote == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remote", "git4idea/update/GitFetcher", "fetchRemote"));
        }
        GitFetchResult gitFetchResult = GitFetcher.fetchNatively(repository, remote, branch);
        if (gitFetchResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitFetcher", "fetchRemote"));
        }
        return gitFetchResult;
    }

    @NotNull
    private GitFetchResult fetchCurrentBranch(@NotNull GitRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/update/GitFetcher", "fetchCurrentBranch"));
        }
        FetchParams fetchParams = GitFetcher.getFetchParams(repository);
        if (fetchParams.isError()) {
            GitFetchResult gitFetchResult = fetchParams.getError();
            if (gitFetchResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitFetcher", "fetchCurrentBranch"));
            }
            return gitFetchResult;
        }
        GitRemote remote = fetchParams.getRemote();
        String remoteBranch = fetchParams.getRemoteBranch().getNameForRemoteOperations();
        GitFetchResult gitFetchResult = GitFetcher.fetchNatively(repository, remote, remoteBranch);
        if (gitFetchResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitFetcher", "fetchCurrentBranch"));
        }
        return gitFetchResult;
    }

    @NotNull
    private static FetchParams getFetchParams(@NotNull GitRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/update/GitFetcher", "getFetchParams"));
        }
        GitLocalBranch currentBranch = repository.getCurrentBranch();
        if (currentBranch == null) {
            String message = "Current branch can't be null here. \nRepository: " + repository;
            LOG.error(message);
            FetchParams fetchParams = new FetchParams(GitFetchResult.error(new Exception(message)));
            if (fetchParams == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitFetcher", "getFetchParams"));
            }
            return fetchParams;
        }
        GitBranchTrackInfo trackInfo = GitBranchUtil.getTrackInfoForBranch(repository, currentBranch);
        if (trackInfo == null) {
            String message = "Tracked info is null for branch " + currentBranch + "\n Repository: " + repository;
            LOG.error(message);
            FetchParams fetchParams = new FetchParams(GitFetchResult.error(new Exception(message)));
            if (fetchParams == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitFetcher", "getFetchParams"));
            }
            return fetchParams;
        }
        GitRemote remote = trackInfo.getRemote();
        FetchParams fetchParams = new FetchParams(remote, trackInfo.getRemoteBranch());
        if (fetchParams == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitFetcher", "getFetchParams"));
        }
        return fetchParams;
    }

    @NotNull
    private GitFetchResult fetchAll(@NotNull GitRepository repository, @NotNull GitFetchResult fetchResult) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/update/GitFetcher", "fetchAll"));
        }
        if (fetchResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fetchResult", "git4idea/update/GitFetcher", "fetchAll"));
        }
        for (GitRemote remote : repository.getRemotes()) {
            String url = remote.getFirstUrl();
            if (url == null) {
                LOG.error("URL is null for remote " + remote.getName());
                continue;
            }
            GitFetchResult res = GitFetcher.fetchNatively(repository, remote, null);
            res.addPruneInfo(fetchResult.getPrunedRefs());
            fetchResult = res;
            if (fetchResult.isSuccess()) continue;
            break;
        }
        GitFetchResult gitFetchResult = fetchResult;
        if (gitFetchResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitFetcher", "fetchAll"));
        }
        return gitFetchResult;
    }

    @NotNull
    private static GitFetchResult fetchNatively(@NotNull GitRepository repository, @NotNull GitRemote remote, @Nullable String branch) {
        String[] stringArray;
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/update/GitFetcher", "fetchNatively"));
        }
        if (remote == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remote", "git4idea/update/GitFetcher", "fetchNatively"));
        }
        Git git = (Git)ServiceManager.getService(Git.class);
        if (branch != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = GitFetcher.getFetchSpecForBranch(branch, remote.getName());
        } else {
            stringArray = ArrayUtil.EMPTY_STRING_ARRAY;
        }
        String[] additionalParams = stringArray;
        GitFetchPruneDetector pruneDetector = new GitFetchPruneDetector();
        GitCommandResult result = git.fetch(repository, remote, Collections.singletonList(pruneDetector), additionalParams);
        GitFetchResult fetchResult = result.success() ? GitFetchResult.success() : (result.cancelled() ? GitFetchResult.cancel() : GitFetchResult.error(result.getErrorOutputAsJoinedString()));
        fetchResult.addPruneInfo(pruneDetector.getPrunedRefs());
        GitFetchResult gitFetchResult = fetchResult;
        if (gitFetchResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitFetcher", "fetchNatively"));
        }
        return gitFetchResult;
    }

    private static String getRidOfPrefixIfExists(String branch) {
        if (branch.startsWith("refs/heads/")) {
            return branch.substring("refs/heads/".length());
        }
        return branch;
    }

    @NotNull
    public static String getFetchSpecForBranch(@NotNull String branch, @NotNull String remoteName) {
        if (branch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branch", "git4idea/update/GitFetcher", "getFetchSpecForBranch"));
        }
        if (remoteName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteName", "git4idea/update/GitFetcher", "getFetchSpecForBranch"));
        }
        branch = GitFetcher.getRidOfPrefixIfExists(branch);
        String string = "refs/heads/" + branch + ":" + "refs/remotes/" + remoteName + "/" + branch;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitFetcher", "getFetchSpecForBranch"));
        }
        return string;
    }

    @NotNull
    public Collection<Exception> getErrors() {
        Collection<Exception> collection = this.myErrors;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitFetcher", "getErrors"));
        }
        return collection;
    }

    public static void displayFetchResult(@NotNull Project project, @NotNull GitFetchResult result, @Nullable String errorNotificationTitle, @NotNull Collection<? extends Exception> errors) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/update/GitFetcher", "displayFetchResult"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "git4idea/update/GitFetcher", "displayFetchResult"));
        }
        if (errors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "git4idea/update/GitFetcher", "displayFetchResult"));
        }
        if (result.isSuccess()) {
            VcsNotifier.getInstance((Project)project).notifySuccess("Fetched successfully" + result.getAdditionalInfo());
        } else if (result.isCancelled()) {
            VcsNotifier.getInstance((Project)project).notifyMinorWarning("", "Fetch cancelled by user" + result.getAdditionalInfo());
        } else if (result.isNotAuthorized()) {
            String description;
            String title;
            if (errorNotificationTitle != null) {
                title = errorNotificationTitle;
                description = "Fetch failed: couldn't authorize";
            } else {
                title = "Fetch failed";
                description = "Couldn't authorize";
            }
            description = description + result.getAdditionalInfo();
            GitUIUtil.notifyMessage(project, title, description, true, null);
        } else {
            GitVcs instance = GitVcs.getInstance(project);
            if (instance != null && instance.getExecutableValidator().isExecutableValid()) {
                GitUIUtil.notifyMessage(project, "Fetch failed", result.getAdditionalInfo(), true, errors);
            }
        }
    }

    public boolean fetchRootsAndNotify(@NotNull Collection<GitRepository> roots, @Nullable String errorNotificationTitle, boolean notifySuccess) {
        String addInfo;
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "git4idea/update/GitFetcher", "fetchRootsAndNotify"));
        }
        HashMap<VirtualFile, String> additionalInfo = new HashMap<VirtualFile, String>();
        for (GitRepository repository : roots) {
            LOG.info("fetching " + repository);
            GitFetchResult result = this.fetch(repository);
            String ai = result.getAdditionalInfo();
            if (!StringUtil.isEmptyOrSpaces((String)ai)) {
                additionalInfo.put(repository.getRoot(), ai);
            }
            if (result.isSuccess()) continue;
            ArrayList<Exception> errors = new ArrayList<Exception>(this.getErrors());
            errors.addAll(result.getErrors());
            GitFetcher.displayFetchResult(this.myProject, result, errorNotificationTitle, errors);
            return false;
        }
        if (notifySuccess) {
            VcsNotifier.getInstance((Project)this.myProject).notifySuccess("Fetched successfully");
        }
        if (!StringUtil.isEmptyOrSpaces((String)(addInfo = this.makeAdditionalInfoByRoot(additionalInfo)))) {
            VcsNotifier.getInstance((Project)this.myProject).notifyMinorInfo("Fetch details", addInfo);
        }
        return true;
    }

    @NotNull
    private String makeAdditionalInfoByRoot(@NotNull Map<VirtualFile, String> additionalInfo) {
        if (additionalInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalInfo", "git4idea/update/GitFetcher", "makeAdditionalInfoByRoot"));
        }
        if (additionalInfo.isEmpty()) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitFetcher", "makeAdditionalInfoByRoot"));
            }
            return "";
        }
        StringBuilder info = new StringBuilder();
        if (this.myRepositoryManager.moreThanOneRoot()) {
            for (Map.Entry<VirtualFile, String> entry : additionalInfo.entrySet()) {
                info.append(entry.getValue()).append(" in ").append(VcsImplUtil.getShortVcsRootName((Project)this.myProject, (VirtualFile)entry.getKey())).append("<br/>");
            }
        } else {
            info.append(additionalInfo.values().iterator().next());
        }
        String string = info.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitFetcher", "makeAdditionalInfoByRoot"));
        }
        return string;
    }

    private static class FetchParams {
        private GitRemote myRemote;
        private GitRemoteBranch myRemoteBranch;
        private GitFetchResult myError;

        FetchParams(GitFetchResult error) {
            this.myError = error;
        }

        FetchParams(GitRemote remote, GitRemoteBranch remoteBranch) {
            this.myRemote = remote;
            this.myRemoteBranch = remoteBranch;
        }

        boolean isError() {
            return this.myError != null;
        }

        public GitFetchResult getError() {
            return this.myError;
        }

        public GitRemote getRemote() {
            return this.myRemote;
        }

        public GitRemoteBranch getRemoteBranch() {
            return this.myRemoteBranch;
        }
    }

    private static class GitFetchPruneDetector
    extends GitLineHandlerAdapter {
        private static final Pattern PRUNE_PATTERN = Pattern.compile("\\s*x\\s*\\[deleted\\].*->\\s*(\\S*)");
        @NotNull
        private final Collection<String> myPrunedRefs = new ArrayList<String>();

        private GitFetchPruneDetector() {
        }

        @Override
        public void onLineAvailable(String line, Key outputType) {
            Matcher matcher = PRUNE_PATTERN.matcher(line);
            if (matcher.matches()) {
                this.myPrunedRefs.add(matcher.group(1));
            }
        }

        @NotNull
        public Collection<String> getPrunedRefs() {
            Collection<String> collection = this.myPrunedRefs;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitFetcher$GitFetchPruneDetector", "getPrunedRefs"));
            }
            return collection;
        }
    }
}

