/*
 * Decompiled with CFR 0.152.
 */
package spantable;

import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JTable;
import javax.swing.plaf.TableUI;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import spantable.CellSpanModel;
import spantable.CellSpanTableUI;

public class CellSpanTable
extends JTable {
    public CellSpanTable() {
        this.getTableHeader().setReorderingAllowed(false);
    }

    public Rectangle getCellRect(int row, int column, boolean includeSpacing) {
        Rectangle rect = super.getCellRect(row, column, includeSpacing);
        if (column >= this.getColumnModel().getColumnCount()) {
            return rect;
        }
        int modelRow = this.convertRowIndexToModel(row);
        int modelColumn = this.convertColumnIndexToModel(column);
        int cols = this.getColumnSpan(modelRow, modelColumn);
        int rows = this.getRowSpan(modelRow, modelColumn);
        if (cols == 0 || rows == 0) {
            rect.x += rect.width;
            rect.y += rect.height;
            rect.width = 0;
            rect.height = 0;
        } else {
            for (int c = column + 1; c < column + cols; ++c) {
                rect.width += this.getColumnModel().getColumn(c).getWidth();
            }
            for (int r = row + 1; r < row + rows; ++r) {
                rect.height += this.getRowHeight(r);
            }
        }
        return rect;
    }

    public int rowAtPoint(Point point) {
        int rows;
        int viewColumn = super.columnAtPoint(point);
        int viewRow = super.rowAtPoint(point);
        if (viewRow < 0 || viewColumn < 0) {
            return viewRow;
        }
        int modelColumn = this.convertColumnIndexToModel(viewColumn);
        int modelRow = this.convertRowIndexToModel(viewRow);
        do {
            if ((rows = this.getRowSpan(modelRow, modelColumn)) >= 1) continue;
            --modelRow;
        } while (rows < 1);
        return this.convertRowIndexToView(modelRow);
    }

    public int columnAtPoint(Point point) {
        int cols;
        int viewColumn = super.columnAtPoint(point);
        int viewRow = super.rowAtPoint(point);
        if (viewRow < 0 || viewColumn < 0) {
            return viewColumn;
        }
        int modelColumn = this.convertColumnIndexToModel(viewColumn);
        int modelRow = this.convertRowIndexToModel(viewRow);
        do {
            if ((cols = this.getColumnSpan(modelRow, modelColumn)) >= 1) continue;
            --modelColumn;
        } while (cols < 1);
        return this.convertColumnIndexToView(modelColumn);
    }

    public int getRowSpan(int row, int column) {
        TableModel model = this.getModel();
        if (model instanceof CellSpanModel) {
            return ((CellSpanModel)model).getRowSpan(row, column);
        }
        return 1;
    }

    public int getColumnSpan(int row, int column) {
        TableModel model = this.getModel();
        if (model instanceof CellSpanModel) {
            return ((CellSpanModel)model).getColumnSpan(row, column);
        }
        return 1;
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        int modelColumn;
        TableModel model = this.getModel();
        if (!(model instanceof CellSpanModel)) {
            return super.getCellRenderer(row, column);
        }
        int modelRow = this.convertRowIndexToModel(row);
        TableCellRenderer renderer = this.getDefaultRenderer(((CellSpanModel)model).getCellClass(modelRow, modelColumn = this.convertColumnIndexToModel(column)));
        if (renderer != null) {
            return renderer;
        }
        return super.getCellRenderer(row, column);
    }

    public TableCellEditor getCellEditor(int row, int column) {
        int modelColumn;
        TableModel model = this.getModel();
        if (!(model instanceof CellSpanModel)) {
            return super.getCellEditor(row, column);
        }
        int modelRow = this.convertRowIndexToModel(row);
        TableCellEditor editor = this.getDefaultEditor(((CellSpanModel)model).getCellClass(modelRow, modelColumn = this.convertColumnIndexToModel(column)));
        if (editor != null) {
            return editor;
        }
        return super.getCellEditor(row, column);
    }

    public void setUI(TableUI ui) {
        super.setUI(new CellSpanTableUI());
    }
}

