/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.CompositeFileCollection;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnionFileCollection
extends CompositeFileCollection {
    private final Set<FileCollection> source;

    public UnionFileCollection(FileCollection ... source) {
        this(Arrays.asList(source));
    }

    public UnionFileCollection(Iterable<? extends FileCollection> source) {
        this.source = GUtil.addToCollection(new LinkedHashSet(), source);
    }

    @Override
    public String getDisplayName() {
        return "file collection";
    }

    public Set<FileCollection> getSources() {
        return this.source;
    }

    @Override
    public FileCollection add(FileCollection collection) {
        this.source.add(collection);
        return this;
    }

    @Override
    public void visitContents(FileCollectionResolveContext context) {
        context.add(this.source);
    }
}

